/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.naming.NamingException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.jaxb.runtime.marshaller.NamespacePrefixMapper;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionAutoRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionCallRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.bean.SessionState;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.modules.inet.common.bean.AccountingTrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.event.accounting.InetConnectionCommandEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaStateModifyEvent;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNas;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNasConnection;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

class AccountingCommands {
    private static final Logger logger = LogManager.getLogger();

    AccountingCommands() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onSingleConnectionCommand(Accounting accounting, EventListenerContext ctx, InetConnectionCommandEvent e) throws BGException {
        InetConnectionRuntime connectionRuntime;
        String command;
        block20: {
            ConcurrentMap<Integer, InetConnectionAutoRuntime> deviceMap;
            int deviceId = e.getDeviceId();
            int servId = e.getServId();
            long connectionId = e.getConnectionId();
            command = e.getCommand();
            connectionRuntime = accounting.connectionMapCall.get(connectionId);
            if (connectionRuntime == null && (deviceMap = accounting.connectionMapAuto.getDeviceMap(deviceId)) != null) {
                connectionRuntime = (InetConnectionRuntime)((Object)deviceMap.get(servId));
            }
            if (connectionRuntime == null) {
                logger.warn("Connection not found for command " + command + " with connectionId=" + connectionId + ", deviceId=" + deviceId + ", servId=" + servId);
                if (e.getUserId() == 0) {
                    return;
                }
                throw new BGException("\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e (connectionId=" + connectionId + ", deviceId=" + deviceId + ", servId=" + servId + ")");
            }
            logger.info("Connection command " + command + " for inetConnection:" + connectionId);
            connectionRuntime.inetServRuntime.lock();
            try {
                InetConnection connection = connectionRuntime.connection;
                if ("close".equals(command)) {
                    EventProcessor.getInstance().publish((Event)new InetSaStateModifyEvent(accounting.moduleId, e.getUserId(), connection, InetServState.STATE_DISABLE.getCode(), AccessCode.TOO_MANY_SESSIONS_ERROR.getCode()));
                    break block20;
                }
                if ("stop".equals(command)) {
                    connectionRuntime.forceStop(accounting, ctx.getConnectionSet(), System.currentTimeMillis(), true);
                    break block20;
                }
                if ("finish".equals(command)) {
                    try (BalanceDao balanceDao = new BalanceDao(ctx.getConnection());){
                        connectionRuntime.forceFinish(accounting, ctx.getConnectionSet(), balanceDao, true, System.currentTimeMillis());
                        break block20;
                    }
                }
                if ("enable".equals(command) && connectionRuntime instanceof InetConnectionCallRuntime) {
                    connectionRuntime.forceStop(accounting, ctx.getConnectionSet(), System.currentTimeMillis(), true);
                }
            }
            finally {
                connectionRuntime.inetServRuntime.unlock();
            }
        }
        if ("rebind".equals(command)) {
            AccountingCommands.rebindConnection(accounting, ctx.getConnectionSet(), connectionRuntime, e.getServId(), null, null);
            ctx.commit();
        } else if ("rebindEnable".equals(command)) {
            AccountingCommands.rebindConnection(accounting, ctx.getConnectionSet(), connectionRuntime, e.getServId(), InetServState.STATE_ENABLE.getCode(), null);
            ctx.commit();
        } else if (command != null && command.startsWith("rebind:")) {
            String[] params = command.split("\\s*:\\s*", -1);
            short deviceState = (short)Utils.parseInt((String)params[1], (int)InetServState.STATE_ENABLE.getCode());
            Set deviceOptions = params.length > 1 ? Utils.toIntegerSet((String)params[2]) : Collections.emptySet();
            AccountingCommands.rebindConnection(accounting, ctx.getConnectionSet(), connectionRuntime, e.getServId(), deviceState, deviceOptions);
            ctx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopConnectionsForDeviceId(Accounting accounting, ServerContext ctx, InetConnectionCommandEvent e, int deviceId, long timeout) {
        logger.info("stopAllForDeviceId: " + e.getDeviceId() + " and timeout: " + timeout + " min");
        timeout = (System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(timeout)) / 1000L;
        int count = 0;
        for (InetConnectionCallRuntime connectionRuntime : accounting.connectionMapCall.values()) {
            try {
                if (connectionRuntime.connection == null || connectionRuntime.connection.getDeviceId() != deviceId || connectionRuntime.connection.getConnectionStatus() >= 3 || connectionRuntime.lastAccountTime >= timeout) continue;
                if (connectionRuntime.inetServRuntime.tryLock(1L, TimeUnit.SECONDS)) {
                    try {
                        connectionRuntime.forceStop(accounting, ctx.getConnectionSet(), System.currentTimeMillis(), true);
                    }
                    finally {
                        connectionRuntime.inetServRuntime.unlock();
                    }
                }
                ctx.commit();
                ++count;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        logger.info("Stopped " + count + " connections");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void rebindConnection(Accounting accounting, ConnectionSet connectionSet, InetConnectionRuntime connectionRuntime, int servId, Short deviceState, Set<Integer> deviceOptions) throws BGException {
        HashMap<Integer, AccountingTrafficAmount> counterTraffics;
        InetConnection oldConnection;
        logger.info("Rebind connection " + connectionRuntime.connection + " to inetServ:" + servId);
        boolean nasConnection = false;
        HashMap serviceConnections = null;
        InetServRuntime inetServRuntime = accounting.inetServRuntimeMap.get(servId);
        if (inetServRuntime == null) {
            logger.error("InetServRuntime not found with id=" + servId + " for connectionId=" + connectionRuntime.connection.getId());
            return;
        }
        connectionRuntime.inetServRuntime.lock();
        try (BalanceDao balanceDao = new BalanceDao(connectionSet.getConnection());){
            oldConnection = connectionRuntime.connection;
            if (connectionRuntime.counterTraffics != null) {
                counterTraffics = new HashMap<Integer, AccountingTrafficAmount>(connectionRuntime.counterTraffics.size());
                for (Map.Entry<Integer, AccountingTrafficAmount> entry : connectionRuntime.counterTraffics.entrySet()) {
                    counterTraffics.put(entry.getKey(), new AccountingTrafficAmount(entry.getValue().amount));
                }
            } else {
                counterTraffics = null;
            }
            if (connectionRuntime instanceof InetConnectionCallRuntime && ((InetConnectionCallRuntime)connectionRuntime).nasConnection != null) {
                nasConnection = true;
                List<InetConnectionCallRuntime> serviceRuntimeConnections = ((InetConnectionCallRuntime)connectionRuntime).getServiceConnections();
                if (serviceRuntimeConnections != null && serviceRuntimeConnections.size() > 0) {
                    serviceConnections = new HashMap();
                    for (InetConnectionCallRuntime serviceRuntimeConnection : serviceRuntimeConnections) {
                        InetConnection serviceConnection = serviceRuntimeConnection.connection;
                        if (serviceConnection.getConnectionStatus() >= 3) continue;
                        if (serviceRuntimeConnection.counterTraffics != null) {
                            HashMap<Integer, AccountingTrafficAmount> serviceCounterTraffics = new HashMap<Integer, AccountingTrafficAmount>(serviceRuntimeConnection.counterTraffics.size());
                            for (Map.Entry e : serviceRuntimeConnection.counterTraffics.entrySet()) {
                                serviceCounterTraffics.put((Integer)e.getKey(), new AccountingTrafficAmount(((AccountingTrafficAmount)e.getValue()).amount));
                            }
                            serviceConnections.put(serviceConnection, serviceCounterTraffics);
                            continue;
                        }
                        serviceConnections.put(serviceConnection, Collections.emptyMap());
                    }
                }
            }
            connectionRuntime.forceFinish(accounting, connectionSet, balanceDao, true, System.currentTimeMillis());
        }
        finally {
            connectionRuntime.inetServRuntime.unlock();
        }
        InetConnection connection = oldConnection.clone();
        connection.setServId(servId);
        connection.setContractId(inetServRuntime.contractRuntime.contractId);
        InetConnection existConnnection = accounting.findExistConnection(connection);
        if (existConnnection != null) {
            logger.info("Found exist connection");
            return;
        }
        if (nasConnection) {
            RadiusProcessor processor = null;
            try {
                processor = (RadiusProcessor)Setup.getEnvironment().lookup("radiusProcessor");
            }
            catch (NamingException e) {
                try {
                    processor = (RadiusProcessor)Setup.getEnvironment().lookup("processor");
                }
                catch (NamingException serviceCounterTraffics) {
                    // empty catch block
                }
            }
            if (processor == null) {
                logger.info("Radius processor is null");
                Object var13_18 = null;
            } else {
                NasList nasList = processor.getNasList();
            }
        } else {
            Object var13_21 = null;
        }
        inetServRuntime.lock();
        try {
            InetNas nas;
            void var13_22;
            InetConnectionCallRuntime parentAccountingSession = connection.getParentConnectionId() > 0L ? accounting.connectionMapCall.get(connection.getParentConnectionId()) : null;
            connection.setId(0L);
            connection.setAccessCode(AccessCode.AUTHORIZATION_SUCCEEDED.getCode());
            if (deviceState != null) {
                connection.setDeviceState(deviceState.shortValue());
            }
            if (deviceOptions != null) {
                connection.setDeviceOptions(deviceOptions);
            }
            connection.setConnectionStart(new Date());
            InetConnectionCallRuntime connectionCallRuntime = accounting.connectionCallStart(connectionSet, true, connection, null, 0L, new Date(), (NasList<InetNasConnection, InetNas>)var13_22, inetServRuntime, parentAccountingSession, counterTraffics);
            if (var13_22 != null && (nas = (InetNas)var13_22.get(connection.getDeviceId())) != null) {
                nas.setConnection(connectionCallRuntime.nasConnection, connectionSet.getConnection(), connectionSet.getSlaveConnection());
            }
            if (serviceConnections != null) {
                for (Map.Entry e : serviceConnections.entrySet()) {
                    InetNas nas2;
                    Map serviceCounterTraffics;
                    InetConnection serviceConnection = (InetConnection)e.getKey();
                    serviceConnection.setId(0L);
                    serviceConnection.setAccessCode(AccessCode.AUTHORIZATION_SUCCEEDED.getCode());
                    if (serviceConnection.getConnectionStart() == null) {
                        serviceConnection.setConnectionStart(new Date());
                    }
                    if ((serviceCounterTraffics = (Map)e.getValue()).size() == 0) {
                        serviceCounterTraffics = null;
                    }
                    InetConnectionCallRuntime serviceConnectionCallRuntime = accounting.connectionCallStart(connectionSet, true, serviceConnection, null, 0L, new Date(), (NasList<InetNasConnection, InetNas>)var13_22, inetServRuntime, connectionCallRuntime, serviceCounterTraffics);
                    if (var13_22 == null || (nas2 = (InetNas)var13_22.get(serviceConnectionCallRuntime.connection.getDeviceId())) == null) continue;
                    nas2.setConnection(serviceConnectionCallRuntime.nasConnection, connectionSet.getConnection(), connectionSet.getSlaveConnection());
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            inetServRuntime.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveState(Accounting accounting, String fileName, boolean gzip, boolean flushAtStop) throws JAXBException, IOException, XMLStreamException, InterruptedException {
        OutputStream out;
        logger.debug("Saving state...");
        File stateFile = new File("data/state");
        stateFile.mkdirs();
        if (gzip) {
            stateFile = new File(stateFile, fileName + ".gzip");
            out = new FileOutputStream(stateFile);
            out = new GZIPOutputStream(out);
        } else {
            stateFile = new File(stateFile, fileName);
            out = new FileOutputStream(stateFile);
        }
        SessionState sessionState = new SessionState();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SessionState.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        XMLStreamWriter xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
        xmlWriter.writeStartDocument();
        xmlWriter.writeStartElement("data");
        xmlWriter.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xmlWriter.writeNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        xmlWriter.writeNamespace("common", "http://common.bitel.ru");
        try {
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapper(){

                public String[] getContextualNamespaceDecls() {
                    return new String[]{"", "", "xsi", "http://www.w3.org/2001/XMLSchema-instance", "xs", "http://www.w3.org/2001/XMLSchema", "common", "http://common.bitel.ru"};
                }

                public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
                    return null;
                }
            });
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (flushAtStop) {
            try {
                accounting.flushSessions();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        ArrayList<InetConnectionRuntime> lockedList = new ArrayList<InetConnectionRuntime>();
        for (InetConnectionRuntime inetConnectionRuntime : accounting.connectionMapAuto.iterable()) {
            if (inetConnectionRuntime.inetServRuntime.tryLock()) {
                try {
                    AccountingCommands.marshallAuto(xmlWriter, marshaller, inetConnectionRuntime, sessionState);
                    continue;
                }
                finally {
                    inetConnectionRuntime.inetServRuntime.unlock();
                    continue;
                }
            }
            lockedList.add(inetConnectionRuntime);
        }
        xmlWriter.flush();
        for (InetConnectionRuntime inetConnectionRuntime : lockedList) {
            if (!inetConnectionRuntime.inetServRuntime.tryLock(10L, TimeUnit.SECONDS)) continue;
            try {
                AccountingCommands.marshallAuto(xmlWriter, marshaller, inetConnectionRuntime, sessionState);
            }
            finally {
                inetConnectionRuntime.inetServRuntime.unlock();
            }
        }
        xmlWriter.flush();
        sessionState = new SessionState();
        lockedList.clear();
        for (InetConnectionRuntime inetConnectionRuntime : accounting.connectionMapCall.values()) {
            if (inetConnectionRuntime.inetServRuntime.tryLock()) {
                try {
                    AccountingCommands.marshallCall(xmlWriter, marshaller, inetConnectionRuntime, sessionState);
                    continue;
                }
                finally {
                    inetConnectionRuntime.inetServRuntime.unlock();
                    continue;
                }
            }
            lockedList.add(inetConnectionRuntime);
        }
        xmlWriter.flush();
        for (InetConnectionRuntime inetConnectionRuntime : lockedList) {
            if (!inetConnectionRuntime.inetServRuntime.tryLock(10L, TimeUnit.SECONDS)) continue;
            try {
                AccountingCommands.marshallCall(xmlWriter, marshaller, inetConnectionRuntime, sessionState);
            }
            finally {
                inetConnectionRuntime.inetServRuntime.unlock();
            }
        }
        xmlWriter.flush();
        lockedList.clear();
        lockedList = null;
        xmlWriter.writeEndElement();
        xmlWriter.writeEndDocument();
        xmlWriter.flush();
        if (out instanceof GZIPOutputStream) {
            ((GZIPOutputStream)out).finish();
        }
        out.flush();
        out.close();
    }

    private static void marshallCall(XMLStreamWriter xmlWriter, Marshaller marshaller, InetConnectionRuntime connectionRuntime, SessionState sessionState) throws JAXBException {
        sessionState.sessionId = connectionRuntime.sessionId;
        sessionState.trafficsDelta = connectionRuntime.trafficsDelta;
        sessionState.trafficDeltaCalculateAmount = connectionRuntime.trafficDeltaCalculateAmount;
        sessionState.trafficDeltaFlushAmount = connectionRuntime.trafficDeltaFlushAmount;
        sessionState.accountDelta = connectionRuntime.accountDelta;
        sessionState.sessionCostDelta = connectionRuntime.sessionCostDelta;
        marshaller.marshal((Object)sessionState, xmlWriter);
    }

    private static void marshallAuto(XMLStreamWriter xmlWriter, Marshaller marshaller, InetConnectionRuntime connectionRuntime, SessionState sessionState) throws JAXBException {
        InetConnection connection = connectionRuntime.connection;
        if (connection != null) {
            sessionState.servId = connectionRuntime.inetServId;
            sessionState.deviceId = connection.getDeviceId();
            sessionState.connectionId = connection.getId();
            sessionState.sessionId = connectionRuntime.sessionId;
            sessionState.trafficsDelta = connectionRuntime.trafficsDelta;
            sessionState.trafficDeltaCalculateAmount = connectionRuntime.trafficDeltaCalculateAmount;
            sessionState.trafficDeltaFlushAmount = connectionRuntime.trafficDeltaFlushAmount;
            sessionState.accountDelta = connectionRuntime.accountDelta;
            sessionState.sessionCostDelta = connectionRuntime.sessionCostDelta;
            marshaller.marshal((Object)sessionState, xmlWriter);
        }
    }
}

