/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.client.admin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.plugins.helpdesk.client.admin.ActionConfig;
import ru.bitel.bgbilling.plugins.helpdesk.client.admin.HelpDeskPackageEditor;
import ru.bitel.bgbilling.plugins.helpdesk.client.bean.PackageTableModel;
import ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.model.SearchResult;

public class HelpDeskPackageTab
extends BGUPanel {
    private JLabel recordCountLabel = new JLabel();
    private HelpDeskPackageEditor packageEditor = null;
    private PackageTableModel tableModel = new PackageTableModel();
    private BGControlPanelPages panelPages = new BGControlPanelPages();

    public HelpDeskPackageTab() {
        super(new ClientContext("ru.bitel.bgbilling.plugins.helpdesk", -1, -1, ActionConfig.class.getPackage().getName() + ".setup"));
    }

    protected void jbInit() throws Exception {
        this.panelPages.addPropertyChangeListener(event -> {
            String propertyName = event.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.performAction("refresh");
            }
        });
        BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
        this.setLayout(new GridBagLayout());
        this.add(this.getFilterPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        BGSwingUtilites.handleEdit((JTable)table, (BGUPanel)this, (String)"edit");
    }

    private JPanel getFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder("\u0424\u0438\u043b\u044c\u0442\u0440"));
        panel.add((Component)this.recordCountLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.panelPages, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private void initPackageEditor() {
        if (this.packageEditor == null) {
            this.packageEditor = new HelpDeskPackageEditor();
            this.packageEditor.setVisible(false);
            this.packageEditor.init(((ClientContext)this.getContext()).getModule(), -1);
            this.packageEditor.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    HelpDeskPackageTab.this.performAction("refresh");
                }
            });
            this.add((Component)((Object)this.packageEditor), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            SearchResult searchResult = ((HelpdeskService)((ClientContext)this.getContext()).getWebService(HelpdeskService.class)).packageList(null, this.panelPages.getPage());
            this.tableModel.setData(searchResult.getList());
            this.panelPages.setPage(searchResult.getPage());
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger((int)searchResult.getPage().getRecordCount()));
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.initPackageEditor();
            this.packageEditor.setId("-1");
            this.packageEditor.setData();
            this.packageEditor.setVisible(true);
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.tableModel.optSelectedRow().ifPresent(a -> {
            this.initPackageEditor();
            this.packageEditor.setId(String.valueOf(a.getId()));
            this.packageEditor.trySetData();
            this.packageEditor.setVisible(true);
        }));
    }
}

