/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.bean;

import bitel.billing.common.VersionInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.plugins.edo.server.bean.EdoBillFileGenerator;
import ru.bitel.bgbilling.plugins.edo.server.utils.EdoFnsXmlGenerator;
import ru.bitel.bgbilling.plugins.edo.server.utils.MissingDocParamException;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ScriptUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;

public abstract class FnsFileGenerator
implements EdoBillFileGenerator {
    protected BillDoc doc;
    protected Document xml;
    protected ScriptUtils scriptUtils;
    protected ParameterMap documentSetup;

    @Override
    public void init(Setup setup, Connection con, int billModuleId, ParameterMap billModuleSetup, ParameterMap documentSetup, BillDoc doc) throws Exception {
        this.doc = doc;
        this.xml = doc.getDocument();
        if (this.xml == null) {
            throw new BGException("error parse xml data invoice#" + doc.getId());
        }
        this.scriptUtils = new ScriptUtils((DefaultServerSetup)setup, con);
        this.documentSetup = documentSetup;
    }

    public abstract EdoFnsXmlGenerator getDocument() throws BGException;

    @Override
    public InputStream getFileContent() throws BGException {
        try {
            return new ByteArrayInputStream(this.getDocument().serialize("cp1251"));
        }
        catch (Exception e) {
            throw new BGException("error serialze document", (Throwable)e);
        }
    }

    protected String value(String nameValue, boolean required) throws Exception {
        String value = this.value_raw(nameValue, required);
        if (value == null) {
            return null;
        }
        if (value.startsWith("pid:")) {
            int pid = -1;
            try {
                pid = Integer.valueOf(value.substring(4));
            }
            catch (Exception e) {
                throw new BGException("\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 " + nameValue + "=" + value);
            }
            return this.scriptUtils.getContractParameter(this.doc.getContractId(), pid);
        }
        if (value.startsWith("bill_attr:")) {
            value = value.substring(10);
            return XMLUtils.selectText((Node)this.xml, (String)("/data/bill/attributes/@" + value));
        }
        return value;
    }

    protected String value(String nameValue) throws Exception {
        return this.value(nameValue, true);
    }

    protected String value_raw(String nameValue, boolean required) throws MissingDocParamException {
        String value = this.documentSetup.get(nameValue);
        if (required && value == null) {
            throw new MissingDocParamException(nameValue);
        }
        return value;
    }

    protected EdoFnsXmlGenerator.S \u0424\u0418\u041e\u0422\u0438\u043f(final String F, final String I, final String O) {
        return new EdoFnsXmlGenerator.S(){
            {
                this.A("\u0424\u0430\u043c\u0438\u043b\u0438\u044f", F);
                this.A("\u0418\u043c\u044f", I);
                this.A("\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e", O);
            }
        };
    }

    protected String \u0414\u0430\u0442\u0430\u0422\u0438\u043f(Date date) {
        return date != null ? TimeUtils.format((Date)date, (String)"dd.MM.yyyy") : null;
    }

    protected String \u0412\u0440\u0435\u043c\u044f\u0422\u0438\u043f(Date date) {
        return date != null ? TimeUtils.format((Date)date, (String)"HH.mm.ss") : null;
    }

    protected EdoFnsXmlGenerator.S \u0422\u0435\u043a\u0441\u0442\u0418\u043d\u0444\u0422\u0438\u043f(final String id, final String val) {
        return new EdoFnsXmlGenerator.S(){
            {
                this.A("\u0418\u0434\u0435\u043d\u0442\u0438\u0444", id);
                this.A("\u0417\u043d\u0430\u0447\u0435\u043d", val);
            }
        };
    }

    protected String \u0412\u0435\u0440\u0441\u041f\u0440\u043e\u0433() {
        VersionInfo vi = VersionInfo.getVersionInfo((String)"kernel");
        return "BGBilling " + vi.getVersionString();
    }
}

