<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:format="xalan://java.text.Format"
    xmlns:iterator="xalan://java.lang.Iterator"
    xmlns:session="xalan://ru.bitel.bgbilling.modules.phone.server.bean.Session"
    xmlns:lines="xalan://ru.bitel.bgbilling.modules.phone.server.action.ActionReportSession.CSVLine"
    xmlns:utils="ru.bitel.common.Utils"
    extension-element-prefixes="session iterator format utils"
	version="1.0">

<xsl:output method="text" encoding="UTF-8" indent="yes"/>

<xsl:param name="beans"/>
<xsl:param name="format"/>
<xsl:param name="size"/>
<!-- порядок и видимость (cdr_id;item;dest;service;session_start;session_time;session_time_round;min_cost;session_cost;from_to;from;to;from164;to164 -->
<xsl:param name="csv_line" select="'cdr_id;item;dest;service;session_start;session_time;session_time_round;min_cost;session_cost;from_to'"/>
<xsl:param name="lines"/>

<xsl:template match="/">
	<xsl:value-of select="utils:insertBOM()"/>
	<xsl:variable name="temp" select="lines:init( $lines, $csv_line )"/>
	<xsl:for-each select="/data/table">
		<xsl:choose>
			<xsl:when test="@type = 1"><xsl:call-template name="table_point"/>
			</xsl:when>
			<xsl:otherwise><xsl:call-template name="table_rule"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
</xsl:template>

<xsl:template name="table_point">
<xsl:for-each select="$size">
<xsl:value-of select="lines:next( $lines )"/><xsl:text>
</xsl:text>
</xsl:for-each>
</xsl:template>

<!-- 
<xsl:template name="table_point">
<xsl:for-each select="$size">
<xsl:variable name="s" select="iterator:next( $beans )"/>
<xsl:value-of select="session:getClientItem( $s )"/>;<xsl:value-of select="session:getDestination( $s )"/>;<xsl:value-of select="session:getService( $s )"/>;<xsl:value-of select="format:format( $format, session:getSessionStart( $s ) )"/>;<xsl:value-of select="utils:formatSessionTime( session:getSessionTime( $s ) )"/>;<xsl:value-of select="utils:formatSessionTime( session:getSessionTimeRound( $s ) )"/>;<xsl:value-of select="utils:formatCost( session:getMinCost( $s ) )"/>;<xsl:value-of select="utils:formatSessionCost( session:getSessionCost( $s ) )"/>;<xsl:value-of select="session:getFromNumber164( $s )"/>/<xsl:value-of select="session:getToNumber164( $s )"/><xsl:text>
</xsl:text>
</xsl:for-each>
</xsl:template>
 -->

<xsl:template name="table_rule">
<xsl:for-each select="$size">
<xsl:value-of select="lines:next( $lines )"/><xsl:text>
</xsl:text>
</xsl:for-each>
</xsl:template>

<xsl:template name="table_old">
<xsl:for-each select="$size">
<xsl:variable name="s" select="iterator:next( $beans )"/>
<xsl:value-of select="session:getCdrId( $s )"/>;<xsl:value-of select="session:getClientItem( $s )"/>;<xsl:value-of select="session:getDestination( $s )"/>;<xsl:value-of select="session:getService( $s )"/>;<xsl:value-of select="format:format( $format, session:getSessionStart( $s ) )"/>;<xsl:value-of select="utils:formatSessionTime( session:getSessionTime( $s ) )"/>;<xsl:value-of select="utils:formatSessionTime( session:getSessionTimeRound( $s ) )"/>;<xsl:value-of select="utils:formatCost( session:getMinCost( $s ) )"/>;<xsl:value-of select="utils:formatSessionCost( session:getSessionCost( $s ) )"/>;<xsl:value-of select="session:getFromNumber164( $s )"/>/<xsl:value-of select="session:getToNumber164( $s )"/><xsl:text>
</xsl:text>
</xsl:for-each>
</xsl:template>

</xsl:stylesheet>
