/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting;

import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionCallRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.event.InetAccountingEvent;
import ru.bitel.bgbilling.apps.inet.accounting.event.InetAccountingManageEvent;
import ru.bitel.bgbilling.apps.inet.accounting.event.InetAccountingManagePoolEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.AccountingTrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class InetAccountingManageWorkerT
extends EventWorker
implements Lifecycle {
    private final Accounting accounting;

    public InetAccountingManageWorkerT(Setup setup, Accounting accounting, boolean pool) throws BGException {
        super(EventProcessor.getInstance(), pool ? InetAccountingManagePoolEvent.class : InetAccountingManageEvent.class, accounting.moduleId, -1, "accountingRootDeviceId=" + accounting.rootDeviceId);
        this.accounting = accounting;
        this.context = new EventListenerContext(setup, this.moduleId, SetupParam.getApplicationName());
    }

    public void start() throws Exception {
        new Thread((Runnable)((Object)this), "accntng-mnge-worker").start();
    }

    public void stop() throws Exception {
        this.shutdown();
    }

    protected boolean runWorker() throws BGException {
        return this.doTasks();
    }

    public Object doTask(Object task) throws BGException {
        block9: {
            try {
                if (task instanceof InetAccountingManageEvent) {
                    InetAccountingManageEvent e = (InetAccountingManageEvent)((Object)task);
                    InetConnection connection = e.getConnection();
                    try {
                        this.onAccountingManage((EventListenerContext)this.context, e, connection);
                        break block9;
                    }
                    catch (InterruptedException ex) {
                        throw new BGException((Throwable)ex);
                    }
                }
                if (task instanceof InetAccountingManagePoolEvent) {
                    InetAccountingManagePoolEvent e = (InetAccountingManagePoolEvent)((Object)task);
                    InetConnection connection = e.getConnection();
                    assert (e.getType() == 3);
                    try {
                        this.onAccountingManageUpdate(connection, 8000L);
                        break block9;
                    }
                    catch (InterruptedException ex) {
                        throw new BGException((Throwable)ex);
                    }
                }
                this.getLogger().error("Unknown message " + task.getClass());
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAccountingManage(EventListenerContext ctx, InetAccountingManageEvent e, InetConnection connection) throws BGException, InterruptedException {
        if (e.getType() == 1) {
            InetConnection existConnnection = this.accounting.findExistConnection(connection);
            if (existConnnection != null) {
                e.setConnection(existConnnection);
                return;
            }
            InetServRuntime inetServRuntime = this.accounting.inetServRuntimeMap.get(connection.getServId());
            InetConnectionCallRuntime parentAccountingSession = connection.getParentConnectionId() > 0L ? this.accounting.connectionMapCall.get(connection.getParentConnectionId()) : null;
            if (connection.getConnectionStart() == null) {
                connection.setConnectionStart(new Date());
            }
            if (e.getTimeout() > 0L) {
                inetServRuntime.tryLockEx(e.getTimeout() + 1000L, TimeUnit.MILLISECONDS);
                try {
                    this.accounting.connectionCallStart(ctx.getConnectionSet(), true, connection, null, 0L, null, null, inetServRuntime, parentAccountingSession, null);
                }
                catch (Exception ex) {
                    throw new BGException((Throwable)ex);
                }
                finally {
                    inetServRuntime.unlock();
                }
            } else {
                inetServRuntime.lock();
                try {
                    this.accounting.connectionCallStart(ctx.getConnectionSet(), true, connection, null, 0L, null, null, inetServRuntime, parentAccountingSession, null);
                }
                catch (Exception ex) {
                    throw new BGException((Throwable)ex);
                }
                finally {
                    inetServRuntime.unlock();
                }
            }
        } else if (e.getType() == 2) {
            Date sessionStop = connection.getConnectionStop() != null ? connection.getConnectionStop() : new Date();
            InetConnectionCallRuntime connectionRuntime = this.accounting.connectionMapCall.get(connection.getId());
            if (connectionRuntime == null) {
                this.getLogger().error("Connection for stop not found with id=" + connection.getId());
                return;
            }
            connectionRuntime.inetServRuntime.lock();
            try {
                ((InetConnectionRuntime)connectionRuntime).forceStop(this.accounting, ctx.getConnectionSet(), sessionStop.getTime(), false);
            }
            finally {
                connectionRuntime.inetServRuntime.unlock();
            }
        } else if (e.getType() == 3) {
            this.onAccountingManageUpdate(connection, e.getTimeout());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAccountingManageUpdate(InetConnection connection, long timeout) throws BGException, InterruptedException {
        InetConnectionCallRuntime connectionRuntime = this.accounting.connectionMapCall.get(connection.getId());
        this.getLogger().debug("Accounting update: " + connection);
        if (connectionRuntime != null) {
            long millis = System.currentTimeMillis();
            connectionRuntime.inetServRuntime.tryLockEx(timeout > 0L ? timeout : 20000L, TimeUnit.MILLISECONDS);
            try {
                Long hour = InetUtils.getHour(millis);
                ((InetConnectionRuntime)connectionRuntime).trySplitSession(this.accounting, hour, millis);
                long lastAccountTime = System.currentTimeMillis() / 1000L;
                if (connectionRuntime.lastAccountTime < lastAccountTime) {
                    connectionRuntime.lastAccountTime = lastAccountTime;
                    connectionRuntime.updateTime(millis);
                }
            }
            finally {
                connectionRuntime.inetServRuntime.unlock();
            }
            this.accounting.onConnectionUpdate(connectionRuntime);
            this.accounting.sessionAccountingEP.publish((Event)new InetAccountingEvent(this.accounting.sessionAccountingEP, connectionRuntime.contractId, connectionRuntime.connection, connectionRuntime.sessionId, 3, new HashMap<Integer, AccountingTrafficAmount>(connectionRuntime.counterTraffics), new Date(millis)));
        } else {
            this.getLogger().warn("AccountingSession not found on manageUpdate with id=" + connection.getId());
        }
    }
}

