/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgent;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterface;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterfaceMap;
import ru.bitel.bgbilling.apps.inet.accounting.event.FlowAgentInterfaceMapReloadedEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.inet.common.bean.FlowAgentType;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.ParameterMap;

public class FlowAgentInterfaceSelector
implements EventListener<FlowAgentInterfaceMapReloadedEvent> {
    private static final Logger logger = LogManager.getLogger();
    private final Set<Integer> agentDeviceIds;
    private final Set<Integer> types;
    private final FlowAgentInterfaceMap ifaceMap;
    private volatile Map<InetAddress, FlowAgent> agentMap;
    private volatile Map<Integer, FlowAgent> agentIdMap;

    public FlowAgentInterfaceSelector(Accounting accounting, Set<Integer> agentDeviceIds, Integer ... types) throws BGException {
        this.ifaceMap = accounting.ifaceMap;
        this.agentDeviceIds = agentDeviceIds;
        this.types = new HashSet<Integer>(Arrays.asList(types));
        EventProcessor ep = EventProcessor.getInstance();
        ep.addListener((EventListener)this, FlowAgentInterfaceMapReloadedEvent.class, accounting.moduleId, null);
        this.load(accounting.deviceMap.getMap());
    }

    public Map<InetAddress, FlowAgent> getAgentMap() {
        return this.agentMap;
    }

    public Map<Integer, FlowAgent> getAgentIdMap() {
        return this.agentIdMap;
    }

    public void notify(FlowAgentInterfaceMapReloadedEvent e, EventListenerContext ctx) throws BGException {
        this.load(e.getDeviceMap());
    }

    public void load(Map<Integer, InetDeviceRuntime> deviceMap) {
        logger.info("load( " + deviceMap + " )");
        try {
            HashMap<Integer, FlowAgent> idResult = new HashMap<Integer, FlowAgent>();
            HashMap<InetAddress, FlowAgent> result = new HashMap<InetAddress, FlowAgent>();
            for (Map.Entry e : this.ifaceMap.getAgentMap().entrySet()) {
                Integer agentDeviceId = (Integer)e.getKey();
                ConcurrentMap ifaceMap = (ConcurrentMap)e.getValue();
                logger.info("agentDeviceId = " + agentDeviceId + "; ifaceMap = " + ifaceMap);
                InetDeviceRuntime device = deviceMap.get(agentDeviceId);
                logger.info("device = " + device);
                if (device == null) continue;
                logger.info("agentDeviceIds = " + this.agentDeviceIds);
                if (this.agentDeviceIds != null) {
                    logger.info("agentDeviceIds.size() = " + this.agentDeviceIds.size() + "; agentDeviceIds.contains( agentDeviceId ) = " + this.agentDeviceIds.contains(agentDeviceId));
                    if (this.agentDeviceIds.size() > 0 && !this.agentDeviceIds.contains(agentDeviceId)) continue;
                }
                int agentType = FlowAgentType.nameToType((String)device.config.get("flow.agent.type", ""));
                logger.info("agentType(before check) = " + agentType);
                if (!FlowAgentType.checkSourceType((int)agentType)) {
                    agentType = 1;
                }
                logger.info("agentType(after check) = " + agentType);
                logger.info("types.contains( agentType ) = " + this.types.contains(agentType));
                if (!this.types.contains(agentType)) continue;
                ParameterMap config = this.ifaceMap.accounting.setup.inherit(device.config);
                FlowAgent flowAgent = new FlowAgent(device.inetDevice.getId(), device.inetDevice.getTitle(), agentType, config, new HashMap<Integer, FlowAgentInterface>(ifaceMap));
                for (InetSocketAddress address : device.inetDevice.getHosts()) {
                    logger.info("address.getAddress() = " + address.getAddress());
                    result.put(address.getAddress(), flowAgent);
                }
                idResult.put(agentDeviceId, flowAgent);
            }
            logger.info("Loaded sources: " + result.keySet());
            this.agentMap = result;
            this.agentIdMap = idResult;
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

