/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.radius;

import bitel.billing.server.radius.RadiusSetup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.bitel.bgbilling.kernel.network.flow.FlowListener;
import ru.bitel.bgbilling.kernel.network.flow.FlowPacket;
import ru.bitel.bgbilling.kernel.network.flow.NetFlowArray;
import ru.bitel.bgbilling.kernel.network.flow.SFlowArray;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNas;
import ru.bitel.bgbilling.modules.dialup.server.radius.FlowListenerWorker;
import ru.bitel.bgbilling.modules.dialup.server.radius.FlowListenerWorkerContext;
import ru.bitel.bgbilling.modules.dialup.server.radius.FlowListenerWorkerNetFlow;
import ru.bitel.bgbilling.modules.dialup.server.radius.FlowListenerWorkerSFlow;
import ru.bitel.bgbilling.modules.dialup.server.radius.TrafficInspector;
import ru.bitel.bgbilling.modules.dialup.server.traffic.ServiceLinkFinder;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerTask;

public class DialUpFlowListener
extends FlowListener {
    protected final RadiusSetup setup;
    protected final ExecutorService executorService;
    private int packetCount = 0;
    private int packetCountMinute = 0;
    private long currentMinute = System.currentTimeMillis() / 1000L / 60L;
    private int currentPacketCount = 0;

    DialUpFlowListener(RadiusSetup setup, int port, int threadCount, int byteBufferCapacity, int socketRCVBUF, ThreadContextFactory<FlowListenerWorkerContext> contextFactory) {
        super(port, byteBufferCapacity, socketRCVBUF, "flowListener");
        this.setup = setup;
        this.executorService = WorkerTask.newFixedThreadPool((String)"flow", null, contextFactory, (int)threadCount);
    }

    public void flush(long millis, List<FlowPacket> packetList) {
        assert (packetList instanceof RandomAccess);
        int size = packetList.size();
        this.packetCount += size;
        long minute = millis / 1000L / 60L;
        if (minute != this.currentMinute) {
            this.packetCountMinute = this.currentPacketCount;
            this.currentMinute = minute;
            this.currentPacketCount = 0;
        } else {
            this.currentPacketCount += size;
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        ThreadPoolExecutor pool = (ThreadPoolExecutor)this.executorService;
        if (pool != null) {
            result.append("queue_size: ");
            result.append(pool.getQueue().size());
            result.append("; threads_active: ");
            result.append(pool.getActiveCount());
            result.append("; largest: ");
            result.append(pool.getLargestPoolSize());
            result.append("; core: ");
            result.append(pool.getCorePoolSize());
            result.append("; pool_size: ");
            result.append(pool.getPoolSize());
            result.append("; ");
        }
        result.append(super.toString());
        result.append("; packets: ").append(this.packetCount);
        return result.toString();
    }

    public int getPacketCountMinute() {
        return this.packetCountMinute;
    }

    public static DialUpFlowListener newInstance(RadiusSetup setup, int port, int threadCount, int byteBufferCapacity, int socketRCVBUF, Iterable<DialUpNas> nasList, Integer sourceType, String nasesString) {
        InetSocketAddress forwardAddress;
        final Logger logger = LoggerFactory.getLogger(DialUpFlowListener.class);
        final HashMap<String, ArrayList<TrafficInspector>> receiveFrom = new HashMap<String, ArrayList<TrafficInspector>>();
        final ServiceLinkFinder serviceFinder = new ServiceLinkFinder((Preferences)setup);
        setup.addActionListener(e -> {
            if ("reload".equals(e.getActionCommand())) {
                BGNestedContext.push((String)"collector");
                try {
                    serviceFinder.reload();
                }
                finally {
                    BGNestedContext.pop();
                }
            }
        });
        logger.info("Analyse nas list..");
        List nases = Utils.toIntegerList((String)nasesString);
        for (DialUpNas nasInfo : nasList) {
            List ports;
            if (nases.size() > 0 && !nases.contains(nasInfo.getId())) continue;
            String rcvFrom = nasInfo.getConf().get("collector.agent.address", null);
            if (rcvFrom == null) {
                rcvFrom = nasInfo.getConf().get("netflow.receive.from", null);
            }
            if ((ports = Utils.toIntegerList((String)nasInfo.getConf().get("collector.agent.ports", null))).size() > 0 && !ports.contains(port)) continue;
            logger.info(nasInfo.toString());
            if (!Utils.notEmptyString((String)rcvFrom)) continue;
            logger.info("Receive NetFlow from => " + rcvFrom);
            ArrayList<TrafficInspector> inspectors = (ArrayList<TrafficInspector>)receiveFrom.get(rcvFrom);
            if (inspectors == null) {
                inspectors = new ArrayList<TrafficInspector>();
                receiveFrom.put(rcvFrom, inspectors);
            }
            inspectors.add(nasInfo.getTrafficInspector());
        }
        ThreadContextFactory<FlowListenerWorkerContext> contextFactory = new ThreadContextFactory<FlowListenerWorkerContext>(){

            public FlowListenerWorkerContext newThreadContext() {
                FlowListenerWorkerContext result = new FlowListenerWorkerContext(receiveFrom, serviceFinder, new NetFlowArray(512), new SFlowArray(512));
                return result;
            }
        };
        String netflowForward = setup.get("netflow.forward", null);
        if (Utils.notBlankString((String)netflowForward)) {
            String[] host_port = netflowForward.split(":");
            if (host_port.length == 2) {
                String forwardHost = host_port[0];
                int forwardPort = Utils.parseInt((String)host_port[1]);
                forwardAddress = new InetSocketAddress(forwardHost, forwardPort);
            } else {
                forwardAddress = null;
            }
        } else {
            forwardAddress = null;
        }
        if (forwardAddress == null) {
            if (sourceType == null) {
                return new DialUpFlowListener(setup, port, threadCount, byteBufferCapacity, socketRCVBUF, (ThreadContextFactory)contextFactory){

                    @Override
                    public void flush(long millis, List<FlowPacket> packetList) {
                        super.flush(millis, packetList);
                        this.executorService.execute((Runnable)((Object)new FlowListenerWorker(packetList)));
                    }
                };
            }
            switch (sourceType) {
                case 3: {
                    return new DialUpFlowListener(setup, port, threadCount, byteBufferCapacity, socketRCVBUF, (ThreadContextFactory)contextFactory){

                        @Override
                        public void flush(long millis, List<FlowPacket> packetList) {
                            super.flush(millis, packetList);
                            this.executorService.execute((Runnable)((Object)new FlowListenerWorkerNetFlow(packetList)));
                        }
                    };
                }
                case 4: {
                    return new DialUpFlowListener(setup, port, threadCount, byteBufferCapacity, socketRCVBUF, (ThreadContextFactory)contextFactory){

                        @Override
                        public void flush(long millis, List<FlowPacket> packetList) {
                            super.flush(millis, packetList);
                            this.executorService.execute((Runnable)((Object)new FlowListenerWorkerSFlow(packetList)));
                        }
                    };
                }
            }
            throw new IllegalArgumentException(String.valueOf(sourceType));
        }
        if (sourceType == null) {
            return new DialUpFlowListener(setup, port, threadCount, byteBufferCapacity, socketRCVBUF, (ThreadContextFactory)contextFactory){

                @Override
                public void flush(long millis, List<FlowPacket> packetList) {
                    super.flush(millis, packetList);
                    class ForwardFlowListenerWorker
                    extends WorkerTask<FlowListenerWorkerContext> {
                        private final FlowListenerWorker worker;
                        private final DatagramChannel channel;
                        final /* synthetic */ InetSocketAddress val$forwardAddress;
                        final /* synthetic */ Logger val$logger;

                        public ForwardFlowListenerWorker(DatagramChannel channel, FlowListenerWorker worker) {
                            this.val$forwardAddress = inetSocketAddress;
                            this.val$logger = logger;
                            this.channel = channel;
                            this.worker = worker;
                        }

                        protected void runImpl() {
                            this.worker.setContext((FlowListenerWorkerContext)this.context);
                            this.worker.run();
                            int size = this.worker.packetList.size();
                            for (int i = 0; i < size; ++i) {
                                ByteBuffer data = this.worker.packetList.get((int)i).data;
                                try {
                                    this.channel.send(data, this.val$forwardAddress);
                                }
                                catch (IOException e) {
                                    this.val$logger.error("Forward error", (Throwable)e);
                                }
                                data.rewind();
                            }
                        }
                    }
                    this.executorService.execute((Runnable)((Object)new ForwardFlowListenerWorker(this.channel, new FlowListenerWorker(packetList), forwardAddress, logger)));
                }
            };
        }
        switch (sourceType) {
            case 3: {
                return new DialUpFlowListener(setup, port, threadCount, byteBufferCapacity, socketRCVBUF, (ThreadContextFactory)contextFactory){

                    @Override
                    public void flush(long millis, List<FlowPacket> packetList) {
                        super.flush(millis, packetList);
                        this.executorService.execute((Runnable)((Object)new ForwardFlowListenerWorker(this.channel, (FlowListenerWorker)new FlowListenerWorkerNetFlow(packetList), forwardAddress, logger)));
                    }
                };
            }
            case 4: {
                return new DialUpFlowListener(setup, port, threadCount, byteBufferCapacity, socketRCVBUF, (ThreadContextFactory)contextFactory){

                    @Override
                    public void flush(long millis, List<FlowPacket> packetList) {
                        super.flush(millis, packetList);
                        this.executorService.execute((Runnable)((Object)new ForwardFlowListenerWorker(this.channel, (FlowListenerWorker)new FlowListenerWorkerSFlow(packetList), forwardAddress, logger)));
                    }
                };
            }
        }
        throw new IllegalArgumentException(String.valueOf(sourceType));
    }
}

