/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.processor.dialup;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.processor.LC_LimitChecker;
import bitel.billing.server.processor.NASSession;
import bitel.billing.server.processor.dialup.CalculateResult;
import bitel.billing.server.processor.dialup.CalculateTimeResult;
import bitel.billing.server.processor.dialup.CalculateTrafficResult;
import bitel.billing.server.processor.dialup.LevelManager;
import bitel.billing.server.radius.RadiusSetup;
import bitel.billing.server.tariff.TariffModuleTree;
import java.io.Closeable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IpNet;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.bgbilling.modules.dialup.server.DetailCompressRules;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpLogin;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpSession;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpSessionUtils;
import ru.bitel.bgbilling.modules.dialup.server.event.OpenPeriodRequestEvent;
import ru.bitel.bgbilling.modules.dialup.server.event.radius.TariffZoneChangedEvent;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNasConnection;
import ru.bitel.bgbilling.modules.dialup.server.tariff.TariffZoneTariffTreeNode;
import ru.bitel.bgbilling.modules.dialup.server.traffic.Traffic;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerThreadFactory;

public final class DialUpSessionRealtime
extends DialUpSession
implements NASSession {
    private int serviceTime;
    private Calendar calculatedStopTime;
    private String nasPort;
    private String acctSessionID;
    private long ipAddress;
    private Set<IpNet> ipNets = new HashSet<IpNet>(2);
    private List<Traffic> trafficConfig;
    private Map<Integer, Long> trafficValues = new HashMap<Integer, Long>();
    private Map<Integer, Long> calculatedTrafficValues = new HashMap<Integer, Long>();
    private boolean secondCalculatePeriod;
    private Calendar calculatePeriodStart;
    private Calendar calculatePeriodEnd;
    private boolean closeCalculatePeriod;
    private Map<Integer, List<DialUpSessionUtils.ServiceRange>> serviceRanges;
    private List<Period> suspendPeriodList;
    private final Map<String, TariffZoneEntry> dialupTariffZoneMap = new HashMap<String, TariffZoneEntry>(4);
    private Set<Integer> fullCalcAttributeSets;
    private int tariffTreeId;
    public static final int DYN_DNS_OFF = 0;
    public static final int DYN_DNS_LOGIN = 1;
    public static final int DYN_DNS_ENTER_LOGIN = 2;
    private int dynDNSType = 0;
    private static final ThreadContextFactory<ServerContext> THREAD_CONTEXT_FACTORY = new ThreadContextFactory<ServerContext>(){
        private final Setup setup = RadiusSetup.getSetup();
        private final int moduleId = RadiusSetup.getSetup().getModuleId();

        public ServerContext newThreadContext() {
            return new ServerContext(this.setup, this.moduleId, 0);
        }
    };
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool((ThreadFactory)new WorkerThreadFactory(null, null, THREAD_CONTEXT_FACTORY));
    private static final int MAX_BALANCE_ADD = 10;
    private int balanceAddCount = 0;
    private boolean wasFirstUpdate = false;
    private static Map<Integer, AtomicInteger> contractInitCountMap = new HashMap<Integer, AtomicInteger>();
    private Map<Integer, long[]> delayedDetailData = new HashMap<Integer, long[]>();

    public int getDynDNSType() {
        return this.dynDNSType;
    }

    public void setDynDNSType(int dynDNSType) {
        this.dynDNSType = dynDNSType;
    }

    public DialUpSessionRealtime(boolean isFake, boolean secondCalculatePeriod) {
        this.startTime = new GregorianCalendar();
        this.setFakeSession(isFake);
        this.secondCalculatePeriod = secondCalculatePeriod;
        if (isFake) {
            DialUpLogin login = new DialUpLogin();
            login.setId(0);
            this.setLogin(login);
            Contract contract = new Contract();
            contract.setId(0);
            contract.setTitle("FAKE");
            this.setContract(contract);
        }
    }

    public int getServiceTime() {
        return this.serviceTime;
    }

    public void setServiceTime(int serviceTime) {
        this.serviceTime = serviceTime;
    }

    public String getNasPort() {
        return this.nasPort;
    }

    public void setNasPort(String nasPort) {
        this.nasPort = nasPort;
    }

    public String getAcctSessionId() {
        return this.acctSessionID == null ? "UNDEF" : this.acctSessionID;
    }

    public void setAcctSessionId(String acctSessionID) {
        this.acctSessionID = acctSessionID;
    }

    public long getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(long ipAddress) {
        this.ipAddress = ipAddress;
    }

    public Calendar getCalculatedStopTime() {
        return this.calculatedStopTime;
    }

    public void setCalculatedStopTime(Calendar calculatedStopTime) {
        this.calculatedStopTime = calculatedStopTime;
    }

    public void setTrafficConfig(List<Traffic> trafficConfig) {
        this.trafficConfig = trafficConfig;
    }

    public void setCloseCalculatePeriod(boolean value) {
        this.closeCalculatePeriod = value;
    }

    public void addIpNet(IpNet net) {
        this.ipNets.add(net);
    }

    public Set<IpNet> getIpNetSet() {
        return this.ipNets;
    }

    public void addTrafficCollectorValuebySID(int sid, long value) {
        if (this.getLogger().isDebugEnabled()) {
            this.addLogDebug("Add collector traffic by SID => " + sid + "; add => " + value);
        }
        for (Traffic traffic : this.trafficConfig) {
            if (traffic.getTrafficSource() != 3 || traffic.getServiceId() != sid) continue;
            Long currentValue = this.trafficValues.get(sid);
            currentValue = currentValue != null ? Long.valueOf(currentValue + value) : Long.valueOf(value);
            this.trafficValues.put(sid, currentValue);
            if (!this.getLogger().isDebugEnabled()) break;
            this.addLogDebug("Current value => " + currentValue);
            break;
        }
        this.updateFunctionTraffics();
    }

    public void updateRadiusTraffics(RadiusPacket packet) {
        this.setTrafficValueByType(1, this.getBytesIn());
        this.setTrafficValueByType(2, this.getBytesOut());
        if (packet == null) {
            this.addLogError("Trying update RADIUS traffics with null RadiusPacket");
        } else {
            for (Traffic traffic : this.trafficConfig) {
                List vendorAttributes;
                if (traffic.getTrafficSource() != 7 || (vendorAttributes = packet.getAttributes(traffic.getRadiusVendorCode(), traffic.getRadiusAttrCode())) == null) continue;
                for (RadiusAttribute ra : vendorAttributes) {
                    long trafficValue;
                    String prefix;
                    RadiusAttribute.RadiusAttributeString attr = (RadiusAttribute.RadiusAttributeString)ra;
                    String val = (String)attr.getValue();
                    if (!val.startsWith(prefix = traffic.getRadiusAttrPrefix()) || (trafficValue = Utils.parseLong((String)(val = val.substring(prefix.length() + 1).trim()))) <= 0L) continue;
                    this.trafficValues.put(traffic.getServiceId(), trafficValue);
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.addLogDebug("Set traffic from RADIUS sid => " + traffic.getServiceId() + "; value => " + trafficValue);
                }
            }
        }
        this.updateFunctionTraffics();
    }

    private void setTrafficValueByType(int sourceType, long value) {
        if (this.getLogger().isDebugEnabled()) {
            this.addLogDebug("Set traffic by type => " + sourceType + "; value => " + value);
        }
        for (Traffic traffic : this.trafficConfig) {
            if (traffic.getTrafficSource() != sourceType) continue;
            this.trafficValues.put(traffic.getServiceId(), value);
        }
    }

    private void updateFunctionTraffics() {
        for (Traffic traffic : this.trafficConfig) {
            if (traffic.getTrafficSource() == 5) {
                Long value1 = this.trafficValues.get(traffic.getParamSID_1());
                Long value2 = this.trafficValues.get(traffic.getParamSID_2());
                long max = Math.max(value1 == null ? 0L : value1, value2 == null ? 0L : value2);
                this.trafficValues.put(traffic.getServiceId(), max);
                continue;
            }
            if (traffic.getTrafficSource() != 6) continue;
            long summ = 0L;
            Long value = this.trafficValues.get(traffic.getParamSID_1());
            if (value != null) {
                summ += value.longValue();
            }
            if ((value = this.trafficValues.get(traffic.getParamSID_2())) != null) {
                summ += value.longValue();
            }
            if ((value = this.trafficValues.get(traffic.getParamSID_3())) != null) {
                summ += value.longValue();
            }
            if ((value = this.trafficValues.get(traffic.getParamSID_4())) != null) {
                summ += value.longValue();
            }
            this.trafficValues.put(traffic.getServiceId(), summ);
        }
    }

    private String getTrafficServicesString() {
        StringBuffer trafficServices = new StringBuffer();
        for (Traffic traffic : this.trafficConfig) {
            int sid = traffic.getServiceId();
            if (trafficServices.length() != 0) {
                trafficServices.append(",");
            }
            trafficServices.append(sid);
        }
        return trafficServices.toString();
    }

    public void restoreTraffics(Connection con) {
        String trafficServices = this.getTrafficServicesString();
        if (ServerUtils.tableExists((Connection)con, (String)this.sessionDetailTableName) && trafficServices.length() > 0) {
            try {
                StringBuffer query = new StringBuffer("SELECT sid, SUM(amount) FROM ");
                query.append(this.sessionDetailTableName);
                query.append(" WHERE session_id=? AND sid IN ( ");
                query.append(trafficServices);
                query.append(" ) GROUP BY sid");
                PreparedStatement ps = con.prepareStatement(query.toString());
                ps.setInt(1, this.getLogRecordId());
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    this.calculatedTrafficValues.put(rs.getInt(1), rs.getLong(2));
                    this.trafficValues.put(rs.getInt(1), rs.getLong(2));
                }
                rs.close();
                ps.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean calculate(final RadiusSetup setup, final Closeable connection, Connection con, LC_LimitChecker limitChecker, final boolean useLimits) {
        boolean logSessionDelayedUpdate;
        CalculateTimeResult timeCalc;
        CalculateTrafficResult trafCalc;
        if (this.getLogger().isDebugEnabled()) {
            this.addLogDebug("DialUpSessionRealtime recalculating useLimits => " + useLimits + "; hasLimitChecker => " + (limitChecker != null));
        }
        assert (this.contract != null);
        this.fullCalcAttributeSets = new HashSet<Integer>();
        if (!this.calculatedStopTime.after(this.getStopTime())) {
            for (TariffZoneEntry zoneEntry : this.dialupTariffZoneMap.values()) {
                zoneEntry.recycle();
            }
            int tariffTreeId = this.tariffTreeId;
            boolean zoneChangedByTime = true;
            BalanceUtils balanceUtils = new BalanceUtils(con);
            float balanceRest = balanceUtils.getBalanceOut(this.startTime.getTime(), this.contract.getId()).subtract(this.contract.getBalanceLimit()).floatValue();
            balanceUtils.close();
            trafCalc = this.calculateTraffic(con, limitChecker, useLimits, balanceRest);
            for (TariffZoneEntry tariffZoneEntry : this.dialupTariffZoneMap.values()) {
                if (!tariffZoneEntry.changed) continue;
                zoneChangedByTime = false;
                break;
            }
            timeCalc = this.calculateTime(con, limitChecker, useLimits, balanceRest -= trafCalc.takedMoney);
            balanceRest -= timeCalc.takedMoney;
            HashSet<Integer> changedZoneAttributeSets = null;
            for (TariffZoneEntry zoneEntry : this.dialupTariffZoneMap.values()) {
                if (!zoneEntry.changed) continue;
                this.addLogInfo("Changed tariff zone from " + zoneEntry.oldZone + " to " + zoneEntry.zone);
                Calendar startZoneDo = null;
                if (zoneChangedByTime) {
                    startZoneDo = (Calendar)this.calculatedStopTime.clone();
                    startZoneDo.set(12, 0);
                    startZoneDo.set(13, 0);
                } else {
                    startZoneDo = new GregorianCalendar();
                }
                final long startZoneDoTime = startZoneDo.getTimeInMillis();
                final TariffZoneEntry newZone = zoneEntry;
                if (changedZoneAttributeSets == null && zoneEntry.attributeSets != null) {
                    changedZoneAttributeSets = new HashSet<Integer>();
                    for (TariffZoneEntry e : this.dialupTariffZoneMap.values()) {
                        if (!e.changed || e.attributeSets == null) continue;
                        changedZoneAttributeSets.addAll(e.attributeSets);
                    }
                }
                final HashSet<Integer> changedZoneAttributeSets_ = changedZoneAttributeSets;
                EXECUTOR_SERVICE.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block19: {
                            try {
                                DialUpSessionRealtime.this.addLogInfo("Change zone do: " + TimeUtils.format((Date)new Date(startZoneDoTime), (String)"dd.MM.yyyy HH:mm:ss"));
                                while (System.currentTimeMillis() < startZoneDoTime) {
                                    Thread.sleep(100L);
                                }
                                Contract contract = DialUpSessionRealtime.this.contract;
                                if (useLimits) {
                                    if (newZone.zone.needDisconnect()) {
                                        DialUpSessionRealtime.this.addLogInfo("Setting to disconnect by new zone");
                                        connection.close();
                                    } else if (newZone.zone.needCoA()) {
                                        DialUpSessionRealtime.this.addLogInfo("Need CoA request");
                                        ((DialUpNasConnection)((Object)connection)).modify(changedZoneAttributeSets_);
                                    }
                                    if (Utils.notBlankString((String)newZone.zone.getEventName())) {
                                        DialUpSessionRealtime.this.addLogInfo("Call event: " + newZone.zone.getEventName());
                                        TariffZoneChangedEvent event = new TariffZoneChangedEvent(setup.getModuleId(), (DialUpNasConnection)((Object)connection), newZone.zone.getEventName());
                                        EventProcessor.getInstance().request((QueueEvent)event);
                                    }
                                }
                                if (!newZone.zone.isAddPayment()) break block19;
                                Connection con = setup.getDBConnectionFromPool();
                                try (BalanceUtils balanceUtils = new BalanceUtils(con);){
                                    Date now = new Date();
                                    Payment payment = Payment.builder().setDate(now).setTypeId(newZone.zone.getPaymentType()).setSum(new BigDecimal(newZone.zone.getPaymentSum())).setContractId(contract.getId()).build();
                                    new PaymentDao(con).update((Object)payment);
                                    ServerUtils.commitConnection((Connection)con);
                                    balanceUtils.updateBalance(now, contract);
                                    if (!con.getAutoCommit()) {
                                        con.commit();
                                    }
                                    EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                                    EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contract.getId(), 3, payment.getSum()));
                                    DialUpSessionRealtime.this.addLogInfo("Add payment by new zone");
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                finally {
                                    ServerUtils.closeConnection((Connection)con);
                                }
                            }
                            catch (Exception e) {
                                DialUpSessionRealtime.this.addLogError("Error on change zone do " + e.getMessage());
                                e.printStackTrace();
                            }
                        }
                    }
                });
                zoneEntry.recycle();
            }
            if (this.tariffChanged(tariffTreeId)) {
                try {
                    boolean bl;
                    this.addLogInfo("Tariff tree was changed from " + tariffTreeId + " to " + this.tariffTreeId);
                    boolean bl2 = bl = setup.getInt("no.session.break.on.tariff.change", 0) == 0;
                    if (bl) {
                        this.addLogInfo("Setting to disconnect by tariff tree change");
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    this.addLogError(exception.getMessage());
                }
            }
        } else {
            timeCalc = this.calculateTime(con, limitChecker, useLimits, 0.0f);
            trafCalc = this.calculateTraffic(con, limitChecker, useLimits, 0.0f);
        }
        boolean result = trafCalc.status && timeCalc.status;
        boolean bl = logSessionDelayedUpdate = trafCalc.logSessionDelayedUpdate && timeCalc.logSessionDelayedUpdate;
        if (!result) {
            this.closeCalculatePeriod(con, this.calculatedStopTime);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.addLogDebug("DialUpSessionRealtime recalculate result => " + result);
        }
        float fullTakedMoney = trafCalc.takedMoney + timeCalc.takedMoney;
        this.updateContractBalance(con, fullTakedMoney);
        this.updateSession(con, fullTakedMoney, logSessionDelayedUpdate && useLimits);
        return result;
    }

    private boolean zoneChanged(TariffZoneTariffTreeNode oldDialupTariffZone, TariffZoneTariffTreeNode dialupTariffZone) {
        return dialupTariffZone != null && oldDialupTariffZone != null && !oldDialupTariffZone.getZone().equals(dialupTariffZone.getZone());
    }

    private boolean tariffChanged(int tariffTreeId) {
        return this.tariffTreeId != 0 && tariffTreeId != 0 && this.tariffTreeId != tariffTreeId;
    }

    private void closeCalculatePeriod(Connection con, Calendar time) {
        if (this.closeCalculatePeriod) {
            BalanceUtils balanceUtils = new BalanceUtils(con);
            BigDecimal balance = balanceUtils.getBalanceOut(time.getTime(), this.contract.getId());
            balanceUtils.close();
            BigDecimal limit = this.contract.getBalanceLimit();
            if (balance.compareTo(limit) < 0) {
                this.addLogInfo("Closing calculate period..");
                try {
                    Calendar beforeEnd = (Calendar)time.clone();
                    beforeEnd.add(6, -1);
                    String query = "UPDATE calculate_period_" + this.getMid() + " SET end=? WHERE cid=? AND start=? AND end=?";
                    PreparedStatement ps = con.prepareStatement(query);
                    ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)beforeEnd));
                    ps.setInt(2, this.contract.getId());
                    ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)this.calculatePeriodStart));
                    ps.setDate(4, TimeUtils.convertCalendarToSqlDate((Calendar)this.calculatePeriodEnd));
                    ps.executeUpdate();
                    ps.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.addLogInfo("No close calculate period..");
        }
    }

    private CalculateTimeResult calculateTime(Connection con, LC_LimitChecker limitChecker, boolean useLimits, float balanceRest) {
        CalculateTimeResult result = new CalculateTimeResult();
        int d_sec = (int)((this.getStopTime().getTime().getTime() - this.calculatedStopTime.getTime().getTime()) / 1000L);
        if (this.getLogger().isDebugEnabled()) {
            this.addLogDebug("calculatedStopTime => " + TimeUtils.format((Calendar)this.calculatedStopTime, (String)"HH:mm:ss") + "; needStopTime => " + TimeUtils.format((Calendar)this.getStopTime(), (String)"HH:mm:ss"));
            this.addLogDebug("delta => " + d_sec);
        }
        int s = 0;
        do {
            Calendar endOfHour = (Calendar)this.calculatedStopTime.clone();
            endOfHour.add(11, 1);
            endOfHour.clear(13);
            endOfHour.clear(12);
            int secToHourEnd = (int)((endOfHour.getTime().getTime() - this.calculatedStopTime.getTime().getTime()) / 1000L);
            int sec = Math.min(secToHourEnd, d_sec);
            CalculateResult time_ok = this.calculateService(con, this.getCalculatedStopTime(), this.getServiceTime(), sec, limitChecker, useLimits, balanceRest);
            s = (int)time_ok.takedService;
            d_sec -= s;
            this.calculatedStopTime.add(13, s);
            result.takedMoney += time_ok.takedMoney;
            result.takedService += s;
            boolean bl = result.logSessionDelayedUpdate = result.logSessionDelayedUpdate && time_ok.logSessionDelayedUpdate;
            if (!this.getLogger().isDebugEnabled()) continue;
            this.addLogDebug("takedTime [ cost ] => " + time_ok.takedService + " [ " + time_ok.takedMoney + " ] ");
            this.addLogDebug("d_sec => " + d_sec + "; calculatedStopTime => " + TimeUtils.format((Calendar)this.calculatedStopTime, (String)"HH:mm:ss"));
        } while (s != 0 && d_sec != 0);
        result.status = d_sec == 0;
        return result;
    }

    private CalculateTrafficResult calculateTraffic(Connection con, LC_LimitChecker limitChecker, boolean useLimits, float balanceRest) {
        CalculateTrafficResult result = new CalculateTrafficResult();
        result.status = true;
        this.addLogDebug("Calculate traffics..");
        for (Traffic traffic : this.trafficConfig) {
            Long currentValue;
            Long calculatedValue = this.calculatedTrafficValues.get(traffic.getServiceId());
            if (calculatedValue == null) {
                calculatedValue = 0L;
            }
            if ((currentValue = this.trafficValues.get(traffic.getServiceId())) == null) {
                currentValue = 0L;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.addLogDebug("traffic SID => " + traffic.getServiceId() + "; value [ calculated ] => " + currentValue + " [ " + calculatedValue + " ] ");
            }
            long delta = currentValue - calculatedValue;
            if (this.getLogger().isDebugEnabled()) {
                this.addLogDebug("traffic delta => " + delta);
            }
            CalculateResult cr = this.calculateService(con, this.calculatedStopTime, traffic.getServiceId(), delta, limitChecker, useLimits, balanceRest);
            if (this.getLogger().isDebugEnabled()) {
                this.addLogDebug("calculated [ cost ] => " + cr.takedService + " [ " + cr.takedMoney + " ]");
            }
            boolean bl = result.status = result.status && delta == cr.takedService;
            if (this.getLogger().isDebugEnabled()) {
                this.addLogDebug("status => " + result.status);
            }
            result.takedMoney += cr.takedMoney;
            result.logSessionDelayedUpdate = result.logSessionDelayedUpdate && cr.logSessionDelayedUpdate;
            calculatedValue = calculatedValue + cr.takedService;
            this.calculatedTrafficValues.put(traffic.getServiceId(), calculatedValue);
        }
        return result;
    }

    private CalculateResult calculateService(Connection con, Calendar time, int sid, long needAmount, LC_LimitChecker limitChecker, boolean useLimits, float balanceRest) {
        CalculateResult cr = new CalculateResult();
        if (time == null) {
            return cr;
        }
        Calendar realTime = (Calendar)time.clone();
        time = (Calendar)time.clone();
        TimeUtils.clear_MIN_MIL_SEC((Calendar)time);
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.addLogDebug("DialUpSessionRealtime calculateService time => " + TimeUtils.format((Calendar)time, (String)"HH:mm:ss") + "; serviceID => " + sid + "; needAmount => " + needAmount + "; useLimits => " + useLimits);
            }
            Contract contract = this.getContract();
            if (this.getLogger().isDebugEnabled()) {
                this.addLogDebug(contract.toString());
            }
            if (needAmount == 0L) {
                this.addLogDebug("Need amount is 0 - return");
                return cr;
            }
            this.checkAndSetCalculatePeriod(con, realTime);
            if (this.calculatePeriodEnd == null) {
                this.addLogError("Calculate period set error!");
                return cr;
            }
            float balance_sum = balanceRest;
            if (this.getLogger().isDebugEnabled()) {
                this.addLogDebug("balance => " + balance_sum);
            }
            if (useLimits && balance_sum < 0.0f) {
                if (this.getLogger().isDebugEnabled()) {
                    this.addLogDebug("Contract in DEBET and balance rest < 0, return 0 amount..");
                }
                return cr;
            }
            if (this.calculatePeriodEnd == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.addLogError("calculatePeriodEnd is NULL!");
                }
                return cr;
            }
            TariffTreeSet.TariffSetEntry tse = this.getContract().getTts().getTreeEntry(time);
            if (tse != null) {
                this.tariffTreeId = tse.getTree().getTreeId();
                float servicePart = DialUpSessionUtils.getPart(this.calculatePeriodStart, this.calculatePeriodEnd, sid, this.serviceRanges);
                float tariffPart = tse.getPartOnPeriod(this.calculatePeriodStart, this.calculatePeriodEnd);
                float tariffPartSuspended = tse.getPartOnPeriod(this.calculatePeriodStart, this.calculatePeriodEnd, this.suspendPeriodList);
                int level = LevelManager.getLevel(this.getContract().getId());
                TariffRequest req = new TariffRequest();
                req.setRequestParam("action", (Object)"calculate");
                req.setRequestParam("cid", (Object)contract.getId());
                req.setRequestParam("time", (Object)time);
                req.setRequestParam("time_real", (Object)new GregorianCalendar());
                req.setRequestParam("month_time", (Object)this.startTime);
                req.setRequestParam("sid", (Object)sid);
                req.setRequestParam("amount", (Object)needAmount);
                req.setRequestParam("period_end", (Object)this.calculatePeriodEnd);
                req.setRequestParam("part_service", (Object)Float.valueOf(servicePart));
                req.setRequestParam("part_tariff", (Object)Float.valueOf(tariffPart));
                req.setRequestParam("part_tariff_suspended", (Object)Float.valueOf(tariffPartSuspended));
                req.setRequestParam("tariffOptions", (Object)contract.getTariffOptions());
                req.setRequestParam("level", (Object)level);
                if (useLimits) {
                    req.setRequestParam("balance", (Object)Float.valueOf(balance_sum));
                }
                tse.getTree().processRequest(req);
                if (req.wasAccepted()) {
                    Set attrSets;
                    Map dialupTariffZoneMap;
                    Float costAmount = (Float)req.getResponseParam("costAmount");
                    Float dividend = (Float)req.getResponseParam("cost");
                    Long divisor = (Long)req.getResponseParam("divisor");
                    cr.sessionDetailDelayedUpdate = req.getResponseParam("session_detail.delayed.update") != null;
                    cr.logSessionDelayedUpdate = req.getResponseParam("log_session.delayed.update") != null;
                    Long amountRest = (Long)req.getRequestParam("amount");
                    if (costAmount != null && amountRest != null) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.addLogDebug("costAmount => " + costAmount.toString());
                            this.addLogDebug("amountRest => " + amountRest.toString());
                        }
                        cr.takedService = useLimits ? needAmount - amountRest : needAmount;
                        cr.takedMoney = costAmount.floatValue();
                    } else if (dividend != null && divisor != null) {
                        Float tariff;
                        Float f = tariff = dividend.floatValue() >= 0.0f && divisor > 0L ? Float.valueOf(dividend.floatValue() / divisor.floatValue()) : null;
                        if (this.getLogger().isDebugEnabled()) {
                            this.addLogDebug("tariff => " + (tariff != null ? tariff.toString() : "NULL"));
                        }
                        long maxAmount = needAmount;
                        if (tariff == null) {
                            maxAmount = 0L;
                        } else if (tariff.floatValue() != 0.0f) {
                            maxAmount = (int)(balance_sum / tariff.floatValue());
                        }
                        if (maxAmount < 0L) {
                            maxAmount = 0L;
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            this.addLogDebug("maxAmount => " + maxAmount);
                        }
                        cr.takedMoney = 0.0f;
                        if (tariff != null) {
                            cr.takedService = useLimits ? Math.min(maxAmount, needAmount) : needAmount;
                            cr.takedMoney = (float)cr.takedService * (tariff == null ? 0.0f : tariff.floatValue());
                        }
                    }
                    if (useLimits && limitChecker != null && cr.takedService != 0L) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.addLogDebug("Use limiting takedService => " + cr.takedService + "; takedMoney => " + cr.takedMoney);
                        }
                        Float money = Float.valueOf(cr.takedMoney);
                        Long service = cr.takedService;
                        float tariff = cr.takedMoney / (float)cr.takedService;
                        if (this.getLogger().isDebugEnabled()) {
                            this.addLogDebug("Using tariff " + tariff);
                        }
                        Vector limits = limitChecker.limitServiceAndMoney(this.getLogin().getId(), sid, service, money, time, tariff);
                        service = (Long)limits.get(0);
                        money = (Float)limits.get(1);
                        if (service != null) {
                            cr.takedService = service;
                        }
                        if (money != null) {
                            cr.takedMoney = money.floatValue();
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            this.addLogDebug("after Limiting serviceAmount => " + cr.takedService + "; summa => " + cr.takedMoney);
                        }
                    }
                    if ((dialupTariffZoneMap = (Map)req.getResponseParam("dialupTariffZoneMap")) != null) {
                        for (TariffZoneTariffTreeNode zone : dialupTariffZoneMap.values()) {
                            Set changedZoneAttributeSets;
                            this.addLogInfo("Taking zone " + zone.getZone() + " from response on calculate sid=" + sid);
                            TariffZoneEntry oldZoneEntry = this.dialupTariffZoneMap.get(zone.getZoneSet());
                            if (oldZoneEntry == null) {
                                this.dialupTariffZoneMap.put(zone.getZoneSet(), new TariffZoneEntry(zone, null));
                                continue;
                            }
                            if (!this.zoneChanged(zone, oldZoneEntry.zone)) continue;
                            oldZoneEntry.oldZone = oldZoneEntry.zone;
                            oldZoneEntry.zone = zone;
                            oldZoneEntry.changed = true;
                            oldZoneEntry.attributeSets = changedZoneAttributeSets = (Set)req.getResponseParam("attr_set");
                        }
                    }
                    if ((attrSets = (Set)req.getResponseParam("attr_set")) != null) {
                        this.fullCalcAttributeSets.addAll(attrSets);
                    }
                    if (costAmount != null && amountRest != null) {
                        req = new TariffRequest();
                        req.setRequestParam("action", (Object)"init");
                        req.setRequestParam("cid", (Object)contract.getId());
                        req.setRequestParam("time", (Object)time);
                        req.setRequestParam("month_time", (Object)this.startTime);
                        req.setRequestParam("sid", (Object)sid);
                        req.setRequestParam("period_end", (Object)this.calculatePeriodEnd);
                        req.setRequestParam("amount", (Object)cr.takedService);
                        req.setRequestParam("part_service", (Object)Float.valueOf(servicePart));
                        req.setRequestParam("part_tariff", (Object)Float.valueOf(tariffPart));
                        req.setRequestParam("part_tariff_suspended", (Object)Float.valueOf(tariffPartSuspended));
                        req.setRequestParam("tariffOptions", (Object)contract.getTariffOptions());
                        req.setRequestParam("level", (Object)level);
                        tse.getTree().processRequest(req);
                        this.addLogDebug("Send action=init request ot tarifff tree..");
                    }
                } else {
                    this.addLogError("Request wasn't accepted: " + req.toString());
                }
            }
            cr.takedMoney = (float)((int)((double)cr.takedMoney * 100000.0)) / 100000.0f;
            if (this.getLogger().isDebugEnabled()) {
                this.addLogDebug("takedService => " + cr.takedService + "; takedMoney => " + cr.takedMoney);
            }
            this.updateSessionAndContractAccounts(con, sid, BigDecimal.valueOf(cr.takedMoney));
            if (limitChecker != null && limitChecker.hasConditions(this.getLogin().getId())) {
                this.updateLoginAccount(con, time, sid, cr.takedService, cr.takedMoney);
            }
            this.updateSessionDetail(con, time, sid, cr.takedService, cr.sessionDetailDelayedUpdate && useLimits);
            if (limitChecker != null) {
                limitChecker.substFromLimits(this.getLogin().getId(), sid, time, cr.takedService, cr.takedMoney);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cr;
    }

    public void createSession(Connection con) {
        block16: {
            String query = null;
            try {
                query = "INSERT INTO " + this.logSessionTableName + " ( lid, nas_id, nas_port, session_id, session_start, session_stop, session_time, session_cost, from_number, to_number, lr, ipaddr,login_name, sid_time, fake ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
                try (PreparedStatement ps = con.prepareStatement(query, 1);){
                    ps.setInt(1, this.getLogin().getId());
                    ps.setInt(2, this.getNasId());
                    ps.setString(3, this.getNasPort());
                    ps.setString(4, this.getAcctSessionId());
                    ps.setTimestamp(5, new Timestamp(this.getStartTime().getTime().getTime()));
                    ps.setTimestamp(6, new Timestamp(this.getStartTime().getTime().getTime()));
                    ps.setInt(7, 0);
                    ps.setFloat(8, 0.0f);
                    ps.setString(9, this.getFromNumber() == null ? "UNDEF" : this.getFromNumber());
                    ps.setString(10, this.getToNumber() == null ? "UNDEF" : this.getToNumber());
                    ps.setInt(11, this.getRequestLogRecordId());
                    ps.setLong(12, this.getIpAddress());
                    ps.setString(13, this.getLoginName());
                    ps.setInt(14, this.getServiceTime());
                    ps.setInt(15, this.isFakeSession() ? 1 : 0);
                    ps.executeUpdate();
                    this.setLogRecordId(ServerUtils.lastInsertId((PreparedStatement)ps));
                }
                if (this.ipNets.size() <= 0) break block16;
                query = "INSERT INTO " + this.sessionNetTableName + " (session_id, net, mask) VALUES (?, ?, ?) ";
                ps = con.prepareStatement(query);
                try {
                    ps.setInt(1, this.getLogRecordId());
                    for (IpNet net : this.ipNets) {
                        ps.setLong(2, net.net);
                        ps.setLong(3, net.mask);
                        ps.executeUpdate();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void updateSessionAndContractAccounts(Connection con, int sid, BigDecimal summa) {
        String query = null;
        if (summa.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        if (this.logRecordId < 0 || con == null || sid < 0 || this.contract == null || this.contract.getId() < 0 || this.startTime == null) {
            System.err.println("Error params bitel.billing.server.call.bean.Session::updateBalanceAndAccounts()");
            return;
        }
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.addLogDebug("Session updateBalanceAndAccounts sid => " + sid + "; summa => " + summa);
            }
            new BalanceUtils(con).addContractAccount(this.contract.getId(), TimeUtils.convertDateToLocalDate((Date)this.startTime.getTime()), sid, summa);
            query = "UPDATE " + this.sessionAccountTableName + " SET summa=summa+? WHERE sid=? AND session_id=? ";
            PreparedStatement psUpdateSessionAccount = con.prepareStatement(query);
            psUpdateSessionAccount.setBigDecimal(1, summa);
            psUpdateSessionAccount.setInt(2, sid);
            psUpdateSessionAccount.setInt(3, this.logRecordId);
            if (psUpdateSessionAccount.executeUpdate() == 0) {
                if (this.getLogger().isDebugEnabled()) {
                    this.addLogDebug("inserting new record in " + this.sessionAccountTableName);
                }
                query = "INSERT INTO " + this.sessionAccountTableName + " (sid, summa, cid, session_id) VALUES(?, ?, ?, ?)";
                PreparedStatement psInsertSessionAccount = con.prepareStatement(query);
                psInsertSessionAccount.setInt(1, sid);
                psInsertSessionAccount.setBigDecimal(2, summa);
                psInsertSessionAccount.setInt(3, this.contract.getId());
                psInsertSessionAccount.setInt(4, this.logRecordId);
                psInsertSessionAccount.executeUpdate();
                psInsertSessionAccount.close();
            }
            psUpdateSessionAccount.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void updateLoginAccount(Connection con, Calendar time, int serviceID, long serviceAmount, float summa) {
        if (this.getLogger().isDebugEnabled()) {
            this.addLogDebug("Session updateLoginAccount serviceID => " + serviceID + "; amount => " + serviceAmount + "; summa => " + summa);
        }
        if (serviceAmount != 0L || summa != 0.0f) {
            try {
                String query = "UPDATE " + this.loginAccountTableName + " SET amount=amount + ?, sum=sum + ? WHERE  lid=? AND sid=? AND dm=? AND hh=?";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setLong(1, serviceAmount);
                ps.setFloat(2, summa);
                ps.setInt(3, this.getLogin().getId());
                ps.setInt(4, serviceID);
                ps.setInt(5, time.get(5));
                ps.setInt(6, time.get(11));
                if (ps.executeUpdate() == 0) {
                    ps.close();
                    if (this.getLogger().isDebugEnabled()) {
                        this.addLogDebug("inserting new record in" + this.loginAccountTableName);
                    }
                    query = "INSERT INTO " + this.loginAccountTableName + " values (?, ?, ?, ?, ?, ?) ";
                    ps = con.prepareStatement(query);
                    ps.setInt(1, time.get(5));
                    ps.setInt(2, time.get(11));
                    ps.setInt(3, this.getLogin().getId());
                    ps.setInt(4, serviceID);
                    ps.setLong(5, serviceAmount);
                    ps.setFloat(6, summa);
                    ps.executeUpdate();
                    ps.close();
                } else {
                    ps.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void updateContractBalance(Connection con, float addCost) {
        if (this.getLogger().isDebugEnabled()) {
            this.addLogDebug("Updating contract_balance add cost=" + addCost);
        }
        if (addCost == 0.0f) {
            if (this.getLogger().isDebugEnabled()) {
                this.addLogDebug("Skip zero update balance");
            }
            return;
        }
        try (BalanceUtils bu = new BalanceUtils(con);){
            if (this.balanceAddCount++ > 10) {
                if (this.getLogger().isDebugEnabled()) {
                    this.addLogDebug("Append account");
                }
                bu.setBalanceFromAccount(this.contract, this.startTime);
                this.balanceAddCount = 0;
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.addLogDebug("Insert account");
                }
                bu.addBalanceAccount(this.contract, this.startTime, BigDecimal.valueOf(addCost));
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private void updateSession(Connection con, float addCost, boolean delayedUpdate) {
        if (this.getLogger().isDebugEnabled()) {
            this.addLogDebug("DialUpSessionRealtime updateSession  addCost => " + addCost + "; bytesIn => " + this.getBytesIn() + "; bytesOut => " + this.getBytesOut());
        }
        if (this.wasFirstUpdate && addCost == 0.0f && delayedUpdate) {
            if (this.getLogger().isDebugEnabled()) {
                this.addLogDebug("Update log_session_delayed");
            }
            return;
        }
        this.wasFirstUpdate = true;
        String query = null;
        try {
            query = "UPDATE LOW_PRIORITY " + this.logSessionTableName + " SET session_stop=?, session_time=TIME_TO_SEC( TIMEDIFF( session_stop, session_start) ), session_cost=session_cost+?, input_octets=?, output_octets=?, ipaddr=? WHERE id=?";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setTimestamp(1, TimeUtils.convertCalendarToTimestamp((Calendar)this.calculatedStopTime));
            ps.setFloat(2, addCost);
            ps.setLong(3, this.getBytesIn());
            ps.setLong(4, this.getBytesOut());
            ps.setLong(5, this.getIpAddress());
            ps.setInt(6, this.getLogRecordId());
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void closeSession(Connection con, int status) {
        String query = null;
        PreparedStatement ps = null;
        try {
            query = "UPDATE " + this.logSessionTableName + " SET status=? WHERE id=?";
            ps = con.prepareStatement(query);
            ps.setInt(1, status);
            ps.setInt(2, this.getLogRecordId());
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public long getMaxServiceAmount(Connection con, int serviceId, Calendar time) {
        long result = 0L;
        TariffTreeSet.TariffSetEntry tse = this.getContract().getTts().getTreeEntry(time);
        if (tse != null) {
            float servicePart = DialUpSessionUtils.getPart(this.calculatePeriodStart, this.calculatePeriodEnd, serviceId, this.serviceRanges);
            float tariffPart = tse.getPartOnPeriod(this.calculatePeriodStart, this.calculatePeriodEnd);
            float tariffPartSuspended = tse.getPartOnPeriod(this.calculatePeriodStart, this.calculatePeriodEnd, this.suspendPeriodList);
            TariffRequest req = new TariffRequest();
            req.setRequestParam("action", (Object)"calculate");
            req.setRequestParam("cid", (Object)this.getContract().getId());
            req.setRequestParam("sid", (Object)serviceId);
            req.setRequestParam("time", (Object)time);
            req.setRequestParam("month_time", (Object)this.startTime);
            req.setRequestParam("amount", (Object)1L);
            req.setRequestParam("period_end", (Object)this.calculatePeriodEnd);
            req.setRequestParam("part_service", (Object)Float.valueOf(servicePart));
            req.setRequestParam("part_tariff", (Object)Float.valueOf(tariffPart));
            req.setRequestParam("part_tariff_suspended", (Object)Float.valueOf(tariffPartSuspended));
            tse.getTree().processRequest(req);
            if (req.wasAccepted()) {
                Float cost = (Float)req.getResponseParam("cost");
                Long divisor = (Long)req.getResponseParam("divisor");
                if (cost != null && cost.floatValue() >= 0.0f && divisor != null && divisor > 0L) {
                    float balance = new BalanceUtils(con).getBalance(time.getTime(), this.contract.getId()).floatValue();
                    result = (long)(balance / cost.floatValue() * (float)divisor.longValue());
                }
            }
        }
        return result;
    }

    public boolean checkPrices(Calendar time, Set<Integer> attrSets, Set<Integer> nasSet, List<String> authAttrFilters) {
        TariffTreeSet.TariffSetEntry tse = this.getContract().getTts().getTreeEntry(time);
        if (tse != null) {
            if (!this.checkServicePrice(tse, this.serviceTime, time, attrSets, nasSet, authAttrFilters)) {
                return false;
            }
            Iterator<Traffic> it = this.trafficConfig.iterator();
            while (it.hasNext()) {
                int sid = it.next().getServiceId();
                if (this.checkServicePrice(tse, sid, time, attrSets, nasSet, authAttrFilters)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Set<Integer> getServices() {
        HashSet<Integer> result = new HashSet<Integer>();
        result.add(this.serviceTime);
        for (Traffic tr : this.trafficConfig) {
            result.add(tr.getServiceId());
        }
        return result;
    }

    private boolean checkServicePrice(TariffTreeSet.TariffSetEntry tse, int sid, Calendar time, Set<Integer> attrSets, Set<Integer> nasSet, List<String> authAttrFilters) {
        boolean result = false;
        float servicePart = DialUpSessionUtils.getPart(this.calculatePeriodStart, this.calculatePeriodEnd, sid, this.serviceRanges);
        float tariffPart = tse.getPartOnPeriod(this.calculatePeriodStart, this.calculatePeriodEnd);
        float tariffPartSuspended = tse.getPartOnPeriod(this.calculatePeriodStart, this.calculatePeriodEnd, this.suspendPeriodList);
        TariffRequest req = new TariffRequest();
        req.setRequestParam("action", (Object)"calculate");
        req.setRequestParam("cid", (Object)this.getContract().getId());
        req.setRequestParam("sid", (Object)sid);
        req.setRequestParam("time", (Object)time);
        req.setRequestParam("month_time", (Object)this.startTime);
        req.setRequestParam("amount", (Object)1L);
        req.setRequestParam("period_end", (Object)this.calculatePeriodEnd);
        req.setRequestParam("part_service", (Object)Float.valueOf(servicePart));
        req.setRequestParam("part_tariff", (Object)Float.valueOf(tariffPart));
        req.setRequestParam("part_tariff_suspended", (Object)Float.valueOf(tariffPartSuspended));
        req.setRequestParam("tariffOptions", (Object)this.contract.getTariffOptions());
        req.setRequestParam("level", (Object)LevelManager.getLevel(this.getContract().getId()));
        tse.getTree().processRequest(req);
        if (req.wasAccepted()) {
            boolean notSendRealm;
            Map newDialupTariffZoneMap;
            Set nases;
            Long amountRest = (Long)req.getRequestParam("amount");
            boolean bl = result = amountRest != null && amountRest == 0L && req.getResponseParam("costAmount") != null;
            if (!result) {
                Float cost = (Float)req.getResponseParam("cost");
                Long divisor = (Long)req.getResponseParam("divisor");
                boolean bl2 = result = cost != null && cost.floatValue() >= 0.0f && divisor != null && divisor > 0L;
            }
            if (result) {
                Set attrSet = (Set)req.getResponseParam("attr_set");
                if (attrSet != null) {
                    attrSets.addAll(attrSet);
                }
                int pos = 0;
                Object value = null;
                String string = "radius.auth.attr.filter.";
                while ((value = (String)req.getResponseParam("radius.auth.attr.filter." + String.valueOf(++pos))) != null) {
                    authAttrFilters.add((String)value);
                }
            }
            if ((nases = (Set)req.getRequestParam("nas_set")) != null) {
                nasSet.addAll(nases);
            }
            if ((newDialupTariffZoneMap = (Map)req.getResponseParam("dialupTariffZoneMap")) != null) {
                for (TariffZoneTariffTreeNode tariffZoneTariffTreeNode : newDialupTariffZoneMap.values()) {
                    this.dialupTariffZoneMap.put(tariffZoneTariffTreeNode.getZoneSet(), new TariffZoneEntry(tariffZoneTariffTreeNode, null));
                }
            }
            for (TariffZoneEntry tariffZoneEntry : this.dialupTariffZoneMap.values()) {
                this.addLogInfo("Taking zone " + tariffZoneEntry.zone.getZone() + " from response on calculate sid=" + sid);
            }
            boolean bl3 = notSendRealm = req.getResponseParam("not.send.realm.attributes") != null;
            if (notSendRealm) {
                ((DialUpLogin)this.login).setRpMode(1);
            }
        }
        return result;
    }

    @Deprecated
    public void resetAndInitTreeSet(Calendar time, Connection con) throws BGException, SQLException {
        this.initServiceRanges(con);
        Calendar month = (Calendar)time.clone();
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)month);
        month.set(5, month.getActualMinimum(5));
        ContractStatusDao contractStatusDao = new ContractStatusDao(con);
        this.suspendPeriodList = contractStatusDao.getPeriodList(this.contract.getId(), 0, StatusCache.getInstance().getModuleSuspendStatusSet(this.mid), month.getTime(), null);
        this.initTree(time, con, this.contract.getTts());
    }

    public void resetAndInitTreeSet(ContractStatusDao contractStatusDao, Calendar time, Connection con) throws SQLException {
        this.initServiceRanges(con);
        Calendar month = (Calendar)time.clone();
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)month);
        month.set(5, month.getActualMinimum(5));
        this.suspendPeriodList = contractStatusDao.getPeriodList(this.contract.getId(), 0, StatusCache.getInstance().getModuleSuspendStatusSet(this.mid), month.getTime(), null);
        this.initTree(time, con, this.contract.getTts());
    }

    private void initServiceRanges(Connection con) {
        StringBuffer sids = new StringBuffer(20);
        sids.append(this.serviceTime);
        for (Traffic traffic : this.trafficConfig) {
            sids.append(",");
            sids.append(traffic.getServiceId());
        }
        this.serviceRanges = new DialUpSessionUtils(con, this.mid).getServiceRangeMap(this.contract.getId(), sids.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTree(Calendar time, Connection con, TariffTreeSet tts) {
        StringBuffer sids = new StringBuffer(20);
        Integer cid = this.getContract().getId();
        AtomicInteger currentCount = null;
        Map<Integer, AtomicInteger> map = contractInitCountMap;
        synchronized (map) {
            currentCount = contractInitCountMap.get(cid);
            if (currentCount == null) {
                currentCount = new AtomicInteger();
                contractInitCountMap.put(cid, currentCount);
            }
        }
        currentCount.incrementAndGet();
        map = currentCount;
        synchronized (map) {
            for (TariffModuleTree tree : tts.getTreeList()) {
                this.resetService(tree, this.serviceTime, sids);
                for (Traffic traffic : this.trafficConfig) {
                    this.resetService(tree, traffic.getServiceId(), sids);
                }
            }
            if (sids.length() > 0) {
                Calendar start = (Calendar)this.calculatePeriodStart.clone();
                Calendar end = (Calendar)this.calculatePeriodEnd.clone();
                String tableName = null;
                String sessionTableName = null;
                while (TimeUtils.monthsDelta((Calendar)start, (Calendar)end) >= 0) {
                    tableName = ServerUtils.getModuleMonthTableName((String)"session_detail", (Date)start.getTime(), (int)this.getMid());
                    sessionTableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)start.getTime(), (int)this.getMid());
                    this.initForMonth(con, cid, tableName, sessionTableName, sids.toString(), tts, start);
                    start.add(2, 1);
                }
            }
        }
        if (currentCount.decrementAndGet() == 0) {
            map = contractInitCountMap;
            synchronized (map) {
                contractInitCountMap.remove(cid);
            }
        }
    }

    private void initForMonth(Connection con, Integer cid, String sessionDetailTable, String sessionTable, String sids, TariffTreeSet tts, Calendar month) {
        try {
            if (ServerUtils.tableExists((Connection)con, (String)sessionDetailTable)) {
                String query = "SELECT dtime, amount, sid FROM " + sessionDetailTable + " AS detail INNER JOIN " + sessionTable + " AS session ON session.id=detail.session_id WHERE cid=? AND sid IN ( " + sids + " ) AND TO_DAYS(dtime)>=TO_DAYS(?)";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setInt(1, cid);
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)this.calculatePeriodStart));
                TariffRequest req = null;
                Calendar time = null;
                int level = LevelManager.getLevel(this.getContract().getId());
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    req = new TariffRequest();
                    req.setRequestParam("cid", (Object)cid);
                    req.setRequestParam("action", (Object)"init");
                    time = TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp(1));
                    Integer sid = rs.getInt(3);
                    TariffTreeSet.TariffSetEntry tse = tts.getTreeEntry(time);
                    if (tse != null) {
                        float servicePart = DialUpSessionUtils.getPart(this.calculatePeriodStart, this.calculatePeriodEnd, sid, this.serviceRanges);
                        float tariffPart = tse.getPartOnPeriod(this.calculatePeriodStart, this.calculatePeriodEnd);
                        float tariffPartSuspended = tse.getPartOnPeriod(this.calculatePeriodStart, this.calculatePeriodEnd, this.suspendPeriodList);
                        req.setRequestParam("sid", (Object)sid);
                        req.setRequestParam("time", (Object)time);
                        req.setRequestParam("month_time", (Object)this.startTime);
                        req.setRequestParam("amount", (Object)rs.getLong(2));
                        req.setRequestParam("period_end", this.calculatePeriodEnd.clone());
                        req.setRequestParam("part_service", (Object)Float.valueOf(servicePart));
                        req.setRequestParam("part_tariff", (Object)Float.valueOf(tariffPart));
                        req.setRequestParam("part_tariff_suspended", (Object)Float.valueOf(tariffPartSuspended));
                        req.setRequestParam("tariffOptions", (Object)this.contract.getTariffOptions());
                        req.setRequestParam("level", (Object)level);
                        tse.getTree().processRequest(req);
                        continue;
                    }
                    this.getLogger().error("Not found tariff on:" + TimeUtils.formatDate((Calendar)time) + "; cid: " + cid);
                }
                rs.close();
                ps.close();
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private void checkAndSetCalculatePeriod(Connection con, Calendar time) {
        if (this.calculatePeriodStart == null || this.calculatePeriodEnd == null || this.secondCalculatePeriod && (time.before(this.calculatePeriodStart) || this.calculatePeriodEnd.before(time)) || !this.secondCalculatePeriod && (TimeUtils.dateBefore((Calendar)time, (Calendar)this.calculatePeriodStart) || TimeUtils.dateBefore((Calendar)this.calculatePeriodEnd, (Calendar)time))) {
            this.setCalculatePeriod(con, time);
        }
    }

    private void resetService(TariffModuleTree tree, int sid, StringBuffer sids) {
        TariffRequest req = new TariffRequest();
        req.setRequestParam("action", (Object)"reset");
        req.setRequestParam("sid", (Object)sid);
        req.setRequestParam("cid", (Object)this.getContract().getId());
        tree.processRequest(req);
        if (req.getResponseParam("reset") != null) {
            if (sids.length() != 0) {
                sids.append(", ");
            }
            sids.append(sid);
        }
    }

    protected void updateSessionDetail(Connection con, Calendar time, int serviceID, long serviceAmount, boolean delayedUpdate) {
        if (this.getLogger().isDebugEnabled()) {
            this.addLogDebug("DialUpSession updateSessionDetail() serviceID => " + serviceID + "; amount => " + serviceAmount);
        }
        if (serviceAmount != 0L) {
            try {
                int hour = DetailCompressRules.getCompressRules().getRecordHour(time.get(11), serviceID);
                if (hour < 0) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Skip write detail by compress rule");
                    }
                    return;
                }
                if (hour != time.get(11)) {
                    time = (Calendar)time.clone();
                    time.set(11, hour);
                }
                TimeUtils.clear_MIN_MIL_SEC((Calendar)time);
                long hourTime = time.getTimeInMillis();
                if (delayedUpdate) {
                    long[] serviceData = this.delayedDetailData.get(serviceID);
                    if (serviceData == null) {
                        serviceData = new long[]{hourTime, 0L};
                        this.delayedDetailData.put(serviceID, serviceData);
                    }
                    if (serviceData[0] == hourTime) {
                        serviceData[1] = serviceData[1] + serviceAmount;
                    } else {
                        this.changeSessionDetail(con, new Date(serviceData[0]), serviceID, serviceData[1]);
                        serviceData[0] = hourTime;
                        serviceData[1] = serviceAmount;
                    }
                } else {
                    long[] cached = this.delayedDetailData.remove(serviceID);
                    if (cached != null) {
                        if (cached[0] == hourTime) {
                            serviceAmount += cached[1];
                        } else {
                            this.changeSessionDetail(con, new Date(cached[0]), serviceID, cached[1]);
                        }
                    }
                    this.changeSessionDetail(con, time.getTime(), serviceID, serviceAmount);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void changeSessionDetail(Connection con, Date time, int serviceID, long serviceAmount) throws SQLException {
        if (!con.getAutoCommit()) {
            con.commit();
        }
        String query = "UPDATE " + this.sessionDetailTableName + " SET amount=amount + ? WHERE  session_id=? AND sid=? AND dtime=?";
        PreparedStatement ps = con.prepareStatement(query);
        ps.setLong(1, serviceAmount);
        ps.setInt(2, this.getLogRecordId());
        ps.setInt(3, serviceID);
        ps.setTimestamp(4, TimeUtils.convertDateToTimestamp((Date)time));
        if (ps.executeUpdate() == 0) {
            ps.close();
            if (!con.getAutoCommit()) {
                con.commit();
            }
            if (this.getLogger().isDebugEnabled()) {
                this.addLogDebug("inserting new record in" + this.sessionDetailTableName);
            }
            query = "INSERT INTO " + this.sessionDetailTableName + " (session_id, sid, cid, dtime, amount) VALUES (?, ?, ?, ?, ? ) ";
            ps = con.prepareStatement(query);
            ps.setInt(1, this.getLogRecordId());
            ps.setInt(2, serviceID);
            ps.setInt(3, this.getContract().getId());
            ps.setTimestamp(4, TimeUtils.convertDateToTimestamp((Date)time));
            ps.setLong(5, serviceAmount);
            ps.executeUpdate();
            ps.close();
        } else {
            ps.close();
        }
        if (!con.getAutoCommit()) {
            con.commit();
        }
    }

    public Calendar getCalculatePeriodEnd() {
        return this.calculatePeriodEnd;
    }

    public Calendar getCalculatePeriodStart() {
        return this.calculatePeriodStart;
    }

    public void setCalculatePeriod(Calendar start, Calendar end) {
        this.calculatePeriodStart = start;
        this.calculatePeriodEnd = end;
    }

    public void setCalculatePeriod(Connection con, Calendar requestDate) {
        this.calculatePeriodStart = null;
        this.calculatePeriodEnd = null;
        String tableName = "calculate_period_" + this.getMid();
        this.addLogInfo("Request for taking calculate period..");
        try {
            if (ServerUtils.tableExists((Connection)con, (String)tableName)) {
                String query = "SELECT start, end FROM " + tableName + " WHERE cid=? AND start<=? AND end>=? LIMIT 1";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setInt(1, this.getContract().getId());
                if (this.secondCalculatePeriod) {
                    ps.setTimestamp(2, TimeUtils.convertCalendarToTimestamp((Calendar)requestDate));
                    ps.setTimestamp(3, TimeUtils.convertCalendarToTimestamp((Calendar)requestDate));
                } else {
                    ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)requestDate));
                    ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)requestDate));
                }
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    if (this.secondCalculatePeriod) {
                        this.calculatePeriodStart = TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp(1));
                        this.calculatePeriodEnd = TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp(2));
                    } else {
                        this.calculatePeriodStart = TimeUtils.convertDateToCalendar((Date)rs.getDate(1));
                        this.calculatePeriodEnd = TimeUtils.convertDateToCalendar((Date)rs.getDate(2));
                    }
                }
                rs.close();
                ps.close();
                if (this.calculatePeriodStart == null) {
                    this.addLogDebug("Request period to script..");
                    OpenPeriodRequestEvent event = new OpenPeriodRequestEvent(this.getMid(), this.contract, this.loginName);
                    event.setRequestDate(requestDate);
                    event = (OpenPeriodRequestEvent)EventProcessor.getInstance().request((QueueEvent)event);
                    if (event.isProcessed()) {
                        this.addLogDebug("Script processed request");
                        if (event.getPeriodStart() == null || event.getPeriodEnd() == null) {
                            this.addLogError("Not start and end set up in event after request!");
                        } else {
                            this.calculatePeriodStart = event.getPeriodStart();
                            this.calculatePeriodEnd = event.getPeriodEnd();
                            query = "INSERT INTO " + tableName + " (cid, start, end) VALUES (? ,? ,?)";
                            ps = con.prepareStatement(query);
                            ps.setInt(1, this.getContract().getId());
                            if (this.secondCalculatePeriod) {
                                ps.setTimestamp(2, TimeUtils.convertCalendarToTimestamp((Calendar)this.calculatePeriodStart));
                                ps.setTimestamp(3, TimeUtils.convertCalendarToTimestamp((Calendar)this.calculatePeriodEnd));
                            } else {
                                ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)this.calculatePeriodStart));
                                ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)this.calculatePeriodEnd));
                            }
                            ps.executeUpdate();
                            ps.close();
                        }
                    } else {
                        this.addLogDebug("Set start and end of month.");
                        this.setMonthAsCalculatePeriod(requestDate);
                    }
                }
            } else {
                this.addLogError("Table " + tableName + " doesn't exists!");
            }
        }
        catch (Exception ex) {
            String key = "bgbs.contract.script.error";
            AlarmSender.sendAlarm((String)"bgbs.contract.script.error", (long)0L, (String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0431\u043e\u0442\u044b BGBS \u0441\u043a\u0440\u0438\u043f\u0442\u0430", (String)ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
        }
        this.addLogInfo("calculatePeriodStart: " + TimeUtils.format((Calendar)this.calculatePeriodStart, (String)"dd.MM.yyyy HH:mm:ss") + "; calculatePeriodEnd: " + TimeUtils.format((Calendar)this.calculatePeriodEnd, (String)"dd.MM.yyyy HH:mm:ss"));
    }

    public void setMonthAsCalculatePeriod(Calendar requestDate) {
        Calendar dt = (Calendar)requestDate.clone();
        dt.set(5, dt.getActualMinimum(5));
        this.calculatePeriodStart = dt;
        dt = (Calendar)requestDate.clone();
        dt.set(5, dt.getActualMaximum(5));
        if (this.secondCalculatePeriod) {
            dt.set(11, dt.getActualMaximum(11));
            dt.set(12, 59);
            dt.set(13, 59);
        }
        this.calculatePeriodEnd = dt;
    }

    public void restoreIpNets(Connection con) {
        try {
            String query = "SELECT net, mask FROM " + this.sessionNetTableName + " WHERE session_id=?";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setInt(1, this.getLogRecordId());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                IpNet ipNet = new IpNet();
                ipNet.net = rs.getLong(1);
                ipNet.mask = rs.getLong(2);
                this.ipNets.add(ipNet);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, TariffZoneEntry> getZoneMap() {
        return this.dialupTariffZoneMap;
    }

    public class TariffZoneEntry {
        TariffZoneTariffTreeNode zone;
        boolean changed = false;
        TariffZoneTariffTreeNode oldZone;
        Set<Integer> attributeSets;

        public TariffZoneEntry(TariffZoneTariffTreeNode zone, Set<Integer> attributeSets) {
            assert (zone != null);
            this.zone = zone;
            this.attributeSets = attributeSets;
        }

        public TariffZoneTariffTreeNode getZone() {
            return this.zone;
        }

        void recycle() {
            this.oldZone = null;
            this.changed = false;
            this.attributeSets = null;
        }
    }
}

