<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<c:if test="${not empty message}"><div><%@ include file="/WEB-INF/jspf/include/popup_message.jsp"%></div></c:if>

<div class="tile">
	<bg:blockTitle title="${masterAction.title}"/>
	<c:if test="${not empty masterActionComment}"><div class="sf-2 mb-0 alert alert-primary">${masterActionComment}</div></c:if>
	<form id="assistantMasterForm" method="POST">
	<c:choose>
		<c:when test="${not empty masterFields}">
			<c:forEach var="field" items="${masterFields}">
				<c:choose>
					<c:when test="${field.type eq 'HIDDEN' }"><input type="hidden" name="${field.key}" value="${field.value}"></c:when>
					<c:when test="${field.type eq 'STRING' }">
						<div class="mt-2">
							<label for="${field.key}" class="form-label mb-0">${field.title}</label>
							<input type="text" id="${field.key}" name="${field.key}" value="${field.value}" class="form-control" placeholder="${field.comment}">
						</div>
					</c:when>
					<c:when test="${field.type eq 'BOOLEAN' }">
						<div class="mt-2">
							<c:set var="checked"><c:if test="${field.value eq 'true'}">checked="checked"</c:if></c:set>
							<label for="${field.key}" class="form-label mb-0">${field.title}</label>
							<input type="checkbox" id="${field.key}" name="${field.key}" ${checked}>
						</div>
					</c:when>
					<c:when test="${field.type eq 'INTEGER' }">
						<div class="mt-2">
							<label for="${field.key}" class="form-label mb-0">${field.title}</label>
							<input type="number" pattern="^\d+$" id="${field.key}" name="${field.key}" value="${field.value}" class="form-control" placeholder="${field.comment}">
						</div>
					</c:when>
					<c:when test="${field.type eq 'DECIMAL' }">
						<div class="mt-2">
							<label for="${field.key}" class="form-label mb-0">${field.title}</label>
							<input type="number" id="${field.key}" name="${field.key}" value="${field.value}" class="form-control" placeholder="${field.comment}">
						</div>
					</c:when>
					<c:when test="${field.type eq 'LABEL' }">
						<div class="mt-2 fs-4 titleBottomLine2	">${field.value}</div>
					</c:when>
					<c:when test="${field.type eq 'DATE' }">
						<div class="mt-2">
							<label for="${field.key}" class="form-label mb-0">${field.title}</label>
							<input type="date" id="${field.key}" name="${field.key}" value="${field.value}" class="form-control">
						</div>
					</c:when>
					<c:when test="${field.type eq 'PERIOD' }">
						<div class="mt-2">
							<label for="${field.key}" class="form-label mb-0">${field.title}</label>
							<div style="display: grid; grid-template-columns: minmax( 100px, 1fr ) 10px minmax( 100px, 1fr ); grid-gap: 1rem;">
								<input type="date" id="${field.key}" name="${field.key}From" value="${field.value}" class="form-control">
								<span>-</span> 
								<input type="date" name="${field.key}To" value="${field.value}" class="form-control">
							</div>
						</div>
					</c:when>
					<c:when test="${field.type eq 'CONTRACT' }">
						<div class="mt-2">
							<label for="${field.key}" class="form-label mb-0">${field.title}</label>
							<select id="${field.key}" name="${field.key}" class="form-control"></select>
						</div>
					</c:when>
					<c:when test="${field.type eq 'COMBOX' }">
						<div class="mt-2">
							<label for="${field.key}" class="form-label mb-0">${field.title}</label>
							<select id="${field.key}" name="${field.key}" class="form-control"><c:forEach var="listItem" items="${field.values}"><c:set var="selected"><c:if test="${listItem.key eq field.value}">selected="selected"</c:if></c:set><option value="${listItem.key}" ${selected}>${listItem.value}</option></c:forEach></select>
						</div>
					</c:when>
					<c:when test="${field.type eq 'LIST' }">
						<div class="mt-2">
							<label for="${field.key}" class="form-label mb-0">${field.title}</label>
							<select size="6" id="${field.key}" name="${field.key}" class="form-control"><c:forEach var="listItem" items="${field.values}"><c:set var="selected"><c:if test="${listItem.key eq field.value}">selected="selected"</c:if></c:set><option value="${listItem.key}" ${selected}>${listItem.value}</option></c:forEach></select>
						</div>
					</c:when>
					<c:when test="${field.type eq 'TEXTAREA' }">
						<div class="mt-2">
							<label for="${field.key}" class="form-label mb-0">${field.title}</label>
							<textarea id="${field.key}" name="${field.key}" class="form-control" placeholder="${field.comment}">${field.value}</textarea>
						</div>
					</c:when>
					<c:when test="${field.type eq 'LINK' }">
						<div class="mt-2"><a href="${field.value}">${field.title}</a></div>
					</c:when>
					<c:when test="${field.type eq 'TABLE' }">
						<div class="mt-2">
							<label for="${field.key}" class="form-label mb-0">${field.title}</label>
							<table class="table table-primary table-striped" id="${field.key}">
								<thead>
									<tr>
										<th scope="col">#</th>
										<th scope="col">col 1</th>
										<th scope="col">col 2</th>
										<th scope="col">col 3</th>
									</tr>
								</thead>
								<tbody>
								    <tr>
								      <th scope="row">1</th>
								      <td>Mark</td>
								      <td>Otto</td>
								      <td>@mdo</td>
								    </tr>
								    <tr>
								      <th scope="row">2</th>
								      <td>Mark</td>
								      <td>Otto</td>
								      <td>@mdo</td>
								    </tr>
								</tbody>								
							</table>
						</div>
					</c:when>
					<c:otherwise><div>${field.type}</div></c:otherwise>
				</c:choose>
			</c:forEach>
		</c:when>
		<c:otherwise></c:otherwise>
	</c:choose>
	<div class="formButtons">
	<c:forEach var="button" items="${masterButtons}">
		<c:choose>
			<c:when test="${button.assistantButton.code ne 'cancel' }">
				<button class="btn btn-primary" onclick="return aa( this.form, '${button.assistantButton.code}' );">${button.title}</button>
			</c:when>
			<c:otherwise>
				<button class="btn btn-primary" onclick="showBlock( 'contentRoot', 'list', dashboardQuery ); return false;">${button.title}</button>
			</c:otherwise>
		</c:choose>
	</c:forEach>
	</div>
	</form>
</div>

<script>
//var pageTitleEl = document.getElementById( "pageTitle" ); 
//if ( pageTitleEl )
//{
//	pageTitleEl.innerHTML = '${master.title}';	
//};

function aa( form, buttonCode )
{
	showBlock( 'assistantRoot', 'masterDoButton', 
			{ ...assistantQuery, 
				masterId: ${master.id},
				actionId: '${masterAction.actionId}',
				<c:forEach var="field" items="${masterFields}">
				<c:if test="${field.type ne 'LABEL' and field.type ne 'LINK' and field.type ne 'TABLE'}">field_${field.key}: form['${field.key}'].value,</c:if>
				</c:forEach>
				buttonCode: buttonCode
			}
	);
	return false;
}
</script>
