/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGToolBar;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVar;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarType;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarValue;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGTitleLabel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.action.BGUAction;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;

public class TariffVarsPanel
extends BGUPanel {
    private int tariffPlanId = 0;
    private Supplier<TariffService> tariffServiceSupplier;
    private JLabel recordCountLabel = new JLabel();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGDataSourceTableModel varTableModel = new BGDataSourceTableModel("TariffVars");
    private BGDataSourceTableModel valTableModel = new BGDataSourceTableModel("TariffVarValues");
    private List<BGModule> modules = new ArrayList<BGModule>();
    BGUAction editAction = new BGUAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u043d\u0430\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", (Icon)ClientUtils.getIcon("edit")){

        @Override
        public void actionPerformed(ActionEvent e) {
            Id tariffVarId = TariffVarsPanel.this.varTableModel.getSelectRow(Id.class);
            if (tariffVarId == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                return;
            }
            TariffVarsPanel.this.tryCall(() -> {
                TariffVar tariffVar = TariffVarsPanel.this.tariffServiceSupplier.get().tariffVarGet(tariffVarId.getId());
                VarEditor editor = new VarEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", tariffVar);
                editor.open();
                if (editor.isDoApply()) {
                    TariffVarsPanel.this.tariffServiceSupplier.get().tariffVarUpdate((TariffVar)editor.getData());
                    TariffVarsPanel.this.loadTariffVars();
                }
            });
        }
    };

    public TariffVarsPanel(ClientContext context, Supplier<TariffService> tariffServiceSupplier) {
        super(context);
        this.tariffServiceSupplier = tariffServiceSupplier;
    }

    @Override
    protected void jbInit() throws Exception {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, this.getTariffVarsPanel(), (Component)this.getTariffVarValuesPanel(), 900L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    private JPanel getTariffVarsPanel() {
        BGUTable table = new BGUTable(this.varTableModel);
        table.setSelectionMode(0);
        BGSwingUtilites.handleLDMouseClicked(table, e -> this.editAction.actionPerformed(null));
        table.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.pagePanel.setPageIndex(1);
                this.loadTariffVarValues();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getToolBar(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)new JScrollPane(table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getTariffVarValuesPanel() {
        BGUTable table = new BGUTable(this.valTableModel);
        table.setSelectionMode(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new BGTitleLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 20), 0, 0));
        panel.add((Component)this.getPagePanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)new JScrollPane(table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getPagePanel() {
        this.pagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.loadTariffVarValues();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getValueToolBar(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.recordCountLabel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 20, 0, 0), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        return panel;
    }

    private BGToolBar getValueToolBar() {
        BGToolBar toolBar = new BGToolBar(true);
        toolBar.setFloatable(false);
        toolBar.add(new BGUAction("addValue", "\u041d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", (Icon)ClientUtils.getIcon("add")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TariffVar tariffVar = TariffVarsPanel.this.varTableModel.getSelectRow(TariffVar.class);
                if (tariffVar == null) {
                    ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e");
                    return;
                }
                new ValEditorDialog("\u041d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", tariffVar, new TariffVarValue().setTariffVarId(tariffVar.getId())).open();
            }
        });
        toolBar.add(Box.createHorizontalStrut(5));
        toolBar.add(new BGUAction("deleteValue", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", (Icon)ClientUtils.getIcon("delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TariffVarValue tariffVarValue = TariffVarsPanel.this.valTableModel.getSelectRow(TariffVarValue.class);
                if (tariffVarValue == null) {
                    ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439");
                    return;
                }
                if (ClientUtils.confirmDelete(tariffVarValue.getValue())) {
                    TariffVarsPanel.this.tryCall(() -> TariffVarsPanel.this.tariffServiceSupplier.get().tariffVarValueDelete(tariffVarValue));
                    TariffVarsPanel.this.loadTariffVarValues();
                }
            }
        });
        return toolBar;
    }

    private BGToolBar getToolBar() {
        BGToolBar toolBar = new BGToolBar(true);
        toolBar.setFloatable(false);
        toolBar.add(new BGUAction("add", "\u041d\u043e\u0432\u0430\u044f \u0442\u0430\u0440\u0438\u0444\u043d\u0430\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", (Icon)ClientUtils.getIcon("add")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TariffVar tariffVar = new TariffVar().setTariffPlanId(TariffVarsPanel.this.tariffPlanId);
                VarEditor editor = new VarEditor("\u041d\u043e\u0432\u0430\u044f \u0442\u0430\u0440\u0438\u0444\u043d\u0430\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", tariffVar);
                editor.open();
                if (editor.isDoApply()) {
                    TariffVarsPanel.this.tryCall(() -> TariffVarsPanel.this.tariffServiceSupplier.get().tariffVarUpdate((TariffVar)editor.getData()));
                    TariffVarsPanel.this.loadTariffVars();
                }
            }
        });
        toolBar.add(Box.createHorizontalStrut(5));
        toolBar.add(this.editAction);
        toolBar.add(Box.createHorizontalStrut(5));
        toolBar.add(new BGUAction("delete", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", (Icon)ClientUtils.getIcon("delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TariffVar tariffVar = TariffVarsPanel.this.varTableModel.getSelectRow(TariffVar.class);
                if (tariffVar == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                    return;
                }
                if (tariffVar.getTopId() > 0) {
                    ClientUtils.showErrorMessageDialog("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e (\u0443\u0434\u0430\u043b\u044f\u0435\u0442\u0441\u044f \u0447\u0435\u0440\u0435\u0437 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0442\u0430\u0440\u0438\u0444)");
                    return;
                }
                if (ClientUtils.confirmDelete(tariffVar.getTitle())) {
                    TariffVarsPanel.this.tryCall(() -> TariffVarsPanel.this.tariffServiceSupplier.get().tariffVarDelete(tariffVar.getId()));
                    TariffVarsPanel.this.loadTariffVars();
                }
            }
        });
        return toolBar;
    }

    public void setData() {
        BGUTableParams tableParams = new BGUTableParams().addParam("tariffPlanId", String.valueOf(this.tariffPlanId));
        this.varTableModel.loadData((ClientContext)this.getContext(), tableParams);
    }

    public void loadTariffVars() {
        this.tryCall(() -> {
            this.setData();
            if (this.modules.isEmpty()) {
                this.modules.addAll(((ClientContext)this.getContext()).getPort(ModuleService.class, 0).moduleList());
            }
        });
    }

    public void loadTariffVarValues() {
        this.tryCall(() -> {
            Id varId = this.varTableModel.getSelectRow(Id.class);
            if (varId != null) {
                BGUTableParams tableParams = new BGUTableParams().addParam("tariffVarId", String.valueOf(varId.getId())).setPage(this.pagePanel.getPage());
                this.valTableModel.loadData((ClientContext)this.getContext(), tableParams, this.pagePanel, this.recordCountLabel);
            } else {
                this.recordCountLabel.setText("");
                this.valTableModel.deleteRows();
            }
        });
    }

    public void setTariffPlanId(int tariffPlanId) {
        this.tariffPlanId = tariffPlanId;
    }

    class ValEditorDialog
    extends BGEditorDialog<TariffVarValue> {
        private TariffVar tariffVar;
        private BGTextField varValue;
        private BGControlPanelPeriodNoB periodPanel;
        private JCheckBox varValueParent;

        public ValEditorDialog(String title, TariffVar tariffVar, TariffVarValue data) {
            super(title, data);
            this.varValue = new BGTextField(40);
            this.periodPanel = new BGControlPanelPeriodNoB();
            this.varValueParent = new JCheckBox("\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0437 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430");
            this.tariffVar = tariffVar;
        }

        @Override
        public void doDialogPanel() {
            this.varValue.setHorizontalAlignment(0);
            this.addFieldV("\u041f\u0435\u0440\u0438\u043e\u0434:", this.periodPanel);
            this.addFieldV("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435:", this.varValue);
            if (this.tariffVar.getUpId() > 0) {
                this.panel.add((Component)this.varValueParent, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            }
            this.varValueParent.addChangeListener(e -> {
                this.varValue.setEditable(!this.varValueParent.isSelected());
                if (this.varValueParent.isSelected()) {
                    this.varValue.setText("");
                }
            });
        }

        @Override
        public boolean doApply() throws Exception {
            ((TariffVarValue)this.data).setPeriod(this.periodPanel.getPeriod()).setValue(this.varValueParent.isSelected() ? null : this.varValue.getText());
            return TariffVarsPanel.this.tryCallBoolean(() -> {
                TariffVarsPanel.this.tariffServiceSupplier.get().tariffVarValueSet((TariffVarValue)this.data);
                TariffVarsPanel.this.loadTariffVarValues();
            });
        }
    }

    private class VarEditor
    extends BGEditorDialog<TariffVar> {
        private CardLayout cardLayout;
        private JPanel varDefaultPanel;
        private BGUComboBox<IdTitle> module;
        private BGUComboBox<TariffVarType> varType;
        private BGUComboBox<IdTitle> varListDefault;
        private JTextField varTitle;
        private JTextField varDefault;
        private JCheckBox varDefaultParent;
        private List<IdTitle> moduleItems;
        private List<IdTitle> varListItems;

        public VarEditor(String title, TariffVar data) {
            super(title, data);
            this.cardLayout = new CardLayout();
            this.varDefaultPanel = new JPanel(this.cardLayout);
            this.module = new BGUComboBox();
            this.varType = new BGUComboBox();
            this.varListDefault = new BGUComboBox();
            this.varTitle = new JTextField(30);
            this.varDefault = new JTextField(30);
            this.varDefaultParent = new JCheckBox("\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0437 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430");
            this.moduleItems = new ArrayList<IdTitle>();
            this.varListItems = new ArrayList<IdTitle>();
            this.moduleItems.addAll(Arrays.asList(new IdTitle(0, "\u041b\u044e\u0431\u043e\u0439")));
            TariffVarsPanel.this.modules.forEach(a -> this.moduleItems.add(new IdTitle(a.getId(), a.getTitle())));
            this.varDefault.setVisible(false);
            this.varListDefault.setVisible(false);
        }

        @Override
        public void doDialogPanel() {
            this.varDefaultPanel.add((Component)this.varDefault, "text");
            this.varDefaultPanel.add(this.varListDefault, "list");
            int gridy = 0;
            this.panel.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u044c:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.panel.add(this.module, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.panel.add((Component)new JLabel("\u0422\u0438\u043f:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.panel.add(this.varType, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.panel.add((Component)new JLabel("\u0418\u043c\u044f:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.varTitle, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.panel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.varDefaultPanel, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            if (((TariffVar)this.data).getUpId() > 0) {
                this.panel.add((Component)this.varDefaultParent, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            }
            this.panel.add(Box.createGlue(), new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
            boolean edit = ((TariffVar)this.data).getId() < 1;
            this.module.setData(this.moduleItems);
            this.module.addItemListener(TariffVarsPanel.this.comboBoxSelect(e -> this.setVarTypeItems()));
            this.module.setEnabled(edit);
            this.varType.addItemListener(TariffVarsPanel.this.comboBoxSelect(e -> this.setValue()));
            this.varType.setEnabled(edit);
            this.varDefaultParent.setSelected(((TariffVar)this.data).getUpId() > 0 && ((TariffVar)this.data).getDefaultValue().isEmpty());
            this.varDefaultParent.addChangeListener(e -> this.setValue());
            this.module.setSelectedItem(new Id().setId(((TariffVar)this.data).getModuleId()));
            this.varTitle.setText(((TariffVar)this.data).getTitle());
            this.varTitle.setEnabled(((TariffVar)this.data).getUpId() == 0);
        }

        private void setVarListItems() {
            int moduleId = ((IdTitle)this.module.getSelectedItem()).getId();
            String varTypeCode = ((TariffVarType)this.varType.getSelectedItem()).getCode();
            TariffVarsPanel.this.tryCall(() -> {
                this.varListItems = TariffVarsPanel.this.tariffServiceSupplier.get().tariffVarListItems(moduleId, varTypeCode);
                this.varListDefault.setData(this.varListItems);
                String value = ((TariffVar)this.data).getDefaultValue();
                if (value.matches("^\\d+:.*$")) {
                    int id = Utils.parseInt(value.substring(0, value.indexOf(":")));
                    this.varListDefault.setSelectedItem(this.varListItems.stream().filter(a -> a.getId() == id).findFirst().orElse(this.varListItems.get(0)));
                }
            });
        }

        private void setValue() {
            String type = ((TariffVarType)this.varType.getSelectedItem()).getType();
            this.cardLayout.show(this.varDefaultPanel, type);
            if ("list".equals(type)) {
                if (this.varDefaultParent.isSelected()) {
                    this.varListDefault.removeAllItems();
                } else {
                    this.setVarListItems();
                }
                this.varListDefault.setEnabled(!this.varDefaultParent.isSelected());
            } else {
                this.varDefault.setText(this.varDefaultParent.isSelected() ? "" : ((TariffVar)this.data).getDefaultValue());
                this.varDefault.setEditable(!this.varDefaultParent.isSelected());
            }
        }

        private void setVarTypeItems() {
            int moduleId = ((IdTitle)this.module.getSelectedItem()).getId();
            ArrayList tariffVarTypes = new ArrayList();
            Arrays.asList(TariffVarType.values()).forEach(a -> {
                String moduleName;
                BGModule bgModule = TariffVarsPanel.this.modules.stream().filter(m -> m.getId() == moduleId).findFirst().orElse(null);
                String string = moduleName = bgModule != null ? bgModule.getName() : null;
                if (a.getModuleName() == null || Arrays.asList(a.getModuleName()).contains(moduleName)) {
                    tariffVarTypes.add(a);
                }
            });
            this.varType.setData(tariffVarTypes);
            if (((TariffVar)this.data).getType() != null) {
                this.varType.setSelectedItem(this.varType.getData().stream().filter(a -> a == ((TariffVar)this.data).getType()).findFirst().orElse(this.varType.getData().get(0)));
            }
        }

        @Override
        public boolean doApply() throws Exception {
            switch ((TariffVarType)this.varType.getSelectedItem()) {
                case COST: {
                    String text;
                    if (this.varDefaultParent.isSelected()) break;
                    try {
                        text = this.varDefault.getText();
                        BigDecimal bigDecimal = new BigDecimal(text);
                        if (!bigDecimal.setScale(2, RoundingMode.HALF_UP).toString().equals(text) && !bigDecimal.setScale(0, RoundingMode.HALF_UP).toString().equals(text)) {
                            throw new BGException("");
                        }
                        break;
                    }
                    catch (Exception e) {
                        ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0432\u043e\u0434\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
                        return false;
                    }
                }
                default: {
                    String text;
                    if (!"long".equals(((TariffVarType)this.varType.getSelectedItem()).getType()) || (text = this.varDefault.getText()).matches("^\\d*$")) break;
                    ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0432\u043e\u0434\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e, \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e");
                    return false;
                }
            }
            ((TariffVar)this.data).setType((TariffVarType)this.varType.getSelectedItem());
            ((TariffVar)this.data).setModuleId(((IdTitle)this.module.getSelectedItem()).getId());
            ((TariffVar)this.data).setTitle(this.varTitle.getText().trim());
            if (this.varDefaultParent.isSelected()) {
                ((TariffVar)this.data).setDefaultValue(null);
            } else if ("list".equals(((TariffVarType)this.varType.getSelectedItem()).getType())) {
                IdTitle selectedItem = (IdTitle)this.varListDefault.getSelectedItem();
                ((TariffVar)this.data).setDefaultValue(selectedItem.getId() + ":" + selectedItem.getTitle());
            } else {
                ((TariffVar)this.data).setDefaultValue(this.varDefault.getText().trim());
            }
            this.doApply = true;
            return true;
        }

        @Override
        protected BGOptionPane getBGOptionPane() {
            return new BGOptionPane(this.panel, this.title){

                @Override
                protected void doCancel() {
                    VarEditor.this.data = null;
                }
            };
        }
    }
}

