/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin;

import bitel.billing.module.admin.ErrorLogTable;
import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGControlPanelMonthAndDays;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.time.LocalDate;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.model.Page;

public class ErrorLogViewerPanel
extends BGPanel {
    private BGControlPanelMonthAndDays periodPanel = new BGControlPanelMonthAndDays();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private ErrorLogTable errorLogTable = new ErrorLogTable();
    private JComboBox<ComboBoxItem> servicesComboBox = new JComboBox();
    private JTextArea messageText = new JTextArea();
    private JComboBox<ComboBoxItem> sourcesBox = new JComboBox();
    private boolean sourcesLoaded = false;

    public ErrorLogViewerPanel() {
        this.module = "service";
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.pagePanel.setKey(this.getClass().getName());
        BGSwingUtilites.handleLDMouseClicked(this.errorLogTable, e -> this.errorLogTable_valueChanged());
        this.setData();
    }

    private void jbInit() throws Exception {
        this.servicesComboBox.addItemListener(e -> this.servicesComboBox_itemStateChanged(e));
        JPanel sourcesPanel = new JPanel(new GridBagLayout());
        sourcesPanel.setBorder(new BGTitleBorder("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438"));
        sourcesPanel.add(this.sourcesBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(new BGTitleBorder(" \u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u043e\u0448\u0438\u0431\u043a\u0435 "));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.setBorder(new BGTitleBorder(" \u041c\u043e\u0434\u0443\u043b\u044c "));
        this.messageText.setBackground(UIManager.getColor("Panel.background"));
        this.messageText.setBorder(null);
        this.messageText.setEditable(false);
        this.messageText.setLineWrap(true);
        this.messageText.setWrapStyleWord(true);
        JScrollPane jScrollPane2 = new JScrollPane();
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane2.setBorder(null);
        this.pagePanel.init();
        this.pagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.setData();
            }
        });
        this.periodPanel.setBorder(new BGTitleBorder(" \u041f\u0435\u0440\u0438\u043e\u0434 "));
        BGButtonPanel bGControlPanel_121 = new BGButtonPanel(BGButtonPanel.GLUE, BGButtonPanel.DO_M);
        bGControlPanel_121.addActionListener(e -> this.panelActionPerformed(e));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jPanel5, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel5.add(this.servicesComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)sourcesPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.periodPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add(Box.createGlue(), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)bGControlPanel_121, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        jPanel3.add((Component)this.pagePanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        jPanel3.add((Component)jScrollPane1, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(8, 5, 0, 5), 0, 0));
        jScrollPane1.getViewport().add((Component)this.errorLogTable, null);
        jPanel4.add((Component)jScrollPane2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        jScrollPane2.getViewport().add((Component)this.messageText, null);
        BGSplitPaneNoBorder jSplitPane = new BGSplitPaneNoBorder(0, jPanel3, (Component)jPanel4, 200L);
        this.setLayout(new GridBagLayout());
        this.add((Component)jSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void loadSources() {
        Request request = new Request();
        request.setModule("load");
        request.setModuleId(this.getModuleId());
        request.setAction("SourceList");
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.sourcesBox.setModel(ClientUtils.buildComboBoxWithDefault(XMLUtils.getNode(doc, "list"), "", "\u041b\u044e\u0431\u043e\u0439"));
            this.sourcesLoaded = true;
        }
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ErrorLogList");
        if (this.getModuleId() > 0) {
            request.setModuleId(this.getModuleId());
            if (this.sourcesLoaded) {
                ComboBoxItem item = (ComboBoxItem)this.sourcesBox.getSelectedItem();
                Object o = item.getObject();
                request.setAttribute("sourceid", o.toString());
            }
            request.setPeriod(this.periodPanel.getPeriod());
            request.setPageIndex(this.pagePanel.getPageIndex());
            request.setPageSize(this.pagePanel.getPageSize());
        }
        this.setDocument(TransferManager.getDocument(request));
    }

    @Override
    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus(doc)) {
            Node services = XMLUtils.getNode(doc, "services");
            if (services.hasChildNodes()) {
                this.fl = true;
                DefaultComboBoxModel<ComboBoxItem> model = ClientUtils.buildComboBox(services, "-1");
                ComboBoxItem itemSelected = (ComboBoxItem)model.getSelectedItem();
                this.servicesComboBox.setModel(model);
                this.servicesComboBox.setSelectedItem(itemSelected);
                this.fl = false;
            }
            if (!this.sourcesLoaded) {
                this.loadSources();
            }
            this.messageText.setText("");
            Element errorMessages = XMLUtils.getElement(doc, "errorMessages");
            this.errorLogTable.setData(errorMessages);
            this.pagePanel.setPageCount(Page.getPageCount(errorMessages));
        }
    }

    private void servicesComboBox_itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            return;
        }
        ComboBoxItem item = (ComboBoxItem)e.getItem();
        this.setModuleId(Utils.parseInt((String)item.getObject(), -1));
        this.pagePanel.init();
        this.sourcesLoaded = false;
        this.setData();
    }

    private void errorLogTable_valueChanged() {
        DefaultTableModel model = (DefaultTableModel)this.errorLogTable.getModel();
        int pos = this.errorLogTable.getSelectedRow();
        if (pos < 0) {
            return;
        }
        String id = (String)model.getValueAt(pos, 0);
        LocalDate beginDate = this.periodPanel.getBeginDate();
        String date1 = beginDate == null ? null : TimeUtils.format(beginDate, "dd.MM.yyyy");
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ErrorLogMsg");
        request.setModuleId(this.getModuleId());
        request.setAttribute("id", id);
        if (date1 != null) {
            request.setAttribute("date1", date1);
        }
        Document doc = TransferManager.getDocument(request);
        this.messageText.setText("");
        Node message = XMLUtils.getNode(doc, "message");
        if (message.hasChildNodes()) {
            NodeList list = message.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node item = list.item(i);
                if (item.getNodeType() != 3) continue;
                this.messageText.append(item.getNodeValue());
            }
        }
    }

    private void panelActionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("do".equals(actionCommand)) {
            this.pagePanel.init();
            this.setData();
        }
    }
}

