/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.processors;

import bitel.billing.server.ApplicationModule;
import java.sql.Connection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPattern;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ContractObjectDao;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.LocalEvent;
import ru.bitel.bgbilling.kernel.event.events.system.CommonEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractSerializeEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ObjectMoveEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public class CommonKernelEventProcessor
extends BGLogger
implements EventListener<LocalEvent> {
    private ModuleCache moduleCache = ModuleCache.getInstance();

    public CommonKernelEventProcessor(Setup setup) throws BGException {
        EventProcessor eventProcessor = EventProcessor.getInstance();
        if (setup.get("no.event.process", null) == null) {
            eventProcessor.addListener(this, CommonEvent.class);
            eventProcessor.addListener(this, ContractCloseEvent.class);
            eventProcessor.addListener(this, ContractCreateEvent.class);
            eventProcessor.addListener(this, ContractDeleteEvent.class, 0, null);
            eventProcessor.addListener(this, ContractSerializeEvent.class);
            eventProcessor.addListener(this, ContractWrapEvent.class);
            eventProcessor.addListener(this, ObjectMoveEvent.class);
            for (final BGModule module : this.moduleCache.getModulesList()) {
                eventProcessor.addListener(new EventListener<ContractDeleteEvent>(){

                    @Override
                    public void notify(ContractDeleteEvent event, EventListenerContext ctx) throws BGException {
                        try {
                            ApplicationModule applicationModule = CommonKernelEventProcessor.this.moduleCache.getApplicationModule(module.getName());
                            if (applicationModule != null) {
                                applicationModule.moduleAction((ServerContext)ctx, module.getId(), (Event)event);
                            }
                        }
                        catch (Exception e) {
                            throw new BGException(e);
                        }
                    }
                }, ContractDeleteEvent.class, module.getId(), null);
            }
        }
    }

    @Override
    public void notify(LocalEvent event, EventListenerContext ctx) throws BGException {
        block16: {
            int contractId = event.getContractId();
            this.getLogger().info("Process event contractId:" + contractId + "; event:" + event.toString());
            ConnectionSet connectionSet = ctx.getConnectionSet();
            Connection con = connectionSet.getConnection();
            try {
                if (event.getModuleId() <= 0) {
                    ContractCloseEvent ccEvent;
                    Set<Object> moduleSet = new HashSet();
                    if (event instanceof ContractCreateEvent && ((ContractCreateEvent)event).isCheck()) {
                        ContractPattern contractPattern = ((ContractCreateEvent)event).getPattern();
                        List<String> moduleIdStrings = contractPattern.getModuleList();
                        moduleSet = new HashSet();
                        int size = moduleIdStrings.size();
                        for (int i = 0; i < size; ++i) {
                            int moduleId = Utils.parseInt(moduleIdStrings.get(i), 0);
                            if (moduleId <= 0) continue;
                            moduleSet.add(moduleId);
                        }
                    } else {
                        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(connectionSet, (Integer)contractId);
                        if (contractRuntime != null) {
                            moduleSet = contractRuntime.getModuleIds();
                        }
                    }
                    List<BGModule> moduleEventList = this.moduleCache.getModulesListProcessSorted(moduleSet);
                    if (event instanceof ContractCloseEvent && !(ccEvent = (ContractCloseEvent)event).isCheck()) {
                        try (ContractObjectDao contractObjectDao = new ContractObjectDao(con, 0);){
                            List<ContractObject> objectList = contractObjectDao.list(event.getContractId());
                            Date closeDate = ccEvent.getDate();
                            for (ContractObject contractObject : objectList) {
                                if (contractObject.getDateTo() != null) continue;
                                contractObject.setDateTo(closeDate);
                                contractObjectDao.update((Object)contractObject);
                            }
                        }
                    }
                    for (BGModule module : moduleEventList) {
                        ApplicationModule applicationModule;
                        if (module == null || (applicationModule = this.moduleCache.getApplicationModule(module.getName())) == null) continue;
                        applicationModule.moduleAction((ServerContext)ctx, module.getId(), (Event)event);
                    }
                    break block16;
                }
                this.getLogger().error("Not supported event!");
            }
            catch (Exception ex) {
                this.logError(ex);
                throw new BGException(ex);
            }
        }
    }
}

