/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.BGClient;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractSearchParam;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

public class BGClientSearchResultPopup
extends JPopupMenu {
    private String lastSearchText = "";
    private Color bgColor;
    private Color bgSelectColor;
    private ClientContext clientContext;
    private JPanel selectedPanel;
    private JPanel prefPanel;
    private boolean[] prefCheckBox = new boolean[5];
    private JPanel panelWithSearchResult = new JPanel(new GridBagLayout());
    ActionListener openContractActionListener = e -> BGClientBase.getFrame().getTabbedPane().addContractEditorTab(Utils.parseInt(e.getActionCommand()));
    MouseAdapter openContractButtonMouseAdapter = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            BGClientSearchResultPopup.this.selectPanel((JPanel)e.getComponent());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                BGClientSearchResultPopup.this.selectedPanel = (JPanel)e.getComponent();
                BGClientSearchResultPopup.this.openSelectedPanel();
            }
        }
    };

    public BGClientSearchResultPopup(ClientContext clientContext) {
        this.clientContext = clientContext;
        this.bgColor = new Color(UIManager.getDefaults().getColor("TextField.background").getRGB());
        this.bgSelectColor = new Color(UIManager.getDefaults().getColor("List.selectionBackground").getRGB());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                block3: {
                    block6: {
                        block4: {
                            block5: {
                                if (keyEvent.getKeyCode() != 38) break block4;
                                if (BGClientSearchResultPopup.this.selectedPanel != null) break block5;
                                if (BGClientSearchResultPopup.this.panelWithSearchResult.getComponentCount() <= 1) break block3;
                                BGClientSearchResultPopup.this.selectPanel((JPanel)BGClientSearchResultPopup.this.panelWithSearchResult.getComponents()[BGClientSearchResultPopup.this.panelWithSearchResult.getComponentCount() - 2]);
                                break block3;
                            }
                            if (BGClientSearchResultPopup.this.panelWithSearchResult.getComponentCount() <= 1) break block3;
                            for (int index = 0; index < BGClientSearchResultPopup.this.panelWithSearchResult.getComponentCount() - 1; ++index) {
                                JPanel testPanel = (JPanel)BGClientSearchResultPopup.this.panelWithSearchResult.getComponents()[index];
                                if (BGClientSearchResultPopup.this.selectedPanel != testPanel) continue;
                                BGClientSearchResultPopup.this.selectPanel((JPanel)BGClientSearchResultPopup.this.panelWithSearchResult.getComponents()[index > 0 ? index - 1 : BGClientSearchResultPopup.this.panelWithSearchResult.getComponentCount() - 2]);
                                break block3;
                            }
                            break block3;
                        }
                        if (keyEvent.getKeyCode() != 40) break block3;
                        if (BGClientSearchResultPopup.this.selectedPanel != null) break block6;
                        if (BGClientSearchResultPopup.this.panelWithSearchResult.getComponentCount() <= 1) break block3;
                        BGClientSearchResultPopup.this.selectPanel((JPanel)BGClientSearchResultPopup.this.panelWithSearchResult.getComponents()[0]);
                        break block3;
                    }
                    if (BGClientSearchResultPopup.this.panelWithSearchResult.getComponentCount() > 1) {
                        for (int index = 0; index < BGClientSearchResultPopup.this.panelWithSearchResult.getComponentCount() - 1; ++index) {
                            JPanel testPanel = (JPanel)BGClientSearchResultPopup.this.panelWithSearchResult.getComponents()[index];
                            if (BGClientSearchResultPopup.this.selectedPanel != testPanel) continue;
                            BGClientSearchResultPopup.this.selectPanel((JPanel)BGClientSearchResultPopup.this.panelWithSearchResult.getComponents()[index < BGClientSearchResultPopup.this.panelWithSearchResult.getComponentCount() - 2 ? index + 1 : 0]);
                            break;
                        }
                    }
                }
            }
        });
        Dimension dimension = BGClient.getFrame().getSize();
        JScrollPane scrollPane = new JScrollPane(this.panelWithSearchResult);
        scrollPane.setOpaque(false);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), new BGTitleBorder("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u043f\u043e\u0438\u0441\u043a\u0430")));
        this.setLayout(new BorderLayout());
        this.setBackground(this.bgColor);
        this.setPreferredSize(new Dimension(Math.max(dimension.width - 800, 800), dimension.height - 200));
        this.add("Center", scrollPane);
        this.add("South", this.getPrefPanel());
    }

    public void doSearch(String searchText) {
        if (searchText == null || searchText.isBlank() || this.lastSearchText.equals(searchText)) {
            return;
        }
        this.lastSearchText = searchText;
        this.doSearch();
    }

    public void doSearch() {
        try {
            ContractSearchParam searchParam = new ContractSearchParam().setContractId(0).setContractTitle(this.lastSearchText).setFaceType(-1).setShowSubContracts(this.prefCheckBox[3]).setShowClosed(!this.prefCheckBox[4]).setShowHidden(this.prefCheckBox[2]).setPage(new Page(1, 50)).setInAllLabels(false);
            this.setSearchResultToListPanel(this.clientContext.getPort(ContractService.class).searchContractList(searchParam).getList().stream().map(a -> new JSONObject().put("cid", a.getContractId()).put("contractTitle", (Object)a.getContractTitle()).put("contractComment", (Object)Utils.maskBlank(a.getContractComment(), ""))).toList());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    public void setSearchResultToListPanel(List<JSONObject> searchResult) {
        this.selectedPanel = null;
        this.panelWithSearchResult.setBackground(this.bgColor);
        this.panelWithSearchResult.removeAll();
        for (JSONObject contract : searchResult) {
            int contractId = contract.optInt("cid", -1);
            String contractTitle = contract.optString("contractTitle", "");
            if (contractId < 0 || Utils.isBlankString(contractTitle)) continue;
            String comment = contract.optString("contractComment", "");
            JPanel contractItemPanel = this.buildPanelByFindedContract(contractId, contractTitle, comment);
            this.panelWithSearchResult.add((Component)contractItemPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.panelWithSearchResult.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelWithSearchResult.revalidate();
        this.panelWithSearchResult.repaint();
    }

    private JPanel buildPanelByFindedContract(int contractId, String contractTitle, String comment) {
        JButton button = new JButton("\u043e\u0442\u043a\u0440\u044b\u0442\u044c");
        button.addActionListener(this.openContractActionListener);
        button.setActionCommand(String.valueOf(contractId));
        JPanel resultItemPanel = new JPanel(new GridBagLayout());
        resultItemPanel.setName(String.valueOf(contractId));
        resultItemPanel.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
        resultItemPanel.setOpaque(false);
        resultItemPanel.setPreferredSize(new Dimension(300, 40));
        resultItemPanel.setMaximumSize(new Dimension(300, 100));
        resultItemPanel.addMouseListener(this.openContractButtonMouseAdapter);
        resultItemPanel.add((Component)new ContractTitleLabel(contractTitle), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        resultItemPanel.add((Component)new ContractCommentLabel(comment), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        resultItemPanel.add((Component)button, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        return resultItemPanel;
    }

    private JPanel getPrefPanel() {
        if (this.prefPanel == null) {
            ActionListener actionListener = e -> {
                this.prefCheckBox[Utils.parseInt((String)e.getActionCommand())] = ((PrefCheckBox)e.getSource()).isSelected();
                this.doSearch();
            };
            String configurationString = ClientSetup.getInstance().get("dbinfo.contract.searchDefaultFilters", "");
            PrefCheckBox hidden = new PrefCheckBox("\u0423\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \u0441\u043a\u0440\u044b\u0442\u044b\u0435", "2", actionListener, configurationString);
            PrefCheckBox subContract = new PrefCheckBox("\u0423\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "3", actionListener, configurationString);
            PrefCheckBox closed = new PrefCheckBox("\u0423\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0435", "4", actionListener, configurationString);
            this.prefPanel = new JPanel(new GridBagLayout());
            this.prefPanel.setOpaque(false);
            this.prefPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5), new BGTitleBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0438\u0441\u043a\u0430")));
            this.prefPanel.add((Component)hidden, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            this.prefPanel.add((Component)subContract, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            this.prefPanel.add((Component)closed, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            this.prefPanel.add(Box.createGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.prefPanel;
    }

    private void selectPanel(JPanel newSelectedPanel) {
        if (this.selectedPanel != null) {
            this.selectedPanel.setOpaque(false);
            this.selectedPanel.repaint();
        }
        this.selectedPanel = newSelectedPanel;
        this.selectedPanel.setOpaque(true);
        this.selectedPanel.setBackground(this.bgSelectColor);
        this.selectedPanel.repaint();
    }

    public void openSelectedPanel() {
        if (this.selectedPanel != null) {
            BGClientBase.getFrame().getTabbedPane().addContractEditorTab(Utils.parseInt(this.selectedPanel.getName()));
            this.setVisible(false);
        }
    }

    public void clearSelectedPanel() {
        this.selectedPanel = null;
        this.setVisible(false);
    }

    static class ContractTitleLabel
    extends JLabel {
        public ContractTitleLabel(String text) {
            super(text);
            this.setFont(this.getFont().deriveFont(1, 16.0f));
        }
    }

    static class ContractCommentLabel
    extends JLabel {
        public ContractCommentLabel(String text) {
            super(text);
            this.setFont(this.getFont().deriveFont(2, 12.0f));
        }
    }

    class PrefCheckBox
    extends JCheckBox {
        public PrefCheckBox(String title, String actionCommand, ActionListener actionListener, String configurationString) {
            super(title);
            this.setOpaque(false);
            this.setActionCommand(actionCommand);
            this.setSelected(configurationString.contains(actionCommand));
            this.addActionListener(actionListener);
            BGClientSearchResultPopup.this.prefCheckBox[Utils.parseInt((String)actionCommand)] = this.isSelected();
        }
    }
}

