/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.logging;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LoggingPrintStream
extends PrintStream {
    protected static Logger _logger = LogManager.getLogger();
    protected Logger logger = _logger;
    private final PrintStream printStream;

    public LoggingPrintStream(PrintStream printStream) {
        super(printStream);
        this.printStream = printStream;
    }

    protected abstract void log(String var1);

    @Override
    public void print(String s) {
        this.log(s);
    }

    @Override
    public void println(String s) {
        this.log(s);
    }

    @Override
    public boolean checkError() {
        return this.printStream.checkError();
    }

    @Override
    public void close() {
        this.printStream.close();
    }

    public boolean equals(Object obj) {
        return this.printStream.equals(obj);
    }

    @Override
    public void flush() {
        this.printStream.flush();
    }

    @Override
    public PrintStream format(Locale l, String format, Object ... args) {
        return this.printStream.format(l, format, args);
    }

    @Override
    public PrintStream format(String format, Object ... args) {
        return this.printStream.format(format, args);
    }

    public int hashCode() {
        return this.printStream.hashCode();
    }

    @Override
    public void print(boolean b) {
        this.printStream.print(b);
    }

    @Override
    public void print(char c) {
        this.printStream.print(c);
    }

    @Override
    public void print(char[] s) {
        this.printStream.print(s);
    }

    @Override
    public void print(double d) {
        this.printStream.print(d);
    }

    @Override
    public void print(float f) {
        this.printStream.print(f);
    }

    @Override
    public void print(int i) {
        this.printStream.print(i);
    }

    @Override
    public void print(long l) {
        this.printStream.print(l);
    }

    @Override
    public void print(Object obj) {
        this.log(String.valueOf(obj));
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        return this.printStream.printf(l, format, args);
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        return this.printStream.printf(format, args);
    }

    @Override
    public void println() {
        this.log("");
    }

    @Override
    public void println(boolean x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(char x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(char[] x) {
        this.printStream.println(x);
    }

    @Override
    public void println(double x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(float x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(int x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(long x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(Object x) {
        this.log(String.valueOf(x));
    }

    public String toString() {
        return this.printStream.toString();
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.printStream.write(buf, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.printStream.write(b);
    }

    @Override
    public void write(int b) {
        this.printStream.write(b);
    }

    public static void assignToOutput() {
        Logger rootLogger = LogManager.getRootLogger();
        Map appenderMap = ((org.apache.logging.log4j.core.Logger)rootLogger).getAppenders();
        if (appenderMap != null && appenderMap.isEmpty()) {
            if (!(System.out instanceof LoggingPrintStream)) {
                System.setOut(new LoggingPrintStream(System.out){

                    @Override
                    protected synchronized void log(String x) {
                        try {
                            this.logger.info(x);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
            if (!(System.err instanceof LoggingPrintStream)) {
                System.setErr(new LoggingPrintStream(System.err){

                    @Override
                    protected synchronized void log(String x) {
                        try {
                            this.logger.error(x);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
        }
    }
}

