/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.recalculate;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.SessionRecalculateTarifficationManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.SessionRecalculateDayTarifficationManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.current.SessionRecalculateCurrentDayTarifficationManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.FindFirstAccountingEvent;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.InetCanCalculateEvent;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.InetRecalculateBaseEvent;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.InetRecalculateCurrentDayEvent;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.InetRecalculateCurrentMonthBeforeDayEvent;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.InetRecalculateDayInCurrentMonthEvent;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.TarrificationContinueEvent;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.TarrificationSuspendEvent;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.event.response.RecalculateResponseEvent;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.part.SessionRecalculateCurrentMonthPartTarifficationManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerThreadFactory;

public class InetRecalculateEventProcessor
implements EventListener<QueueEvent> {
    private final Accounting accounting;
    private final Setup setup;
    private volatile Map<Integer, Integer> changedContractsAndSubs = new HashMap<Integer, Integer>();
    private static Logger logger = LogManager.getLogger();

    public InetRecalculateEventProcessor(Accounting accounting) throws BGException {
        this.accounting = accounting;
        this.setup = accounting.setup;
        EventProcessor.getInstance().addListener((EventListener)this, InetRecalculateBaseEvent.class, accounting.moduleId, "applicationId=" + accounting.applicationId);
        EventProcessor.getInstance().addListener((EventListener)this, FindFirstAccountingEvent.class, accounting.moduleId, null);
        EventProcessor.getInstance().addListener((EventListener)this, InetCanCalculateEvent.class, accounting.moduleId, "applicationId=" + accounting.applicationId);
        EventProcessor.getInstance().addListener((EventListener)this, InetRecalculateCurrentDayEvent.class, accounting.moduleId, "applicationId=" + accounting.applicationId);
        EventProcessor.getInstance().addListener((EventListener)this, TarrificationContinueEvent.class, accounting.moduleId, "applicationId=" + accounting.applicationId);
        EventProcessor.getInstance().addListener((EventListener)this, TarrificationSuspendEvent.class, accounting.moduleId, "applicationId=" + accounting.applicationId);
        EventProcessor.getInstance().addListener((EventListener)this, InetRecalculateCurrentMonthBeforeDayEvent.class, accounting.moduleId, "applicationId=" + accounting.applicationId);
        EventProcessor.getInstance().addListener((EventListener)this, InetRecalculateDayInCurrentMonthEvent.class, accounting.moduleId, "applicationId=" + accounting.applicationId);
    }

    public void notify(QueueEvent e, EventListenerContext ctx) throws BGException {
        logger.info("catch event:" + e.getClass().getName());
        if (e instanceof FindFirstAccountingEvent) {
            logger.info("find first");
            ((FindFirstAccountingEvent)e).setApplicationId(this.accounting.applicationId);
        } else if (e instanceof InetCanCalculateEvent) {
            logger.info("can calculate");
            this.changedContractsAndSubs = new HashMap<Integer, Integer>();
        } else if (e instanceof InetRecalculateCurrentDayEvent) {
            logger.info("recalulate current day");
            Recalculator recalculator = new Recalculator((InetRecalculateCurrentDayEvent)e){

                @Override
                protected SessionRecalculateTarifficationManager getManager() throws BGException {
                    Integer day = this.event.getDay();
                    Calendar cal = TimeUtils.convertDateToCalendar((Date)this.event.getMonth());
                    cal.set(5, day);
                    Date dateFrom = cal.getTime();
                    Date dateTo = TimeUtils.getNextDay((Date)dateFrom);
                    Accounting accountingRecalculate = InetRecalculateEventProcessor.this.createAccounting(dateFrom, this.event.getCids());
                    logger.debug("creating SessionRecalculateCurrentDayTarifficationManager");
                    SessionRecalculateCurrentDayTarifficationManager manager = new SessionRecalculateCurrentDayTarifficationManager(accountingRecalculate, this.event.getIdDivisor(), this.event.getIdRemainder(), this.event.getCids(), dateFrom, dateTo, InetRecalculateEventProcessor.this.changedContractsAndSubs);
                    logger.debug("SessionRecalculateCurrentDayTarifficationManager created");
                    return manager;
                }
            };
            recalculator.recalculate();
        } else if (e instanceof TarrificationContinueEvent) {
            logger.info("start workers");
            this.accounting.startWorkers(false, true);
        } else if (e instanceof TarrificationSuspendEvent) {
            logger.info("stop workers");
            logger.debug("TarrificationSuspendEvent");
            this.accounting.stopWorkes(true);
        } else if (e instanceof InetRecalculateCurrentMonthBeforeDayEvent) {
            logger.info("recalculate current month before day");
            Recalculator recalculator = new Recalculator((InetRecalculateCurrentMonthBeforeDayEvent)e){

                @Override
                protected SessionRecalculateTarifficationManager getManager() throws BGException {
                    Integer day = this.event.getDay();
                    Date dateFrom = this.event.getMonth();
                    Calendar cal = TimeUtils.convertDateToCalendar((Date)this.event.getMonth());
                    cal.set(5, day);
                    Date dateTo = cal.getTime();
                    Accounting accountingRecalculate = InetRecalculateEventProcessor.this.createAccounting(dateFrom, this.event.getCids());
                    logger.debug("creating SessionRecalculateCurrentMonthPartTarifficationManager");
                    SessionRecalculateCurrentMonthPartTarifficationManager manager = new SessionRecalculateCurrentMonthPartTarifficationManager(accountingRecalculate, this.event.getIdDivisor(), this.event.getIdRemainder(), this.event.getCids(), dateFrom, dateTo);
                    logger.debug("SessionRecalculateCurrentMonthPartTarifficationManager created");
                    return manager;
                }

                @Override
                protected void doAfterAll() {
                    InetRecalculateEventProcessor.this.changedContractsAndSubs = ((SessionRecalculateCurrentMonthPartTarifficationManager)this.manager).getChangedContractsAndSubs();
                }
            };
            recalculator.recalculate();
        } else if (e instanceof InetRecalculateDayInCurrentMonthEvent) {
            logger.info("recalculate current day in current month");
            Recalculator recalculator = new Recalculator((InetRecalculateDayInCurrentMonthEvent)e){

                @Override
                protected SessionRecalculateTarifficationManager getManager() throws BGException {
                    Integer day = this.event.getDay();
                    Calendar cal = TimeUtils.convertDateToCalendar((Date)this.event.getMonth());
                    cal.set(5, day);
                    Date dateFrom = cal.getTime();
                    cal.add(5, 1);
                    Date dateTo = cal.getTime();
                    Accounting accountingRecalculate = InetRecalculateEventProcessor.this.createAccounting(dateFrom, this.event.getCids());
                    logger.debug("creating SessionRecalculateCurrentMonthPartTarifficationManager");
                    SessionRecalculateCurrentMonthPartTarifficationManager manager = new SessionRecalculateCurrentMonthPartTarifficationManager(accountingRecalculate, this.event.getIdDivisor(), this.event.getIdRemainder(), this.event.getCids(), dateFrom, dateTo);
                    logger.debug("created SessionRecalculateCurrentMonthPartTarifficationManager");
                    return manager;
                }
            };
            recalculator.recalculate();
        } else if (e instanceof InetRecalculateBaseEvent) {
            logger.info("recalculate past");
            Recalculator recalculator = new Recalculator((InetRecalculateBaseEvent)e){

                @Override
                protected SessionRecalculateTarifficationManager getManager() throws BGException {
                    SessionRecalculateDayTarifficationManager manager;
                    Integer day = this.event.getDay();
                    if (day == null) {
                        Date dateFrom = this.event.getMonth();
                        Date dateTo = TimeUtils.getNextMonth((Date)dateFrom);
                        Accounting accountingRecalculate = InetRecalculateEventProcessor.this.createAccounting(dateFrom, this.event.getCids());
                        manager = new SessionRecalculateTarifficationManager(accountingRecalculate, this.event.getIdDivisor(), this.event.getIdRemainder(), this.event.getCids(), dateFrom, dateTo);
                        logger.debug("created SessionRecalculateTarifficationManager");
                    } else {
                        Calendar cal = TimeUtils.convertDateToCalendar((Date)this.event.getMonth());
                        cal.set(5, day);
                        Date dateFrom = cal.getTime();
                        Date dateTo = TimeUtils.getNextDay((Date)dateFrom);
                        Accounting accountingRecalculate = InetRecalculateEventProcessor.this.createAccounting(dateFrom, this.event.getCids());
                        manager = new SessionRecalculateDayTarifficationManager(accountingRecalculate, this.event.getIdDivisor(), this.event.getIdRemainder(), this.event.getCids(), dateFrom, dateTo);
                        logger.debug("SessionRecalculateDayTarifficationManager created");
                    }
                    return manager;
                }
            };
            recalculator.recalculate();
        }
    }

    public Accounting createAccounting(Date dateFrom, Set<Integer> cids) throws BGException {
        try {
            BGNestedContext.push((String)"recalculate");
            logger.debug("creating accounting");
            Accounting accountingRecalculate = new Accounting(this.setup, -10, false, false, dateFrom, null, cids);
            logger.debug("accounting created");
            accountingRecalculate.start();
            Accounting accounting = accountingRecalculate;
            return accounting;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        finally {
            BGNestedContext.pop();
        }
    }

    class Recalculator {
        protected InetRecalculateBaseEvent event;
        protected SessionRecalculateTarifficationManager manager;

        public Recalculator(InetRecalculateBaseEvent event) {
            this.event = event;
        }

        public void recalculate() throws BGException {
            if (this.event.getApplicationId() != InetRecalculateEventProcessor.this.accounting.applicationId) {
                logger.warn("skipping ApplicationId = " + this.event.getApplicationId());
                return;
            }
            ExecutorService executorServiceForTasks = Executors.newFixedThreadPool(1, (ThreadFactory)new WorkerThreadFactory(null, null, null));
            executorServiceForTasks.submit(new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public Object call() throws Exception {
                    block10: {
                        ThreadContextFactory<InetTariffWorkerContext> threadContextFactory = new ThreadContextFactory<InetTariffWorkerContext>(){

                            public InetTariffWorkerContext newThreadContext() {
                                return new InetTariffWorkerContext(InetRecalculateEventProcessor.this.accounting.setup, InetRecalculateEventProcessor.this.accounting.moduleId);
                            }
                        };
                        logger.debug("getting manager");
                        Recalculator.this.manager = Recalculator.this.getManager();
                        ExecutorService service = Executors.newSingleThreadExecutor((ThreadFactory)new WorkerThreadFactory(null, null, (ThreadContextFactory)threadContextFactory));
                        Future<?> future = service.submit(Recalculator.this.manager);
                        logger.debug("waiting for task");
                        future.get();
                        logger.debug("task end");
                        service.shutdown();
                        Recalculator.this.doAfterAll();
                        try {
                            boolean result = Recalculator.this.manager != null ? Recalculator.this.manager.isCalculateOk() : false;
                            EventProcessor.getInstance().request((QueueEvent)new RecalculateResponseEvent(InetRecalculateEventProcessor.this.accounting.moduleId, InetRecalculateEventProcessor.this.accounting.applicationId, Recalculator.this.event.getRequestIndex(), result));
                            logger.debug("RecalculateResponseEvent sended ");
                        }
                        catch (BGException ex) {
                            logger.error("", (Throwable)ex);
                        }
                        break block10;
                        catch (Exception ex) {
                            try {
                                logger.error("", (Throwable)ex);
                            }
                            catch (Throwable throwable) {
                                try {
                                    boolean result = Recalculator.this.manager != null ? Recalculator.this.manager.isCalculateOk() : false;
                                    EventProcessor.getInstance().request((QueueEvent)new RecalculateResponseEvent(InetRecalculateEventProcessor.this.accounting.moduleId, InetRecalculateEventProcessor.this.accounting.applicationId, Recalculator.this.event.getRequestIndex(), result));
                                    logger.debug("RecalculateResponseEvent sended ");
                                }
                                catch (BGException ex2) {
                                    logger.error("", (Throwable)ex2);
                                }
                                throw throwable;
                            }
                            try {
                                boolean result = Recalculator.this.manager != null ? Recalculator.this.manager.isCalculateOk() : false;
                                EventProcessor.getInstance().request((QueueEvent)new RecalculateResponseEvent(InetRecalculateEventProcessor.this.accounting.moduleId, InetRecalculateEventProcessor.this.accounting.applicationId, Recalculator.this.event.getRequestIndex(), result));
                                logger.debug("RecalculateResponseEvent sended ");
                            }
                            catch (BGException ex3) {
                                logger.error("", (Throwable)ex3);
                            }
                        }
                    }
                    return null;
                }
            });
        }

        protected void doAfterAll() {
        }

        protected SessionRecalculateTarifficationManager getManager() throws BGException {
            return null;
        }
    }
}

