/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.client.tariff;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.model.IdTitle;

public class DestTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"home");
    private BGComboBox<IdTitle> combo;
    private JLabel view = new JLabel(icon, 2);
    private Directory dir;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> nodes) {
        super.init(id, mtree, type, tree, config, parent, nodes);
        this.dir = this.getDirManager().getDirectory("destinations");
    }

    protected JPanel getEditorPanel() throws Exception {
        JPanel propsPanel = new JPanel();
        this.combo = this.dir != null ? new BGComboBox(this.dir.getItems()) : new BGComboBox();
        propsPanel.add((Component)this.combo);
        return propsPanel;
    }

    public Component getView() throws Exception {
        StringBuffer str = new StringBuffer("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435: ");
        str.append(this.getDestTitle());
        this.view.setText(str.toString());
        return this.view;
    }

    protected void loadData() {
        String data = this.getData();
        for (int i = 0; i < this.combo.getItemCount(); ++i) {
            IdTitle di = (IdTitle)this.combo.getItemAt(i);
            if (di == null || !String.valueOf(di.getId()).equals(data.trim())) continue;
            this.combo.setSelectedIndex(i);
            break;
        }
    }

    protected void serializeData() {
        IdTitle di = (IdTitle)this.combo.getSelectedItem();
        if (di != null) {
            super.setData(String.valueOf(di.getId()));
            this.saveData();
        }
    }

    public String getDestTitle() throws Exception {
        String title;
        String result = "";
        String data = this.getData();
        if (this.dir != null && data != null && data.length() > 0 && (title = this.dir.getValue(Integer.parseInt(data))) != null) {
            result = title;
        }
        return result;
    }

    public int compareTo(Object o) {
        int result = -1;
        if (o instanceof DestTariffTreeNode) {
            try {
                result = this.getDestTitle().compareTo(((DestTariffTreeNode)((Object)o)).getDestTitle());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public void serializeToXML(Element el) throws Exception {
        super.serializeToXML(el);
        el.setAttribute("title", this.getDestTitle());
        this.serializeChildsToXML(el);
    }

    public void loadFromXML(Element el) throws Exception {
        String title = el.getAttribute("title");
        if (title.length() > 0) {
            int destCode = this.dir.getCode(title);
            if (destCode < 0) {
                destCode = this.dir.addValue(title);
            }
            this.setData(String.valueOf(destCode));
            this.saveData();
        }
        this.loadChildsFromXML(el);
    }
}

