/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.runtime;

import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractModuleManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractFilters;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.contract.status.server.ContractStatusList2;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedTopicEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusModifiedEvent;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.option.server.event.ContractTariffOptionChangedEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.ref.ConcurrentReferenceHashMap;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.systems.inventory.product.common.event.ProductPeriodModifiedEvent;
import ru.bitel.oss.systems.inventory.product.server.ProductPeriodRuntimeList;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductPeriodDao;

public class ContractRuntimeMap
extends BGLogger
implements EventListener<Event> {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private final Date initialDate;
    private final boolean realtime;
    private final ConcurrentReferenceHashMap<Integer, ContractRuntime> contractRuntimeMap = new ConcurrentReferenceHashMap(512, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.SOFT);
    private long fetchedGroups = 0L;

    public static ContractRuntimeMap getInstance() {
        return InstanceHolder.instance;
    }

    public ContractRuntimeMap(Date initialDate) throws BGException {
        this(initialDate, true, true);
    }

    public ContractRuntimeMap(Date initialDate, boolean realtime, boolean preload) throws BGException {
        this.initialDate = initialDate;
        this.realtime = realtime;
        this.getLogger().debug("Initializing contractRuntimeMap");
        if (preload) {
            this.getLogger().debug("Load contract data in contractRuntimeMap");
            this.preload();
        }
        this.init();
        this.getLogger().debug("Initialization contractRuntimeMap completed");
    }

    private void init() throws BGException {
        if (this.realtime) {
            this.writeLock(this.writeLock);
            try {
                EventProcessor ep = EventProcessor.getInstance();
                ep.addListener(this, ContractTariffOptionChangedEvent.class);
                ep.addListener(this, ProductPeriodModifiedEvent.class);
                ep.addListener(this, ContractStatusChangedTopicEvent.class);
                ep.addListener(this, ContractStatusModifiedEvent.class);
                ep.addListener(this, ContractModifiedEvent.class);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public ContractRuntime getContractRuntime(ConnectionSet connectionSet, Integer contractId) throws BGException {
        return this.getContractRuntime(connectionSet.getConnection(), contractId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContractRuntime getContractRuntime(Connection con, Integer contractId) throws BGException {
        ContractRuntime runtime = this.contractRuntimeMap.get(contractId);
        if (runtime == null) {
            ContractRuntime newRuntime;
            block14: {
                try {
                    ContractManager contractManager = new ContractManager(con);
                    ContractLabelManager labelManager = new ContractLabelManager(con);
                    if (this.initialDate != null) {
                        try (ProductPeriodDao productPeriodDao = new ProductPeriodDao(con, 0);){
                            ContractStatusDao contractStatusDao = new ContractStatusDao(con);
                            ContractTariffOptionDao contractTariffOptionDao = new ContractTariffOptionDao(con);
                            newRuntime = this.newRuntime(contractManager, labelManager, contractStatusDao, contractTariffOptionDao, productPeriodDao, contractId);
                            break block14;
                        }
                    }
                    newRuntime = this.newRuntime(contractManager, labelManager, null, null, null, contractId);
                }
                catch (Exception ex) {
                    throw new BGException(ex);
                }
            }
            if (newRuntime != null) {
                try {
                    this.readLock.lock();
                    runtime = this.contractRuntimeMap.putIfAbsent(contractId, newRuntime);
                    if (runtime == null) {
                        runtime = newRuntime;
                    }
                }
                finally {
                    this.readLock.unlock();
                }
            }
        }
        return runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContractRuntime getContractRuntime(ContractManager contractManager, ContractLabelManager labelManager, ContractStatusDao contractStatusDao, ContractTariffOptionDao contractTariffOptionDao, ProductPeriodDao productPeriodDao, Integer contractId) throws Exception {
        ContractRuntime newRuntime;
        ContractRuntime runtime = this.contractRuntimeMap.get(contractId);
        if (runtime == null && (newRuntime = this.newRuntime(contractManager, labelManager, contractStatusDao, contractTariffOptionDao, productPeriodDao, contractId)) != null) {
            try {
                this.readLock.lock();
                runtime = this.contractRuntimeMap.putIfAbsent(contractId, newRuntime);
                if (runtime == null) {
                    runtime = newRuntime;
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        return runtime;
    }

    private ContractRuntime newRuntime(ContractManager contractManager, ContractLabelManager labelManager, ContractStatusDao contractStatusDao, ContractTariffOptionDao contractTariffOptionDao, ProductPeriodDao productPeriodDao, int contractId) throws Exception {
        bitel.billing.server.contract.bean.Contract contract = contractManager.getContractById(contractId);
        if (contract == null) {
            this.getLogger().warn("Contract ID#{} not found", (Object)contractId);
            return null;
        }
        ContractRuntime runtime = new ContractRuntime(contractId);
        int superContractId = contract.getSuperId();
        if (superContractId > 0) {
            if (contract.getSubMode() == 0 && superContractId != contractId) {
                ContractRuntime superContractRuntime = this.getContractRuntime(contractManager, labelManager, contractStatusDao, contractTariffOptionDao, productPeriodDao, superContractId);
                runtime.setSuperContract(superContractRuntime);
            }
        } else if (contract.isSuper()) {
            runtime.setDependSubContractIds(contract.getDependSubList());
            runtime.setSuper(true);
        }
        runtime.contractTitle = contract.getTitle();
        runtime.domainId = contract.getDomainId();
        runtime.contractGroups = contract.getGroups();
        runtime.contractMode = contract.getBalanceMode();
        runtime.contractStatus = contract.getStatus();
        if (labelManager != null) {
            runtime.contractLabelIds = labelManager.getContractLabelIds(contractId);
        }
        if (this.initialDate != null) {
            List<ContractStatus> statusList = contractStatusDao.getStatusList(contractId, this.initialDate);
            runtime.load(statusList, contractTariffOptionDao, productPeriodDao, this.initialDate, new GregorianCalendar());
        }
        return runtime;
    }

    @Override
    public void notify(Event e, EventListenerContext ctx) throws Exception {
        this.writeLock.lock();
        try {
            this.getLogger().info("Taked event: {}", (Object)e);
            if (e instanceof ContractStatusChangedTopicEvent) {
                this.onContractStatusChanged((ContractStatusChangedTopicEvent)e);
            } else if (e instanceof ContractStatusModifiedEvent) {
                this.onContractStatusModified((ContractStatusModifiedEvent)e);
            } else if (e instanceof ContractTariffOptionChangedEvent) {
                this.onContractTariffOptionChanged((ContractTariffOptionChangedEvent)e);
            } else if (e instanceof ProductPeriodModifiedEvent) {
                this.onProductPeriodModified((ProductPeriodModifiedEvent)e);
            } else if (e instanceof ContractModifiedEvent) {
                this.onContractModified((ContractModifiedEvent)e, ctx);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void onContractModified(ContractModifiedEvent contractModifiedEvent, EventListenerContext ctx) throws Exception {
        this.updateContractRuntime(ctx, contractModifiedEvent.getContractId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContractRuntime(ServerContext ctx, int contractId) throws Exception {
        ContractRuntime runtime;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Updating runtime for contract ID#{}", (Object)contractId);
        }
        if ((runtime = this.contractRuntimeMap.get(contractId)) == null) {
            return;
        }
        Connection con = ctx.getConnection();
        runtime.internalLock();
        try {
            bitel.billing.server.contract.bean.Contract contract = null;
            List<Object> contractLabelIds = new ArrayList();
            try {
                contract = new ContractManager(con).getContractById(contractId);
                contractLabelIds = new ContractLabelManager(con).getContractLabelIds(contractId);
            }
            catch (Exception ex) {
                this.getLogger().error(ex.getMessage());
            }
            if (contract == null) {
                this.getLogger().error("Contract ID#{} is absent in DB", (Object)contractId);
                return;
            }
            runtime.contractTitle = contract.getTitle();
            runtime.domainId = contract.getDomainId();
            runtime.contractGroups = contract.getGroups();
            runtime.contractMode = contract.getBalanceMode();
            runtime.contractStatus = contract.getStatus();
            runtime.moduleIds = null;
            runtime.contractLabelIds = contractLabelIds;
            int superContractId = contract.getSuperId();
            if (superContractId > 0) {
                if (superContractId != runtime.contractId) {
                    if (contract.getSubMode() == 0) {
                        ContractRuntime superContractRuntime = this.getContractRuntime(ctx.getConnectionSet(), (Integer)superContractId);
                        runtime.setSuperContract(superContractRuntime);
                    } else {
                        runtime.independentSuperContractId = superContractId;
                    }
                }
                runtime.setDependSubContractIds(null);
            } else if (contract.isSuper()) {
                runtime.setDependSubContractIds(contract.getDependSubList());
                runtime.setSuper(true);
            } else {
                runtime.setDependSubContractIds(null);
            }
        }
        finally {
            runtime.internalUnlock();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Updating completed");
            }
        }
    }

    private void onContractStatusChanged(ContractStatusChangedTopicEvent e) {
        ContractRuntime runtime = this.contractRuntimeMap.get(e.getContractId());
        if (runtime == null) {
            return;
        }
        ContractStatus contractStatus = e.getStatus();
        runtime.contractStatus = contractStatus.getStatus();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("New contract status {}", (Object)contractStatus.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onContractStatusModified(ContractStatusModifiedEvent e) {
        ContractRuntime runtime = this.contractRuntimeMap.get(e.getContractId());
        if (runtime == null) {
            return;
        }
        ContractStatus oldContractStatus = e.getOldContractStatus();
        ContractStatus newContractStatus = e.getNewContractStatus();
        GregorianCalendar utilCalendar = new GregorianCalendar();
        runtime.internalLock();
        try {
            ContractStatusList2 contractStatuses;
            long millisTo;
            long millisFrom;
            if (oldContractStatus != null) {
                millisFrom = TimeUtils.convertDateToMillisFrom(utilCalendar, oldContractStatus.getDateFrom());
                millisTo = TimeUtils.convertDateToMillisTo(utilCalendar, oldContractStatus.getDateTo());
                contractStatuses = runtime.contractStatuses;
                if (contractStatuses != null) {
                    runtime.contractStatuses = contractStatuses.remove(oldContractStatus.getId(), millisFrom, millisTo, oldContractStatus.getStatus());
                }
            }
            if (newContractStatus != null) {
                millisFrom = TimeUtils.convertDateToMillisFrom(utilCalendar, newContractStatus.getDateFrom());
                millisTo = TimeUtils.convertDateToMillisTo(utilCalendar, newContractStatus.getDateTo());
                contractStatuses = runtime.contractStatuses;
                if (contractStatuses != null) {
                    runtime.contractStatuses = contractStatuses.update(newContractStatus.getId(), millisFrom, millisTo, newContractStatus.getStatus());
                }
            }
        }
        finally {
            runtime.internalUnlock();
        }
        if (this.getLogger().isDebugEnabled() && runtime.contractStatuses != null) {
            this.getLogger().debug("New contract status list:\n" + runtime.contractStatuses);
        }
    }

    private void onContractTariffOptionChanged(ContractTariffOptionChangedEvent e) {
        switch (e.getState()) {
            case 1: {
                this.onTariffOptionActivated(e, false);
                break;
            }
            case 2: {
                this.onTariffOptionDeactivated(e);
                break;
            }
            case 3: {
                this.onTariffOptionActivated(e, true);
                break;
            }
            case 4: {
                this.onTariffOptionDeleted(e);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTariffOptionActivated(ContractTariffOptionChangedEvent e, boolean reactivated) {
        ContractRuntime runtime = this.contractRuntimeMap.get(e.getContractId());
        if (runtime != null) {
            long timeTo;
            ContractTariffOption tariffOption = e.getContractTariffOption();
            Date from = tariffOption.getTimeFrom();
            Date to = tariffOption.getTimeTo();
            long timeFrom = from != null ? from.getTime() : 0L;
            long l = timeTo = to != null ? to.getTime() - 1L : 0L;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Tariff option was activated: " + tariffOption.getOptionId() + " " + TimeUtils.format(new Date(timeFrom), "dd.MM.yyyy HH:mm:ss.S") + " - " + TimeUtils.format(new Date(timeTo), "dd.MM.yyyy HH:mm:ss.S"));
            }
            runtime.internalLock();
            try {
                ContractTariffOptionList tariffOptions = runtime.tariffOptions;
                if (tariffOptions != null) {
                    runtime.tariffOptions = reactivated ? tariffOptions.update(tariffOption.getOptionId(), tariffOption.getId(), timeFrom, timeTo) : tariffOptions.add(tariffOption.getOptionId(), tariffOption.getId(), timeFrom, timeTo);
                }
            }
            finally {
                runtime.internalUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTariffOptionDeactivated(ContractTariffOptionChangedEvent e) {
        ContractRuntime runtime = this.contractRuntimeMap.get(e.getContractId());
        if (runtime != null) {
            ContractTariffOption tariffOption = e.getContractTariffOption();
            Date from = tariffOption.getTimeFrom();
            Date to = tariffOption.getTimeTo();
            long timeFrom = from != null ? from.getTime() : 0L;
            long timeTo = to != null ? to.getTime() - 1L : 0L;
            runtime.internalLock();
            try {
                ContractTariffOptionList tariffOptions = runtime.tariffOptions;
                if (tariffOptions != null) {
                    runtime.tariffOptions = tariffOptions.update(tariffOption.getOptionId(), tariffOption.getId(), timeFrom, timeTo);
                }
            }
            finally {
                runtime.internalUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTariffOptionDeleted(ContractTariffOptionChangedEvent e) {
        ContractRuntime runtime = this.contractRuntimeMap.get(e.getContractId());
        if (runtime != null) {
            ContractTariffOption tariffOption = e.getContractTariffOption();
            Date from = tariffOption.getTimeFrom();
            Date to = tariffOption.getTimeTo();
            long timeFrom = from != null ? from.getTime() : 0L;
            long timeTo = to != null ? to.getTime() - 1L : 0L;
            runtime.internalLock();
            try {
                ContractTariffOptionList tariffOptions = runtime.tariffOptions;
                if (tariffOptions != null) {
                    runtime.tariffOptions = tariffOptions.remove(tariffOption.getOptionId(), tariffOption.getId(), timeFrom, timeTo);
                }
            }
            finally {
                runtime.internalUnlock();
            }
        }
    }

    private void onProductPeriodModified(ProductPeriodModifiedEvent e) {
        ContractRuntime runtime = this.contractRuntimeMap.get(e.getContractId());
        if (runtime == null) {
            return;
        }
        runtime.internalLock();
        try {
            runtime.updateProductPeriods(e);
        }
        finally {
            runtime.internalUnlock();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void prefetch(ConnectionSet connectionSet, long groups) throws BGException {
        this.getLogger().info("Starting prefetching ContractRuntimeMap.");
        long time = System.currentTimeMillis();
        if (groups != 0L || this.fetchedGroups != 0L) {
            if (groups == 0L) {
                groups = -1L;
            }
            if ((groups ^= this.fetchedGroups) == 0L) {
                return;
            }
        }
        ContractDao contractDao = new ContractDao(connectionSet.getConnection(), 0);
        ContractFilters contractFilters = ContractFilters.builder().setFaceType(-1).setGroupMask(groups).setSubContracts(true).build();
        List<Contract> contractList = contractDao.list(contractFilters, null, "scid", null);
        for (Contract contract : contractList) {
            int contractId = contract.getId();
            if (this.contractRuntimeMap.containsKey(contractId)) continue;
            ContractRuntime newRuntime = new ContractRuntime(contract.getId());
            int superContractId = contract.getSuperCid();
            if (superContractId > 0) {
                if (contract.getBalanceSubMode() == 0 && superContractId != contractId) {
                    ContractRuntime superContractRuntime = this.contractRuntimeMap.get(superContractId);
                    if (superContractRuntime == null) continue;
                    newRuntime.setSuperContract(superContractRuntime);
                }
            } else if (contract.isSuper()) {
                newRuntime.setDependSubContractIds(contract.getDependSubList());
            }
            newRuntime.contractTitle = contract.getTitle();
            newRuntime.domainId = contract.getDomainId();
            newRuntime.contractGroups = contract.getGroups();
            newRuntime.contractMode = contract.getBalanceMode();
            newRuntime.contractStatus = contract.getStatus();
            newRuntime.moduleIds = null;
            this.readLock.lock();
            try {
                this.contractRuntimeMap.putIfAbsent(contractId, newRuntime);
            }
            finally {
                this.readLock.unlock();
            }
        }
        contractList.clear();
        contractDao.close();
        ContractModuleManager contractModuleManager = new ContractModuleManager(connectionSet.getConnection());
        for (Map.Entry e : contractModuleManager.getContractModuleMap().entrySet()) {
            ContractRuntime runtime = this.contractRuntimeMap.get(e.getKey());
            if (runtime == null || runtime.isModuleIdsFetched()) continue;
            runtime.setModuleIds((Set)e.getValue());
        }
        this.fetchedGroups = groups == 0L ? -1L : (this.fetchedGroups |= groups);
        this.getLogger().info("Prefetching ContractRuntimeMap done for " + (System.currentTimeMillis() - time) + " ms.");
    }

    private void preload() {
        long start;
        int contractCount;
        block27: {
            this.getLogger().info("Start loadContracts");
            contractCount = 0;
            start = System.currentTimeMillis();
            try (Connection con = Setup.getSetup().getDBConnection();
                 ContractDao contractDao = new ContractDao(con, 0);){
                ContractFilters contractFilters = ContractFilters.builder().setFaceType(-1).setSubContracts(true).build();
                this.getLogger().debug("Load contract list");
                HashMap<Integer, Contract> contractSuperMap = new HashMap<Integer, Contract>();
                for (Contract contract : contractDao.list(contractFilters, null, "scid", null)) {
                    int contractId = contract.getId();
                    ContractRuntime runtime = new ContractRuntime(contractId);
                    runtime.contractTitle = contract.getTitle();
                    runtime.domainId = contract.getDomainId();
                    runtime.contractGroups = contract.getGroups();
                    runtime.contractMode = contract.getBalanceMode();
                    runtime.contractStatus = contract.getStatus();
                    runtime.moduleIds = null;
                    runtime.setPeriodDataStart(this.initialDate.getTime());
                    if (contract.isSuper()) {
                        runtime.setSuper(true);
                        runtime.setDependSubContractIds(contract.getDependSubList());
                    }
                    this.contractRuntimeMap.put(contractId, runtime);
                    if (contract.getSuperCid() > 0) {
                        contractSuperMap.put(contractId, contract);
                    }
                    ++contractCount;
                }
                for (Map.Entry entry : contractSuperMap.entrySet()) {
                    ContractRuntime superContractRuntime;
                    ContractRuntime runtime = this.contractRuntimeMap.get(entry.getKey());
                    if (runtime == null) continue;
                    int superContractId = ((Contract)entry.getValue()).getSuperCid();
                    if (((Contract)entry.getValue()).getBalanceSubMode() != 0 || superContractId == (Integer)entry.getKey() || (superContractRuntime = this.contractRuntimeMap.get(superContractId)) == null) continue;
                    runtime.setSuperContract(superContractRuntime);
                }
                this.getLogger().debug("Set contract moduleIds");
                for (Map.Entry entry : new ContractModuleManager(con).getContractModuleMap().entrySet()) {
                    ContractRuntime runtime = this.contractRuntimeMap.get(entry.getKey());
                    if (runtime == null || runtime.isModuleIdsFetched()) continue;
                    runtime.moduleIds = (Set)entry.getValue();
                }
                this.getLogger().debug("Set contract labelIds");
                for (Map.Entry entry : new ContractLabelManager(con).getContractListWithLabels().entrySet()) {
                    ContractRuntime runtime = this.contractRuntimeMap.get(entry.getKey());
                    if (runtime == null) continue;
                    runtime.contractLabelIds = (List)entry.getValue();
                }
                if (this.initialDate == null) break block27;
                this.getLogger().debug("Set contract statusList");
                for (Map.Entry entry : new ContractStatusDao(con).getContractStatusListMap(this.initialDate).entrySet()) {
                    ContractRuntime runtime = this.contractRuntimeMap.get(entry.getKey());
                    if (runtime == null) continue;
                    runtime.contractStatuses = new ContractStatusList2((List)entry.getValue(), TimeUtils.convertDateToCalendar(this.initialDate));
                }
                this.getLogger().debug("Set contract tariffOptions");
                for (Map.Entry entry : new ContractTariffOptionDao(con).getContractRealtimeTariffOptionListMap(this.initialDate).entrySet()) {
                    ContractRuntime runtime = this.contractRuntimeMap.get(entry.getKey());
                    if (runtime == null) continue;
                    runtime.tariffOptions = (ContractTariffOptionList)entry.getValue();
                }
                this.getLogger().debug("Set contract productPeriods");
                try (ProductPeriodDao productPeriodDao = new ProductPeriodDao(con, 0);){
                    for (Map.Entry e : productPeriodDao.contractProductPeriodListMap(this.initialDate).entrySet()) {
                        ContractRuntime runtime = this.contractRuntimeMap.get(e.getKey());
                        if (runtime == null) continue;
                        List fullProductPeriodList = (List)e.getValue();
                        runtime.contractProductPeriodItemList = ProductPeriodRuntimeList.newInstance(fullProductPeriodList.stream().filter(a -> a.getAccountId() == 0).toList());
                        runtime.productPeriodItemList = ProductPeriodRuntimeList.newInstance((List)fullProductPeriodList);
                    }
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        long time = (System.currentTimeMillis() - start) / 1000L;
        time = time == 0L ? 1L : time;
        this.getLogger().info("Finish loadContracts (load contract: {}; time: {}s; speed: {}c/s )", new Object[]{contractCount, time, new BigDecimal((long)contractCount / time).setScale(2).toPlainString()});
    }

    private void writeLock(ReentrantReadWriteLock.WriteLock writeLock) throws BGException {
        if (this.lock.getReadHoldCount() > 0) {
            this.getLogger().error("lock.getReadHoldCount() > 0");
            if (this.lock.getWriteHoldCount() == 0) {
                this.getLogger().error("lock.getWriteHoldCount() == 0");
                throw new BGException("lock.getReadHoldCount() > 0");
            }
        }
        writeLock.lock();
    }

    static class InstanceHolder {
        static final ContractRuntimeMap instance;

        InstanceHolder() {
        }

        static {
            ContractRuntimeMap instance0 = null;
            try {
                instance0 = new ContractRuntimeMap(null, true, false);
            }
            catch (BGException ex) {
                BGLogger.error(ex.getMessage(), ex);
            }
            instance = instance0;
        }
    }
}

