/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Calendar;
import ru.bitel.bgbilling.modules.phone.server.BaseLoader;
import ru.bitel.bgbilling.modules.phone.server.LogRecord;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class DBLoadOut
extends bitel.billing.server.load.DBLoadOut {
    private ByteArrayOutputStream bos;
    private Writer tmpWriter;
    private String lineStart;
    private PreparedStatement psLoad;
    private PreparedStatement psLock;
    private PreparedStatement psUnLock;
    private boolean first = true;

    public DBLoadOut(BaseLoader loader) {
        super((bitel.billing.server.load.BaseLoader)loader);
    }

    public void prepareInsert(Connection con) {
        try {
            if (!ServerUtils.tableExists((Connection)con, (String)this.tableName)) {
                String query = "CREATE TABLE IF NOT EXISTS " + this.tableName + " ( id int not null AUTO_INCREMENT PRIMARY KEY,hh int not null,source_id int not null,session_start datetime not null,session_time int not null,from_number varchar(25) not null, from_number_164 varchar(25) not null, to_number varchar(25) not null, to_number_164 varchar(25) not null, from_port varchar(50) not null, to_port varchar(50) not null, cat int not null, connect_time int not null, call_client_cost DECIMAL(10,2) NOT NULL,call_oper_cost DECIMAL(10,2) NOT NULL,key dt ( hh, source_id, session_start ) )";
                ServerUtils.checkAndCreatePeriodicTableName((Connection)con, (String)this.tableName, (String)query);
            } else {
                Statement st = con.createStatement();
                if (!ServerUtils.columnExist((Connection)con, (String)this.tableName, (String)"call_client_cost")) {
                    st.executeUpdate("ALTER TABLE " + this.tableName + " ADD call_client_cost DECIMAL(10,2) NOT NULL");
                }
                if (!ServerUtils.columnExist((Connection)con, (String)this.tableName, (String)"call_oper_cost")) {
                    st.executeUpdate("ALTER TABLE " + this.tableName + " ADD call_oper_cost DECIMAL(10,2) NOT NULL");
                }
                st.close();
            }
            this.bos = new ByteArrayOutputStream(50000000);
            this.tmpWriter = new OutputStreamWriter(this.bos);
            this.lineStart = "0\t" + this.loader.getHour().get(11) + "\t" + this.loader.getSource().getId() + "\t";
            this.psLoad = con.prepareStatement("INSERT INTO " + this.tableName + " VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");
            this.psLock = con.prepareStatement("LOCK TABLES " + this.tableName + " WRITE");
            this.psUnLock = con.prepareStatement("UNLOCK TABLES");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addRecord(Object value) {
        LogRecord record = (LogRecord)value;
        try {
            if (!this.first) {
                this.tmpWriter.write("\n");
            }
            this.first = false;
            this.tmpWriter.write(this.lineStart);
            this.tmpWriter.write(TimeUtils.format((Calendar)record.sessionStart, (String)"yyyy-MM-dd HH:mm:ss"));
            this.tmpWriter.write("\t");
            this.tmpWriter.write(String.valueOf(record.sessionTime));
            this.tmpWriter.write("\t");
            this.tmpWriter.write(record.fromNumber);
            this.tmpWriter.write("\t");
            this.tmpWriter.write(record.fromNumber164);
            this.tmpWriter.write("\t");
            this.tmpWriter.write(record.toNumber);
            this.tmpWriter.write("\t");
            this.tmpWriter.write(record.toNumber164);
            this.tmpWriter.write("\t");
            this.tmpWriter.write(record.fromPort);
            this.tmpWriter.write("\t");
            this.tmpWriter.write(record.toPort);
            this.tmpWriter.write("\t");
            this.tmpWriter.write(String.valueOf(record.category));
            this.tmpWriter.write("\t");
            this.tmpWriter.write(String.valueOf(record.connectTime));
            this.tmpWriter.write("\t");
            this.tmpWriter.write(record.callClientCost.toPlainString());
            this.tmpWriter.write("\t");
            this.tmpWriter.write(record.callOperCost.toPlainString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finishLoad() {
        try {
            this.tmpWriter.close();
            this.psLock.executeUpdate();
            for (String cdr : new String(this.bos.toByteArray(), "UTF-8").split("\n")) {
                int index = 1;
                for (String field : cdr.split("\t")) {
                    this.psLoad.setString(index++, field);
                }
                if (index != 16) continue;
                this.psLoad.executeUpdate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.psUnLock.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.finishLoad();
    }
}

