/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.modules.hd.server.bean.CPHost;
import ru.bitel.bgbilling.modules.hd.server.bean.ContractPackageManager;

public class CPHostManager {
    private Connection con;
    private String tableName;
    private int mid;

    public CPHostManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
        this.tableName = "hd_cp_host_" + mid;
    }

    public List<CPHost> getHostList(int contractServiceId) {
        ArrayList<CPHost> result = new ArrayList<CPHost>();
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE cpid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractServiceId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CPHost host = new CPHost();
                host.setHost(rs.getString("host"));
                host.setAddr(rs.getString("addr"));
                result.add(host);
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void deleteHost(int cpid) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE cpid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cpid);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateHost(int cpid, List<CPHost> hostList) {
        this.deleteHost(cpid);
        try {
            String query = "INSERT INTO " + this.tableName + " (cpid, host, addr) VALUES (?, ?, ?)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cpid);
            for (CPHost host : hostList) {
                ps.setString(2, host.getHost());
                ps.setString(3, host.getAddr());
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int checkHost(String packages, int cpid, String host) {
        int result = 0;
        try {
            String contractPackageTable = ContractPackageManager.getTableName(this.mid);
            String query = "SELECT cp.cid FROM " + this.tableName + " AS host INNER JOIN " + contractPackageTable + " AS cp ON host.cpid=cp.id AND cp.status=? WHERE pid IN ( " + packages + ") AND host.cpid!=? LIMIT 1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, 1);
            ps.setInt(2, cpid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

