/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class VoiceIpSessionUtils {
    private Connection con;
    private int mid = -1;

    public VoiceIpSessionUtils(Connection con, int moduleId) {
        this.con = con;
        this.mid = moduleId;
    }

    public void setContractAccountFromSession(Date time, int contractId, int serviceId) {
        String logSessionTableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)time, (int)this.mid);
        if (ServerUtils.tableExists((Connection)this.con, (String)logSessionTableName)) {
            String query = "SELECT SUM(session_cost) FROM " + logSessionTableName + " WHERE cid=? AND sid=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);
                 BalanceUtils bu = new BalanceUtils(this.con);){
                ps.setInt(1, contractId);
                ps.setInt(2, serviceId);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        bu.setContractAccount(contractId, TimeUtils.convertDateToLocalDate((Date)time), serviceId, rs.getBigDecimal(1));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setContractAccountFromSession(Date time, int contractId) {
        String logSessionTableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)time, (int)this.mid);
        if (ServerUtils.tableExists((Connection)this.con, (String)logSessionTableName)) {
            String query = "SELECT sid, SUM(session_cost) FROM " + logSessionTableName + " WHERE cid=? GROUP BY sid";
            try (PreparedStatement ps = this.con.prepareStatement(query);
                 BalanceUtils bu = new BalanceUtils(this.con);){
                ps.setInt(1, contractId);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        bu.setContractAccount(contractId, TimeUtils.convertDateToLocalDate((Date)time), rs.getInt(1), rs.getBigDecimal(2));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

