/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.BGToggleButton;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.BGMaskTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class CalendarPanelWithTime
extends JPanel {
    private static final String[] weekDays = new String[]{"\u041f\u043d.", "\u0412\u0442.", "\u0421\u0440.", "\u0427\u0442.", "\u041f\u0442.", "\u0421\u0431.", "\u0412\u0441."};
    private static final Font fontBold = new Font("Dialog", 1, 12);
    private static final Font fontPlain = new Font("Dialog", 0, 10);
    private static final Font fontLabel = new Font("Dialog", 0, 9);
    private Calendar calendarOld = null;
    private Calendar calendarCurrent = null;
    private Calendar firstDate = null;
    private String typeButtonPress = null;
    private BGToggleButton calendarButton = new BGToggleButton();
    private BGToggleButton timeButton = new BGToggleButton();
    private JButton buttonClear = new JButton();
    private JPanel panelDays = new JPanel(new GridLayout(7, 7));
    private JPanel panelMonth = new JPanel(new GridLayout(7, 2));
    private JPanel panelYear = new JPanel(new GridLayout(7, 1));
    private JPanel calendarAndTimePanel = null;
    private JPanel fieldPanel = null;
    private JPanel hourPanel = new JPanel(new GridLayout(6, 4));
    private JPanel minutPanel = new JPanel(new GridLayout(6, 2));
    private JLabel labelDate = new JLabel();
    private CardLayout cardLayout = new CardLayout();
    private CardLayout fildCardLayout = new CardLayout();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private DateField dateField = new DateField();
    private TimeField timeField = new TimeField();
    private KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 27: {
                    CalendarPanelWithTime.this.buttonClear_actionPerformed();
                }
            }
        }
    };

    public CalendarPanelWithTime() {
        try {
            this.jbInit();
            this.buildButtons();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.updateDate();
    }

    private void jbInit() throws Exception {
        final JButton ok = new JButton();
        this.setLayout(new GridBagLayout());
        JPanel calendarPanel = new JPanel(new GridBagLayout());
        this.labelDate.setFont(fontBold);
        this.labelDate.setText(" ");
        calendarPanel.setOpaque(false);
        this.panelDays.setOpaque(false);
        calendarPanel.add((Component)this.labelDate, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        calendarPanel.add((Component)this.panelYear, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        calendarPanel.add((Component)this.panelMonth, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        calendarPanel.add((Component)this.panelDays, new GridBagConstraints(2, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel timePanel = new JPanel(new GridBagLayout());
        JPanel p1 = new JPanel(new GridBagLayout());
        p1.setBorder(new BGTitleBorder("\u041c\u0438\u043d\u0443\u0442\u044b:"));
        JPanel p2 = new JPanel(new GridBagLayout());
        p2.setBorder(new BGTitleBorder("\u0427\u0430\u0441\u044b:"));
        p2.add((Component)this.hourPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        p1.add((Component)this.minutPanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        timePanel.add((Component)p2, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        timePanel.add((Component)p1, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 15, 0, 0), 0, 0));
        JPanel filterPanel = new JPanel(new GridBagLayout());
        this.buttonGroup.add(this.calendarButton);
        this.buttonGroup.add(this.timeButton);
        this.calendarButton.setSelected(true);
        this.calendarButton.setIcon(ClientUtils.getIcon("calend"));
        this.calendarButton.setPreferredSize(new Dimension(30, 30));
        this.timeButton.setIcon(ClientUtils.getIcon("time.png"));
        this.timeButton.setPreferredSize(new Dimension(30, 30));
        filterPanel.add((Component)this.calendarButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)this.timeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.fieldPanel = new JPanel(this.fildCardLayout);
        this.fieldPanel.add((Component)this.dateField, "date");
        this.fieldPanel.add((Component)this.timeField, "time");
        filterPanel.add((Component)this.fieldPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)ok, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.buttonClear, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.calendarAndTimePanel = new JPanel(this.cardLayout);
        this.calendarAndTimePanel.add((Component)calendarPanel, "calendar");
        this.calendarAndTimePanel.add((Component)timePanel, "time");
        this.add((Component)filterPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.calendarAndTimePanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.cardLayout.show(this.calendarAndTimePanel, "calendar");
        this.fildCardLayout.show(this.fieldPanel, "date");
        this.calendarButton.addActionListener(e -> {
            this.cardLayout.show(this.calendarAndTimePanel, "calendar");
            this.fildCardLayout.show(this.fieldPanel, "date");
        });
        this.timeButton.addActionListener(e -> {
            this.cardLayout.show(this.calendarAndTimePanel, "time");
            this.fildCardLayout.show(this.fieldPanel, "time");
        });
        this.buttonClear.setFont(fontBold);
        this.buttonClear.setMargin(new Insets(2, 2, 2, 2));
        this.buttonClear.setText(" X ");
        this.buttonClear.addActionListener(e -> this.buttonClear_actionPerformed());
        ok.setFont(fontBold);
        ok.setMargin(new Insets(2, 2, 2, 2));
        ok.setText("OK");
        KeyAdapter l = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        ok.doClick();
                        break;
                    }
                    case 27: {
                        ok.doClick();
                    }
                }
            }
        };
        this.dateField.addKeyListener(l);
        this.dateField.addKeyListener(this.keyListener);
        timePanel.addKeyListener(l);
        timePanel.addKeyListener(this.keyListener);
        ok.addKeyListener(l);
        ok.addKeyListener(this.keyListener);
        ok.addActionListener(e -> {
            String date = this.dateField.getText();
            String time = this.timeField.getText();
            if (date != null) {
                this.typeButtonPress = "ok";
                this.calendarCurrent = (Calendar)this.firstDate.clone();
                this.calendarCurrent.setTime(TimeUtils.convertStringToDate(date + " " + time, "dd.MM.yyyy HH:mm"));
                this.updateDate();
                this.firePropertyChange("updateCalendar", true, false);
            }
        });
    }

    public void setCalendarView() {
        this.calendarButton.setSelected(true);
        this.cardLayout.show(this.calendarAndTimePanel, "calendar");
        this.fildCardLayout.show(this.fieldPanel, "date");
    }

    private void buildButtons() {
        JButton button;
        int i;
        JLabel label = null;
        Insets insets = new Insets(0, 0, 0, 0);
        Dimension dimension = new Dimension(26, 20);
        ActionListener dbal = e -> this.dayClick(e);
        ActionListener mbal = e -> this.monthClick(e);
        ActionListener ybal = e -> this.yearClick(e);
        ActionListener hbal = e -> this.hourClick(e);
        ActionListener minbal = e -> this.minuteClick(e);
        for (i = 0; i < 7; ++i) {
            label = new JLabel(weekDays[i]);
            label.setFont(fontLabel);
            label.setHorizontalAlignment(0);
            this.panelDays.add((Component)label, null);
        }
        for (i = 0; i < 42; ++i) {
            button = new JButton("  ");
            button.setActionCommand(String.valueOf(i));
            button.setFont(fontPlain);
            button.setMargin(insets);
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            this.panelDays.add((Component)button, null);
            button.addActionListener(dbal);
        }
        for (i = 0; i < 2; ++i) {
            label = new JLabel(" ");
            label.setFont(fontLabel);
            this.panelMonth.add((Component)label, null);
        }
        for (i = 0; i < 6; ++i) {
            button = new JButton("  ");
            button.setActionCommand(String.valueOf(i));
            button.setText("0" + String.valueOf(i + 1));
            button.setFont(fontPlain);
            button.setMargin(insets);
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            this.panelMonth.add((Component)button, null);
            button.addActionListener(mbal);
            button = new JButton("  ");
            button.setActionCommand(String.valueOf(i + 6));
            if (i + 7 < 10) {
                button.setText("0" + String.valueOf(i + 7));
            } else {
                button.setText(String.valueOf(i + 7));
            }
            button.setFont(fontPlain);
            button.setMargin(insets);
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            this.panelMonth.add((Component)button, null);
            button.addActionListener(mbal);
        }
        label = new JLabel(" ");
        label.setFont(fontLabel);
        this.panelYear.add((Component)label, null);
        dimension = new Dimension(40, 20);
        for (i = 0; i < 6; ++i) {
            button = new JButton("  ");
            button.setFont(fontPlain);
            button.setMargin(insets);
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            this.panelYear.add((Component)button, null);
            button.addActionListener(ybal);
        }
        ((JButton)this.panelYear.getComponent(5)).setFont(fontBold);
        for (i = 0; i < 6; ++i) {
            button = new JButton("  ");
            button.setActionCommand(String.valueOf(i * 5));
            if (i * 5 < 10) {
                button.setText("0" + String.valueOf(i * 5));
            } else {
                button.setText(String.valueOf(i * 5));
            }
            button.setFont(fontPlain);
            button.setMargin(insets);
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            this.minutPanel.add((Component)button, null);
            button.addActionListener(minbal);
            button = new JButton("  ");
            button.setActionCommand(String.valueOf(i * 5 + 30));
            button.setText(String.valueOf(i * 5 + 30));
            button.setFont(fontPlain);
            button.setMargin(insets);
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            this.minutPanel.add((Component)button, null);
            button.addActionListener(minbal);
        }
        for (i = 0; i < 6; ++i) {
            button = new JButton(" ");
            button.setActionCommand(String.valueOf(i));
            button.setText("0" + String.valueOf(i));
            button.setFont(fontPlain);
            button.setMargin(insets);
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            this.hourPanel.add((Component)button, null);
            button.addActionListener(hbal);
            button = new JButton(" ");
            button.setActionCommand(String.valueOf(i + 6));
            if (i + 6 < 10) {
                button.setText("0" + String.valueOf(i + 6));
            } else {
                button.setText(String.valueOf(i + 6));
            }
            button.setFont(fontPlain);
            button.setMargin(insets);
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            this.hourPanel.add((Component)button, null);
            button.addActionListener(hbal);
            button = new JButton(" ");
            button.setActionCommand(String.valueOf(i + 12));
            button.setText(String.valueOf(i + 12));
            button.setFont(fontPlain);
            button.setMargin(insets);
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            this.hourPanel.add((Component)button, null);
            button.addActionListener(hbal);
            button = new JButton(" ");
            button.setActionCommand(String.valueOf(i + 18));
            button.setText(String.valueOf(i + 18));
            button.setFont(fontPlain);
            button.setMargin(insets);
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            this.hourPanel.add((Component)button, null);
            button.addActionListener(hbal);
        }
    }

    private void updateDate() {
        JButton button;
        int i;
        int month;
        if (this.calendarCurrent == null) {
            return;
        }
        int year = this.calendarCurrent.get(1);
        GregorianCalendar calendar = new GregorianCalendar(year, month = this.calendarCurrent.get(2), 1);
        int DAY_OF_WEEK = calendar.get(7);
        if (DAY_OF_WEEK == 1) {
            ((Calendar)calendar).add(5, -7);
        } else {
            ((Calendar)calendar).add(5, 1 - DAY_OF_WEEK);
        }
        this.firstDate = (Calendar)((Calendar)calendar).clone();
        for (int i2 = 1; i2 < this.panelYear.getComponentCount(); ++i2) {
            JButton button2 = (JButton)this.panelYear.getComponent(i2);
            button2.setActionCommand(String.valueOf(year - 5 + i2));
            button2.setText(String.valueOf(year - 5 + i2));
        }
        String monthString = String.valueOf(month);
        for (i = 2; i < this.panelMonth.getComponentCount(); ++i) {
            button = (JButton)this.panelMonth.getComponent(i);
            if (monthString.equals(button.getActionCommand())) {
                button.setFont(fontBold);
                continue;
            }
            button.setFont(fontPlain);
        }
        for (i = 7; i < this.panelDays.getComponentCount(); ++i) {
            ((Calendar)calendar).add(5, 1);
            button = (JButton)this.panelDays.getComponent(i);
            button.setText("" + calendar.get(5));
            if (calendar.get(2) == month) {
                button.setFont(fontBold);
                button.setForeground(Color.black);
                continue;
            }
            button.setFont(fontPlain);
            button.setForeground(Color.darkGray);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.calendarCurrent.get(5));
        buf.append(' ');
        buf.append(TimeUtils.monthNames[month]);
        buf.append(' ');
        buf.append(year);
        this.labelDate.setText(buf.toString());
        SimpleDateFormat f = new SimpleDateFormat("dd.MM.yyyy");
        this.dateField.setText(f.format(this.calendarCurrent.getTime()));
        f = new SimpleDateFormat("HH:mm");
        this.timeField.setText(f.format(this.calendarCurrent.getTime()));
        this.firePropertyChange("updateTitle", "", buf.toString());
    }

    private void dayClick(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        this.calendarCurrent = (Calendar)this.firstDate.clone();
        this.typeButtonPress = "day";
        this.calendarCurrent.add(5, Utils.parseInt(actionCommand, 0) + 1);
        this.updateDate();
        this.firePropertyChange("updateCalendar", true, false);
    }

    private void monthClick(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        this.calendarCurrent.set(2, Utils.parseInt(actionCommand, 0));
        this.updateDate();
    }

    private void yearClick(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        this.calendarCurrent.set(1, Utils.parseInt(actionCommand, 2000));
        this.updateDate();
    }

    private void hourClick(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        this.calendarCurrent.set(11, Utils.parseInt(actionCommand, 0));
        this.updateDate();
    }

    private void minuteClick(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        this.calendarCurrent.set(12, Utils.parseInt(actionCommand, 0));
        this.updateDate();
    }

    public void setCalendar(Calendar calendar) {
        this.calendarOld = calendar;
        this.calendarCurrent = calendar == null ? new GregorianCalendar() : (Calendar)calendar.clone();
        this.calendarCurrent.clear(14);
        this.calendarCurrent.clear(13);
        this.calendarCurrent.clear(12);
        this.calendarCurrent.clear(11);
        this.calendarCurrent.clear(0);
        this.updateDate();
    }

    public Calendar getCalendar() {
        return this.calendarCurrent;
    }

    public Calendar getOldCalendar() {
        return this.calendarOld;
    }

    private void buttonClear_actionPerformed() {
        this.typeButtonPress = "x";
        this.calendarCurrent = null;
        this.labelDate.setText(" ");
        this.firePropertyChange("updateCalendar", true, false);
    }

    public void setVisibleLabelDate(boolean value) {
        this.labelDate.setVisible(value);
    }

    public BGMaskTextField getDateField() {
        return this.dateField;
    }

    public String getTypeButtonPress() {
        return this.typeButtonPress;
    }

    private class DateField
    extends BGMaskTextField {
        DateField() {
            super("  .  .    ", ".", new BGMaskTextField.IntegerValidator(1L, 31L, 2), new BGMaskTextField.IntegerValidator(1L, 12L, 2), new BGMaskTextField.IntegerValidator());
            this.setHorizontalAlignment(0);
        }
    }

    private class TimeField
    extends BGMaskTextField {
        TimeField() {
            super("  :   ", ":", new BGMaskTextField.IntegerValidator(0L, 23L, 2), new BGMaskTextField.IntegerValidator(0L, 59L, 2));
            this.setHorizontalAlignment(0);
        }
    }
}

