/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.common.event.access.om;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.tv.access.TvAccess;
import ru.bitel.bgbilling.apps.tv.access.om.AbstractOrderEvent;
import ru.bitel.bgbilling.apps.tv.access.om.AccountOrderEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountSpecRuntime;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

@EventType(autoAcknowledge=false, timeToLive=691200000L)
@XmlRootElement
public class OmTvAccountOptionsModifyEvent
extends QueueEvent {
    private static final transient Logger logger = LogManager.getLogger();
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final int tvAccountId;
    @XmlAttribute
    private final Set<Integer> optionIds;

    protected OmTvAccountOptionsModifyEvent() {
        this.deviceId = -1;
        this.tvAccountId = -1;
        this.optionIds = null;
    }

    public OmTvAccountOptionsModifyEvent(int moduleId, int contractId, int userId, int deviceId, int tvAccountId, Set<Integer> optionSet) {
        super(moduleId, contractId, userId);
        this.deviceId = deviceId;
        this.tvAccountId = tvAccountId;
        this.optionIds = optionSet;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("deviceId", this.deviceId);
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getTvAccountId() {
        return this.tvAccountId;
    }

    public Set<Integer> getOptions() {
        return this.optionIds;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; deviceId: ");
        sb.append(this.deviceId);
        sb.append("; tvAccountId: ");
        sb.append(this.tvAccountId);
        sb.append("; optionIds: ");
        sb.append(Utils.toString(this.optionIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountOrderEvent toOmEvent(TvAccess access, ConnectionSet connectionSet, Date now) throws BGException {
        TvAccountRuntime tvAccountRuntime = access.tvAccountRuntimeMap.get(Integer.valueOf(this.tvAccountId));
        if (tvAccountRuntime == null) {
            logger.error("TvAccount not found with id=" + this.tvAccountId);
            return null;
        }
        TvAccount tvAccount = tvAccountRuntime.getTvAccount();
        Set<Integer> newOptionSet = this.getOptions();
        Set<Integer> oldOptionSet = tvAccount.getDeviceOptionIds();
        if (tvAccount.getParentId() > 0) {
            logger.error("TvAccount is child " + this.tvAccountId);
            return null;
        }
        if (oldOptionSet != null && newOptionSet != null && CollectionUtils.isEqualCollection(oldOptionSet, newOptionSet)) {
            logger.debug("TvAccount deviceOptions already " + newOptionSet);
            return null;
        }
        tvAccountRuntime.lock();
        try {
            AccountOrderEvent result;
            Set<Integer> newDeviceOptionIds;
            List childrenAccounts = AbstractOrderEvent.getTvAccountChildren((TvAccountRuntimeMap)access.tvAccountRuntimeMap, (int)tvAccount.getId(), (long)now.getTime());
            tvAccount.setChildren(childrenAccounts);
            short oldState = tvAccount.getDeviceState();
            Set<Integer> oldDeviceOptionIds = tvAccount.getDeviceOptionIds();
            if (oldDeviceOptionIds == null) {
                oldDeviceOptionIds = Collections.emptySet();
            }
            Set<Integer> set = newDeviceOptionIds = this.optionIds != null ? this.optionIds : oldDeviceOptionIds;
            if (oldDeviceOptionIds.equals(newDeviceOptionIds)) {
                AccountOrderEvent accountOrderEvent = null;
                return accountOrderEvent;
            }
            AccountOrderEvent accountOrderEvent = result = new AccountOrderEvent(access, (Event)this, this.deviceId, tvAccountRuntime, 5, this.tvAccountId, ((TvAccountSpecRuntime)tvAccountRuntime.tvAccountSpecRef.get()).tvAccountSpec, tvAccount, tvAccount, oldState, oldState, oldDeviceOptionIds, newDeviceOptionIds, AccessCode.AUTHORIZATION_SUCCEEDED.getCode());
            return accountOrderEvent;
        }
        finally {
            tvAccountRuntime.unlock();
        }
    }
}

