/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.CalendarPanelNoDay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.LookAndFeelUtils;

public class BGCalendarButtonNoDay
extends JToggleButton
implements PropertyChangeListener,
PopupMenuListener {
    private Calendar oldDateCalendar;
    private int columns = 0;
    private int columnWidth = 0;
    private Calendar calendar;
    private DateFormat df = new SimpleDateFormat("MM.yyyy");
    private static Popup popup;

    public BGCalendarButtonNoDay() {
        try {
            this.setMargin(new Insets(2, 5, 2, 5));
            this.setColumns(7);
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    public void jbInit() {
        this.setActionCommand("popup");
        this.addActionListener(e -> this.setPopupVisible(true));
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if ("updateCalendar".equals(propertyName)) {
            this.setPopupVisible(false);
            this.setCalendar(popup.getCalendar() == null ? null : (Calendar)popup.getCalendar().clone());
            this.firePropertyChange("updateCalendar", this.oldDateCalendar, this.calendar);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.getModel().setSelected(false);
        this.getModel().setPressed(false);
        BGCalendarButtonNoDay.popup.calendarPanel.removePropertyChangeListener(this);
        popup.removePopupMenuListener(this);
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        int oldVal = this.columns;
        if (columns != oldVal) {
            this.columns = columns;
            this.invalidate();
        }
    }

    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth('m');
        }
        return this.columnWidth;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.columns != 0) {
            Insets insets = this.getInsets();
            size.width = this.columns * this.getColumnWidth() + insets.left + insets.right;
        }
        size.height = LookAndFeelUtils.BUTTON_HEIGHT.get();
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setPopupVisible(boolean visible) {
        if (visible) {
            Calendar c;
            Calendar calendar = c = this.calendar != null ? this.calendar : new GregorianCalendar();
            if (popup.getCalendar() == null || !BGCalendarButtonNoDay.dateEqual(c, popup.getCalendar())) {
                popup.setCalendar(c);
            }
            BGCalendarButtonNoDay.popup.calendarPanel.addPropertyChangeListener(this);
            popup.addPopupMenuListener(this);
            popup.show(this, 0, this.getHeight() + 1);
            Component comp = BGCalendarButtonNoDay.popup.calendarPanel.getDateField().getComponent(1);
            if (comp != null) {
                comp.requestFocus();
            }
        } else {
            popup.setVisible(false);
        }
    }

    public void setCalendar(Calendar calendar) {
        Calendar newCalendar = calendar;
        if (newCalendar != null) {
            newCalendar = (Calendar)newCalendar.clone();
            newCalendar.set(5, 1);
        }
        this.oldDateCalendar = this.calendar == null ? null : (Calendar)this.calendar.clone();
        this.setOnlyCalendar(newCalendar);
    }

    @Override
    public void setText(String text) {
        this.setCalendar(TimeUtils.convertStringToCalendar(text));
    }

    private void setOnlyCalendar(Calendar calendar) {
        this.calendar = calendar;
        if (calendar != null) {
            super.setText(this.df.format(calendar.getTime()));
        } else {
            super.setText("");
        }
    }

    public void undoCalendar() {
        this.setOnlyCalendar(this.oldDateCalendar);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public Date getDate() {
        return this.calendar != null ? this.calendar.getTime() : null;
    }

    @Override
    public String getText() {
        return this.calendar != null ? this.df.format(this.calendar.getTime()) : "";
    }

    private static boolean dateEqual(Calendar date1, Calendar date2) {
        return date1.get(6) == date2.get(6) && date1.get(1) == date2.get(1) && date1.get(0) == date2.get(0);
    }

    static {
        Popup cp = null;
        try {
            cp = new Popup();
        }
        catch (Throwable ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        popup = cp;
        UIManager.addPropertyChangeListener(e -> {
            if ("lookAndFeel".equals(e.getPropertyName())) {
                SwingUtilities.updateComponentTreeUI(popup);
            }
        });
    }

    private static class Popup
    extends JPopupMenu {
        private CalendarPanelNoDay calendarPanel = new CalendarPanelNoDay();

        public Popup() {
            try {
                this.calendarPanel.setVisibleLabelDate(false);
                this.calendarPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                this.setLayout(new BorderLayout());
                this.add("Center", this.calendarPanel);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }

        public Calendar getCalendar() {
            return this.calendarPanel.getCalendar();
        }

        public void setCalendar(Calendar calendar) {
            this.calendarPanel.setCalendar(calendar);
        }
    }
}

