/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.oper.mtt;

import java.io.OutputStream;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JasperReport;
import ru.bitel.bgbilling.modules.phone.server.bean.oper.Operator;
import ru.bitel.bgbilling.modules.phone.server.bean.oper.Report;
import ru.bitel.bgbilling.modules.reports.server.bean.BGReportTemplate;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public abstract class MTTReport
extends Report {
    public MTTReport(Operator operator, Date month, int id) {
        super(operator, month, id);
    }

    public abstract String getForm();

    @Override
    public String getFileName() {
        Preferences setup = this.oper.getOperatorSetup();
        StringBuilder sb = new StringBuilder();
        sb.append(setup.get("code", "XXXXXXXXXX"));
        sb.append(TimeUtils.format((Date)this.month, (String)"yyyyMM"));
        sb.append(this.getForm());
        sb.append(setup.get("location_abc", "CCC"));
        sb.append("00");
        sb.append(".xls");
        return sb.toString();
    }

    @Override
    public int getType() {
        return 3;
    }

    protected void sendReport(Connection con, String templatePath, OutputStream out) {
        this.sendReport(con, templatePath, out, new HashMap<String, Object>());
    }

    protected void sendReport(Connection con, String templatePath, OutputStream out, Map<String, Object> params) {
        try {
            JasperReport report = this.getJasperReport(templatePath);
            params.put("oper", this.oper);
            params.put("operSetup", this.oper.getOperatorSetup());
            params.put("month", this.month);
            BGReportTemplate.fillReportToXlsStream((JasperReport)report, (BGReportFilter)new BGReportFilter(params, 0), (Connection)con, null, (OutputStream)out);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

