/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeNamespaceResolver
implements NamespaceContext {
    private static final String DEFAULT_NS = "DEFAULT";
    private Map<String, String> prefixMap = new HashMap<String, String>();
    private Map<String, String> namespaceMap = new HashMap<String, String>();

    public NodeNamespaceResolver(Document document) {
        this.process(document.getDocumentElement(), false, true);
    }

    public NodeNamespaceResolver(Node node) {
        this.process(node, false, false);
    }

    public NodeNamespaceResolver(Node node, boolean attributesOnly) {
        this.process(node, attributesOnly, false);
    }

    private void process(Node node, boolean attributesOnly, boolean down) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                this.processAttribute((Attr)attribute);
            }
        }
        if (attributesOnly) {
            return;
        }
        if (down) {
            NodeList childs = node.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node child = childs.item(i);
                if (child.getNodeType() != 1) continue;
                this.process(child, false, true);
            }
        } else {
            Node parentNode = node.getParentNode();
            if (parentNode != null) {
                this.process(parentNode, false, false);
            }
        }
    }

    private void processAttribute(Attr attribute) {
        if (attribute.getNamespaceURI() != null && attribute.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
            if (attribute.getNodeName().equals("xmlns")) {
                this.put(DEFAULT_NS, attribute.getNodeValue());
            } else {
                this.put(attribute.getLocalName(), attribute.getNodeValue());
            }
        }
    }

    private void put(String prefix, String uri) {
        this.prefixMap.put(prefix, uri);
        this.namespaceMap.put(uri, prefix);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null || prefix.equals("")) {
            return this.prefixMap.get(DEFAULT_NS);
        }
        return this.prefixMap.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.namespaceMap.get(namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return null;
    }

    public int hashCode() {
        return this.prefixMap.hashCode();
    }

    public boolean equals(Object obj) {
        return this.prefixMap.equals(((NodeNamespaceResolver)obj).prefixMap);
    }
}

