/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn.detail;

import bitel.billing.server.netflow.ipn.detail.RowSelector;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowSelector;
import ru.bitel.bgbilling.modules.ipn.server.bean.DetailCreateTask;
import ru.bitel.common.TimeUtils;

public class IPNRowSelector
implements RowSelector {
    private DetailCreateTask task;
    private boolean isAnyIface;
    private Set<Integer> ifaceSet;
    private long fromAddr;
    private long toAddr;

    public IPNRowSelector(DetailCreateTask task) {
        this.task = task;
        this.fromAddr = task.getIpnFromAddr();
        this.toAddr = task.getIpnToAddr();
        this.isAnyIface = task.getIpnIfaceSet().contains(-1);
        this.ifaceSet = task.getIpnIfaceSet();
    }

    public FlowSelector.Result test(long hour, Data flow) {
        int inputIface = flow.getInputInterface();
        int outputIface = flow.getOutputInterface();
        long srcAddress = flow.getSrcAddress();
        long dstAddress = flow.getDstAddress();
        if ((this.isAnyIface || this.ifaceSet.contains(inputIface)) && this.fromAddr <= srcAddress && srcAddress <= this.toAddr) {
            return RESULT_OK_OUT;
        }
        if ((this.isAnyIface || this.ifaceSet.contains(outputIface)) && this.fromAddr <= dstAddress && dstAddress <= this.toAddr) {
            return RESULT_OK_IN;
        }
        return RESULT_ERROR;
    }

    @Override
    public List<Calendar> getLogHours() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        if (this.task.isMonthPeriod()) {
            Calendar hour = (Calendar)this.task.getSessionStart().clone();
            Calendar sessionEnd = this.task.getSessionEnd();
            hour.set(11, hour.getActualMinimum(11));
            sessionEnd.set(11, sessionEnd.getActualMaximum(11));
            while (TimeUtils.hourDelta((Calendar)hour, (Calendar)sessionEnd) >= 0) {
                result.add(hour);
                hour = (Calendar)hour.clone();
                hour.add(11, 1);
            }
        } else {
            result.add(this.task.getIpnHour());
        }
        return result;
    }

    @Override
    public String getFileName() {
        StringBuilder fileName = new StringBuilder();
        fileName.append("detail");
        fileName.append("_");
        fileName.append(IPUtils.convertLongIpToString((long)this.task.getIpnFromAddr()));
        fileName.append("-");
        fileName.append(IPUtils.convertLongIpToString((long)this.task.getIpnToAddr()));
        return fileName.toString();
    }
}

