/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.servlet;

import bitel.billing.server.Action;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.XMLUtils;

@WebServlet(name="cardDealerExecuter", urlPatterns={"/dealer"})
public class DealerExecuter
extends CommonExecutor {
    public void init() {
        this.setup = Setup.getSetup();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block10: {
            Connection con;
            block9: {
                PrintWriter out = null;
                con = null;
                try {
                    DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                    dFactory.setNamespaceAware(true);
                    DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
                    Document doc = docBuilder.newDocument();
                    Element rootNode = doc.createElement("data");
                    rootNode.setAttribute("status", "ok");
                    doc.appendChild(rootNode);
                    request.setAttribute("rootNode", (Object)rootNode);
                    con = this.setup.getDBConnectionFromPool();
                    if (this.checkUser(request, rootNode, con)) {
                        this.doModule(request, response, rootNode);
                    }
                    response.setContentType("text/xml; charset=UTF-8");
                    ServerUtils.addNoCache((HttpServletResponse)response);
                    out = response.getWriter();
                    out.write(XMLUtils.serializeToString((Node)doc.getDocumentElement(), (boolean)false));
                    if (out == null) break block9;
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    if (out == null) {
                        e.printStackTrace();
                    } else {
                        e.printStackTrace(out);
                    }
                    break block10;
                }
                finally {
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                    ServerUtils.closeConnection(con);
                }
            }
            ServerUtils.closeConnection((Connection)con);
        }
    }

    protected boolean checkUser(HttpServletRequest request, Element rootNode, Connection con) throws Exception {
        Object msg = "";
        int error_code = 0;
        int mid = -1;
        try {
            mid = Integer.parseInt(request.getParameter("mid"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getLoginAndPassword(request);
        String userName = (String)request.getAttribute("userName");
        String userPswd = (String)request.getAttribute("userPswd");
        boolean result = false;
        if (userName != null && userPswd != null && mid > -1) {
            HttpSession session = request.getSession(true);
            if (!result) {
                try {
                    String query = "UPDATE card_dealer_" + mid + " SET error=? WHERE login=?";
                    PreparedStatement psUpdate = con.prepareStatement(query);
                    psUpdate.setString(2, userName);
                    query = "SELECT id, pswd, error, ip FROM card_dealer_" + mid + " WHERE login=? LIMIT 1";
                    PreparedStatement ps = con.prepareStatement(query);
                    ps.setString(1, userName);
                    ResultSet rs = ps.executeQuery();
                    msg = "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \"" + userName + "\" - \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0411\u0414";
                    error_code = 1;
                    if (rs.next()) {
                        String remoteAddr = ServletUtils.getIpFromHeader((HttpServletRequest)request, (Setup)this.setup);
                        String pswd = rs.getString(2);
                        int error = rs.getInt(3);
                        String ip = rs.getString(4);
                        if (ip == null || ip.length() > 0 && !remoteAddr.startsWith(ip)) {
                            msg = "IP deny => " + remoteAddr;
                            error_code = 5;
                        } else if (error > 5) {
                            msg = "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u044b\u0445 \u043f\u043e\u043f\u044b\u0442\u043e\u043a \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f. \u041b\u043e\u0433\u0438\u043d \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d.";
                            error_code = 6;
                        } else if (pswd != null && userPswd.equals(pswd)) {
                            session.setAttribute("user_id", (Object)rs.getInt(1));
                            session.setAttribute("user", (Object)userName);
                            session.setAttribute("pswd", (Object)userPswd);
                            result = true;
                            psUpdate.setInt(1, 0);
                            psUpdate.executeUpdate();
                            psUpdate.close();
                        } else {
                            msg = "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c";
                            error_code = 2;
                            psUpdate.setInt(1, error + 1);
                            psUpdate.executeUpdate();
                            psUpdate.close();
                        }
                    }
                    rs.close();
                    ps.close();
                }
                catch (Exception e) {
                    msg = e.getLocalizedMessage();
                    error_code = 3;
                }
            }
        } else {
            msg = "\u041d\u0435\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430(\u043e\u0432): user, pswd, mid";
            error_code = 4;
        }
        if (!result) {
            this.setErrorStatus(rootNode, (String)msg, error_code);
        }
        return result;
    }

    private void setErrorStatus(Element rootNode, String msg, int error_code) throws DOMException {
        rootNode.setAttribute("status", "error");
        rootNode.setAttribute("error_code", String.valueOf(error_code));
        rootNode.appendChild(rootNode.getOwnerDocument().createTextNode(msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doModule(HttpServletRequest request, HttpServletResponse response, Element rootNode) throws Exception {
        String action = request.getParameter("action");
        if (action == null) {
            this.setErrorStatus(rootNode, "Parameter 'action' not found!", 5);
            return;
        }
        String className = "bitel.billing.server.card.action.Action" + action;
        Action actionClass = null;
        try {
            actionClass = (Action)Class.forName(className).newInstance();
            actionClass.init(this.setup, rootNode, request, response, this.servletContext);
            actionClass.doAction();
        }
        catch (Exception ex) {
            this.setErrorStatus(rootNode, ex.getMessage(), 6);
            ex.printStackTrace();
        }
        finally {
            if (actionClass != null) {
                actionClass.freeConnection();
            }
        }
    }
}

