/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import bitel.billing.server.util.SnmpUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.TreeMap;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.modules.ipn.server.GateWorker;
import ru.bitel.bgbilling.modules.ipn.server.UserStatus;
import ru.bitel.bgbilling.modules.ipn.server.bean.Gate;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateType;
import ru.bitel.bgbilling.modules.ipn.server.bean.RuleType;
import ru.bitel.bgbilling.modules.ipn.server.dlink.EthernetProfile;
import ru.bitel.bgbilling.modules.ipn.server.dlink.EthernetRule;
import ru.bitel.bgbilling.modules.ipn.server.dlink.IPProfile;
import ru.bitel.bgbilling.modules.ipn.server.dlink.IPRule;
import ru.bitel.bgbilling.modules.ipn.server.dlink.NeedRule;
import ru.bitel.bgbilling.modules.ipn.server.dlink.PortMask;
import ru.bitel.bgbilling.modules.ipn.server.dlink.Profile;
import ru.bitel.bgbilling.modules.ipn.server.dlink.Rule;
import ru.bitel.bgbilling.modules.ipn.server.dlink.UserPortStatus;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import uk.co.westhawk.snmp.pdu.GetNextPdu_vec;
import uk.co.westhawk.snmp.pdu.OneSetPdu;
import uk.co.westhawk.snmp.stack.AgentException;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnObjectId;
import uk.co.westhawk.snmp.stack.SnmpContext;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;
import uk.co.westhawk.snmp.stack.SnmpContextv2c;
import uk.co.westhawk.snmp.stack.varbind;

public class DlinkGateWorker
extends GateWorker
implements UserPortStatus.UserPortStatusParser {
    private int requestCount = 0;
    private String openMask = "FF FF FF FF";
    private String openAddress = "FF FF FF FF";
    private int profile4pos = 4;
    private int profile8pos = 8;
    private int profile12pos = 12;
    private int profile16pos = 16;
    private int profile20pos = 20;
    private int profile24pos = 24;
    private int profile28pos = 28;
    protected SnmpContext context;
    protected PortMask portMask;
    private List<Integer> uplinks = new ArrayList<Integer>();
    private static final int UPLINK_RULE_OFFSET = 1000;
    private int dlinkModel = 1;
    protected EthernetProfileObserver ethObs = new EthernetProfileObserver();
    protected IPProfileObserver ipObs = new IPProfileObserver();
    private int[] intervals;

    @Override
    public void init(Gate gate, Map<Integer, RuleType> ruleTypeMap, Map<Integer, GateType> gateTypeMap, int mid) {
        super.init(gate, ruleTypeMap, gateTypeMap, mid);
        Preferences gateSetup = new Preferences(gate.getConfig(), "\r\n");
        String retryIntervals = gateSetup.get("retry.intervals", "500,1000,2000,5000,5000");
        String[] intervalsStr = retryIntervals.split(",");
        this.intervals = new int[intervalsStr.length];
        for (int i = 0; i < intervalsStr.length; ++i) {
            this.intervals[i] = Utils.parseInt((String)intervalsStr[i]);
        }
    }

    @Override
    protected void doSync() {
        String host = this.gate.getHost();
        int port = this.gate.getPort();
        int gid = this.gate.getId();
        if (this.log.isDebugEnabled()) {
            this.log.debug(gid + " gate: " + host + ":" + port + " commutinty " + this.gate.getKeyword());
        }
        try {
            this.context = this.getSnmpContext(this.gate.getGateType(), host, port);
            SnmpUtils.setBufferSizes((SnmpContext)this.context, (int)2, (int)2);
            this.takeConfig();
            this.loadProfiles();
            List<UserPortStatus> userList = this.loadUserList();
            ArrayList<NeedProfile> needProfiles = new ArrayList<NeedProfile>();
            NeedProfile profile4 = new NeedProfile(new IPProfile(this.dlinkModel, this.profile4pos, 2, "00 00 00 00", "FF FF FF FF", 2, "FF FF", 5));
            NeedProfile profile8 = new NeedProfile(new IPProfile(this.dlinkModel, this.profile8pos, 4, "FF FF FF FF", this.openMask, 1, "00 00", 1));
            NeedProfile profile12 = new NeedProfile(new IPProfile(this.dlinkModel, this.profile12pos, 4, this.openMask, "FF FF FF FF", 1, "00 00", 1));
            NeedProfile profile16 = new NeedProfile(new IPProfile(this.dlinkModel, this.profile16pos, 2, "00 00 00 00", "FF FF FF FF", 1, "00 00", 1));
            NeedProfile profile20 = new NeedProfile(new IPProfile(this.dlinkModel, this.profile20pos, 3, "FF FF FF FF", "00 00 00 00", 1, "00 00", 1));
            NeedProfile profile24 = new NeedProfile(new EthernetProfile(this.dlinkModel, this.profile24pos, 1, "00 00 00 00 00 00", "00 00 00 00 00 00", 1));
            NeedProfile profile28 = new NeedProfile(new EthernetProfile(this.dlinkModel, this.profile28pos, 3, "00 00 00 00 00 00", "00 00 00 00 00 00", 2));
            needProfiles.add(profile4);
            needProfiles.add(profile8);
            needProfiles.add(profile12);
            needProfiles.add(profile16);
            needProfiles.add(profile20);
            needProfiles.add(profile24);
            needProfiles.add(profile28);
            boolean needRule = false;
            for (UserPortStatus userPort : userList) {
                NeedRule rule = null;
                boolean notRemoved = userPort.status.status != 3;
                rule = new NeedRule(notRemoved, new IPRule(this.dlinkModel, userPort.port, userPort.port, 2, "00 00 00 00", "FF FF FF FF", 5, 67));
                profile4.addRule(rule);
                rule = new NeedRule(notRemoved, new IPRule(this.dlinkModel, userPort.port, userPort.port, 2, userPort.ipAddr, this.openAddress, 1, 0));
                profile8.addRule(rule);
                needRule = userPort.status.status == 0;
                rule = new NeedRule(needRule, new IPRule(this.dlinkModel, userPort.port, userPort.port, 2, userPort.ipAddr, "00 00 00 00", 1, 0));
                profile20.addRule(rule);
                rule = new NeedRule(notRemoved, new EthernetRule(this.dlinkModel, userPort.port, userPort.port, 2, "00 00 00 00 00 00", "00 00 00 00 00 00", "08 06"));
                profile24.addRule(rule);
                rule = new NeedRule(true, new EthernetRule(this.dlinkModel, userPort.port, userPort.port, 1, "00 00 00 00 00 00", "00 00 00 00 00 00", "00 00"));
                profile28.addRule(rule);
                int uplinkNum = 0;
                for (int uplink : this.uplinks) {
                    int pos = userPort.port + 1000 * uplinkNum;
                    rule = new NeedRule(notRemoved, new IPRule(this.dlinkModel, pos, uplink, 2, this.openAddress, userPort.ipAddr, 1, 0));
                    profile12.addRule(rule);
                    needRule = userPort.status.status != 0;
                    rule = new NeedRule(needRule, new IPRule(this.dlinkModel, pos, uplink, 1, "00 00 00 00", userPort.ipAddr, 1, 0));
                    profile16.addRule(rule);
                    ++uplinkNum;
                }
            }
            this.createProfilesAndRules(needProfiles);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.context != null) {
                this.context.destroy();
            }
        }
    }

    protected void createProfilesAndRules(List<NeedProfile> needProfiles) throws Exception, InterruptedException {
        for (NeedProfile needProfile : needProfiles) {
            Profile existProfile = null;
            existProfile = needProfile.getProfile() instanceof EthernetProfile ? this.ethObs.getProfileMap().get(needProfile.getProfile().getId()) : this.ipObs.getProfileMap().get(needProfile.getProfile().getId());
            if (existProfile == null || !needProfile.getProfile().equals(existProfile)) {
                existProfile = needProfile.getProfile();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Creating profile " + needProfile.getProfile().getId());
                }
                existProfile.delete(this);
                this.waitResponse();
                existProfile.create(this);
                this.waitResponse();
            }
            for (NeedRule rule : needProfile.getRuleList()) {
                rule.getRule().deleteRule(needProfile.getProfile().getId(), this);
                this.waitResponse();
                if (!rule.isMustBe()) continue;
                rule.getRule().createRule(needProfile.getProfile().getId(), this, this.portMask);
                this.waitResponse();
            }
        }
        this.waitResponse();
    }

    protected void loadProfiles() throws Exception, InterruptedException {
        this.sendNextPdu(this.ethObs.getTopOid(), this.ethObs);
        this.sendNextPdu(this.ipObs.getTopOid(), this.ipObs);
        this.waitResponse();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Ethernet profiles:");
            for (Profile profile : this.ethObs.getProfileMap().values()) {
                this.log.debug(profile.toString());
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("IP profiles:");
            for (Profile profile : this.ipObs.getProfileMap().values()) {
                this.log.debug(profile.toString());
            }
        }
    }

    protected List<UserPortStatus> loadUserList() {
        return this.getUserList(this.statusList);
    }

    @Override
    public List<UserPortStatus> getUserList(List<UserStatus> statusList) {
        ArrayList<UserPortStatus> userList = new ArrayList<UserPortStatus>();
        for (UserStatus status : statusList) {
            String rule = status.rule.getRuleText();
            StringTokenizer st = new StringTokenizer(rule, ";");
            while (st.hasMoreTokens()) {
                UserPortStatus portStatus;
                String token = st.nextToken().trim();
                String[] data = token.split(":");
                if (data.length == 2) {
                    portStatus = new UserPortStatus();
                    portStatus.port = Utils.parseInt((String)data[0]);
                    portStatus.ipAddr = Utils.bytesToString((byte[])Utils.convertIntToBytes((int)IPUtils.convertStringIPtoInt((String)data[1])));
                    portStatus.status = status;
                    userList.add(portStatus);
                    continue;
                }
                if (data.length != 3) continue;
                portStatus = new UserPortStatus();
                portStatus.port = Utils.parseInt((String)data[0]);
                portStatus.macAddr = data[1].toUpperCase().replaceAll("\\-", " ");
                portStatus.ipAddr = Utils.bytesToString((byte[])Utils.convertIntToBytes((int)IPUtils.convertStringIPtoInt((String)data[2])));
                portStatus.status = status;
                userList.add(portStatus);
            }
        }
        return userList;
    }

    protected void waitResponse() throws InterruptedException {
        while (this.requestCount != 0) {
            Thread.sleep(100L);
        }
    }

    private void takeConfig() {
        Preferences gateSetup = new Preferences(this.gate.getConfig(), "\r\n");
        this.openMask = Utils.bytesToString((byte[])Utils.convertIntToBytes((int)IPUtils.convertStringIPtoInt((String)gateSetup.get("open.mask", "255.255.255.255"))));
        this.openAddress = Utils.bytesToString((byte[])Utils.convertIntToBytes((int)IPUtils.convertStringIPtoInt((String)gateSetup.get("open.address", "255.255.255.255"))));
        this.uplinks = Utils.toIntegerList((String)gateSetup.get("uplink", null));
        int ports = gateSetup.getInt("ports", 4);
        this.portMask = new PortMask(ports % 8 == 0 ? ports / 8 : ports / 8 + 1);
        this.profile4pos = gateSetup.getInt("profile.4", this.profile4pos);
        this.profile8pos = gateSetup.getInt("profile.8", this.profile8pos);
        this.profile12pos = gateSetup.getInt("profile.12", this.profile12pos);
        this.profile16pos = gateSetup.getInt("profile.16", this.profile16pos);
        this.profile20pos = gateSetup.getInt("profile.20", this.profile20pos);
        this.profile24pos = gateSetup.getInt("profile.24", this.profile24pos);
        this.profile28pos = gateSetup.getInt("profile.28", this.profile28pos);
        Preferences gateTypeSetup = new Preferences(this.gate.getGateType().getConfig(), "\r\n");
        this.dlinkModel = gateTypeSetup.getInt("model", this.dlinkModel);
    }

    protected SnmpContext getSnmpContext(GateType gateType, String host, int port) throws IOException {
        String snmpVersion = gateType.getConfigOption("snmp.version");
        if (Utils.isBlankString((String)snmpVersion)) {
            snmpVersion = "1";
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("SNMP version: " + snmpVersion);
        }
        Object context = null;
        context = snmpVersion.equals("2") || snmpVersion.equals("2c") ? new SnmpContextv2c(host, port) : new SnmpContext(host, port);
        context.setCommunity(this.gate.getKeyword());
        return context;
    }

    protected void sendNextPdu(String oid, NextObserver observer) throws Exception {
        GetNextPdu_vec pdu = new GetNextPdu_vec((SnmpContextBasisFace)this.context, 1000);
        pdu.addObserver((Observer)observer);
        pdu.addOid(oid);
        pdu.setRetryIntervals(this.intervals);
        pdu.send();
        ++this.requestCount;
    }

    public void sendSetPdu(String oid, AsnObject value) throws Exception {
        ArrayList<Object[]> pairs = new ArrayList<Object[]>(1);
        pairs.add(new Object[]{oid, value});
        this.sendSetPdu(pairs);
    }

    public void sendSetPdu(List<Object[]> pairs) throws Exception {
        OneSetPdu pdu = new OneSetPdu((SnmpContextBasisFace)this.context);
        pdu.addObserver((Observer)new SetObserver());
        for (Object[] pair : pairs) {
            String oid = (String)pair[0];
            AsnObject object = (AsnObject)pair[1];
            pdu.addOid(oid, object);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug(oid + "=" + object.toString());
        }
        pdu.setRetryIntervals(this.intervals);
        pdu.send();
        ++this.requestCount;
    }

    @Override
    public boolean isWorking() {
        return this.isAlive() || this.requestCount != 0;
    }

    class EthernetProfileObserver
    extends ProfileObserver {
        EthernetProfileObserver() {
        }

        @Override
        public final String getTopOid() {
            return EthernetProfile.getOid(DlinkGateWorker.this.dlinkModel);
        }

        @Override
        protected Profile createProfile() {
            return new EthernetProfile(DlinkGateWorker.this.dlinkModel);
        }
    }

    class IPProfileObserver
    extends ProfileObserver {
        IPProfileObserver() {
        }

        @Override
        public String getTopOid() {
            return IPProfile.getOid(DlinkGateWorker.this.dlinkModel);
        }

        @Override
        protected Profile createProfile() {
            return new IPProfile(DlinkGateWorker.this.dlinkModel);
        }
    }

    class NeedProfile {
        private Profile profile;
        private List<NeedRule> needRuleList = new ArrayList<NeedRule>();

        public NeedProfile(Profile profile) {
            this.profile = profile;
        }

        public Profile getProfile() {
            return this.profile;
        }

        public void addRule(NeedRule rule) {
            this.needRuleList.add(rule);
        }

        public List<NeedRule> getRuleList() {
            return this.needRuleList;
        }
    }

    protected abstract class NextObserver
    implements Observer {
        protected NextObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            --DlinkGateWorker.this.requestCount;
            if (arg instanceof AgentException) {
                DlinkGateWorker.this.log.error(arg);
                DlinkGateWorker.this.gateErrors.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0448\u043b\u044e\u0437\u0430 " + DlinkGateWorker.this.gate.getHost() + " : " + ((AgentException)arg).getMessage());
                if (DlinkGateWorker.this.context != null) {
                    DlinkGateWorker.this.context.destroy();
                }
                DlinkGateWorker.this.interrupt();
                return;
            }
            try {
                varbind var = ((varbind[])arg)[0];
                AsnObjectId oid = var.getOid();
                if (oid.toString().startsWith(this.getTopOid())) {
                    DlinkGateWorker.this.sendNextPdu(oid.toString(), this);
                    this.processResponse(var);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public abstract String getTopOid();

        protected abstract void processResponse(varbind var1);
    }

    class SetObserver
    implements Observer {
        SetObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            --DlinkGateWorker.this.requestCount;
            if (arg instanceof AgentException) {
                DlinkGateWorker.this.log.error(arg);
                DlinkGateWorker.this.gateErrors.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0448\u043b\u044e\u0437\u0430 " + DlinkGateWorker.this.gate.getHost() + " : " + ((AgentException)arg).getMessage());
                if (DlinkGateWorker.this.context != null) {
                    DlinkGateWorker.this.context.destroy();
                }
                DlinkGateWorker.this.interrupt();
                return;
            }
        }
    }

    class IPRuleObserver
    extends RuleObserver {
        public IPRuleObserver(Map<Integer, Profile> profileMap) {
            super(profileMap);
        }

        @Override
        public final String getTopOid() {
            return IPRule.getOid(DlinkGateWorker.this.dlinkModel);
        }

        @Override
        protected Rule createRule() {
            return new IPRule(DlinkGateWorker.this.dlinkModel);
        }
    }

    class EthernetRuleObserver
    extends RuleObserver {
        public EthernetRuleObserver(Map<Integer, Profile> profileMap) {
            super(profileMap);
        }

        @Override
        public final String getTopOid() {
            return EthernetRule.getOid(DlinkGateWorker.this.dlinkModel);
        }

        @Override
        protected Rule createRule() {
            return new EthernetRule(DlinkGateWorker.this.dlinkModel);
        }
    }

    abstract class RuleObserver
    extends NextObserver {
        private Map<Integer, Profile> profileMap;

        public RuleObserver(Map<Integer, Profile> profileMap) {
            this.profileMap = profileMap;
        }

        @Override
        protected void processResponse(varbind var) {
            String oid = var.getOid().toString();
            int pos = oid.lastIndexOf(46);
            int ruleId = Utils.parseInt((String)oid.substring(pos + 1));
            int profileId = Utils.parseInt((String)(oid = oid.substring(0, pos)).substring((pos = oid.lastIndexOf(46)) + 1));
            Profile profile = this.profileMap.get(profileId);
            if (profile != null) {
                Rule rule = profile.getRuleMap().get(ruleId);
                if (rule == null) {
                    rule = this.createRule();
                    rule.setId(ruleId);
                    profile.addRule(rule);
                }
                rule.takeData(DlinkGateWorker.this.portMask, oid, var);
            }
        }

        protected abstract Rule createRule();
    }

    abstract class ProfileObserver
    extends NextObserver {
        private Map<Integer, Profile> profileMap = new TreeMap<Integer, Profile>();

        ProfileObserver() {
        }

        public Map<Integer, Profile> getProfileMap() {
            return this.profileMap;
        }

        @Override
        protected void processResponse(varbind var) {
            int pos;
            String oid = var.getOid().toString();
            int profileId = Utils.parseInt((String)oid.substring((pos = oid.lastIndexOf(46)) + 1));
            Profile profile = this.profileMap.get(profileId);
            if (profile == null) {
                profile = this.createProfile();
                profile.setId(profileId);
                this.profileMap.put(profileId, profile);
            }
            profile.takeData(DlinkGateWorker.this.portMask, oid, var);
        }

        protected abstract Profile createProfile();
    }
}

