/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.service;

import jakarta.jws.WebService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.ipn.common.service.IpnService;
import ru.bitel.bgbilling.modules.ipn.server.bean.Gate;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.GatePortManager;
import ru.bitel.common.model.IdTitle;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.ipn.common.service.IpnService")
public class IpnServiceImpl
extends AbstractService
implements IpnService {
    public IdTitle gateGet(int gateId) throws BGException, BGMessageException {
        Gate gate = new GateManager(this.getConnection(), this.moduleId).getGateById(gateId);
        return new IdTitle(gate.getId(), gate.getTitle());
    }

    public void gatePortDelete(int contractId, int gateId) throws BGException, BGMessageException {
        new GatePortManager(this.getConnection(), this.moduleId).deleteGatePorts(contractId, gateId);
    }

    public List<IdTitle> availableGates(int contractId) throws BGException, BGMessageException {
        GatePortManager man = new GatePortManager(this.getConnection(), this.moduleId);
        return man.getAvailableGates(contractId).stream().map(Gate::toIdTitle).toList();
    }

    public List<Integer> gatePorts(int contractId, int gateId) throws BGException, BGMessageException {
        GatePortManager man = new GatePortManager(this.getConnection(), this.moduleId);
        try {
            Map<String, Object> m = man.getGatePortMap(contractId, gateId);
            if (m != null) {
                return (List)m.get("ports");
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return Collections.emptyList();
    }
}

