/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.worker;

import java.sql.Connection;
import java.time.LocalDateTime;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.BGFutureTaskEvent;
import ru.bitel.bgbilling.kernel.task.common.bean.BGFutureTask;
import ru.bitel.bgbilling.kernel.task.server.bean.BGFutureTaskDao;
import ru.bitel.bgbilling.server.util.Setup;

public class BGFutureTaskWorker
extends Thread {
    private boolean run = true;
    private int checkPeriod = Setup.getSetup().getInt("future.task.check.period", 300);
    private LocalDateTime lastRun = LocalDateTime.now().minusDays(10L);

    public BGFutureTaskWorker() {
        Setup.getSetup().putObject("bg-future-task-worker", (Object)this);
    }

    public void setRun(boolean run) {
        this.run = run;
    }

    @Override
    public void run() {
        while (this.run) {
            LocalDateTime checkTime = LocalDateTime.now();
            if (this.lastRun.isBefore(checkTime.minusSeconds(this.checkPeriod))) {
                try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
                    BGFutureTaskDao futureTaskDao = new BGFutureTaskDao(con);
                    EventProcessor eventProcessor = EventProcessor.getInstance();
                    for (BGFutureTask futureTask : futureTaskDao.listForRun()) {
                        eventProcessor.publish(new BGFutureTaskEvent(futureTask));
                    }
                    this.lastRun = checkTime;
                }
                catch (Exception ex) {
                    BGLogger.error(ex);
                }
            }
            try {
                BGFutureTaskWorker.sleep(5000L);
            }
            catch (InterruptedException ex) {
                BGLogger.error(ex);
            }
        }
    }
}

