/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client.scheme;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.modules.botmanager.client.scheme.DialogNode;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElementType;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

public class DialogScheme {
    private List<Integer> wasAddedToScheme = new ArrayList<Integer>();
    private final Map<Integer, BotDialog> dialogMap;
    private DialogNode rootNode;

    public DialogScheme(List<BotDialog> allDialogs, BotDialog rootDialog) {
        this.dialogMap = allDialogs.stream().collect(Collectors.toMap(Id::getId, Function.identity()));
        this.rootNode = new DialogNode(rootDialog);
        this.wasAddedToScheme.add(rootDialog.getId());
        this.buildDialogNodeTree(this.rootNode);
    }

    private void buildDialogNodeTree(DialogNode dialogNode) {
        List elements = dialogNode.getBotDialog().getDialogElements();
        if (Utils.isEmptyCollection((Collection)elements)) {
            return;
        }
        for (BotDialogElement element : elements) {
            BotDialog d;
            int nextDialogId;
            if (!element.getElementType().equals((Object)BotDialogElementType.BUTTON) || (nextDialogId = element.getJSONConfig().optInt("dialogProcessingClassPath", -1)) <= 0 || (d = this.dialogMap.get(nextDialogId)) == null || this.wasAddedToScheme.contains(d.getId())) continue;
            this.wasAddedToScheme.add(d.getId());
            DialogNode dialogNode1 = new DialogNode(d);
            dialogNode.addChild(dialogNode1);
            this.buildDialogNodeTree(dialogNode1);
        }
    }

    public DialogNode getRootNode() {
        return this.rootNode;
    }
}

