/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.subscription.common.bean.SubscriptionType;
import ru.bitel.bgbilling.modules.subscription.common.bean.Unit;
import ru.bitel.bgbilling.modules.subscription.common.bean.ValueUnit;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDirectoryIdDao;
import ru.bitel.common.model.Period;

public class SubscriptionTypeDao
extends AbstractDirectoryIdDao<SubscriptionType> {
    public SubscriptionTypeDao(Connection con, int moduleId) {
        super(con, moduleId, "subscription_type");
    }

    protected SubscriptionType getFromRS(ResultSet rs) throws SQLException {
        return SubscriptionType.builder().setId(rs.getInt("id")).setServiceId(rs.getInt("service_id")).setTitle(rs.getString("title")).setComment(rs.getString("comment")).setPeriod(new Period((Date)rs.getTimestamp("date_from"), (Date)rs.getTimestamp("date_to"))).setDuration(new ValueUnit(rs.getLong("duration_value"), Unit.valueOf((String)rs.getString("duration_unit")))).setDelay(new ValueUnit(rs.getLong("delay_value"), Unit.valueOf((String)rs.getString("delay_unit")))).setRound(new ValueUnit(rs.getLong("round_value"), Unit.valueOf((String)rs.getString("round_unit")))).setAvtoCommit(rs.getBoolean("avto_commit")).setConfig(rs.getString("config")).build();
    }

    protected void updateImpl(SubscriptionType subscriptionType) throws SQLException {
        Objects.requireNonNull(subscriptionType);
        boolean update = subscriptionType.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET service_id=?, title=?, comment=?, date_from=?, date_to=?, duration_value=?, duration_unit=?, delay_value=?, delay_unit=?, round_value=?, round_unit=?, avto_commit=?, config=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            Period period = subscriptionType.getPeriod();
            int index = 1;
            ps.setInt(index++, subscriptionType.getServiceId());
            ps.setString(index++, subscriptionType.getTitle());
            ps.setString(index++, subscriptionType.getComment());
            ps.setDate(index++, period != null ? TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()) : null);
            ps.setDate(index++, period != null ? TimeUtils.convertDateToSqlDate((Date)period.getDateTo()) : null);
            ps.setLong(index++, subscriptionType.getDuration().getValue());
            ps.setString(index++, subscriptionType.getDuration().getUnit().toString());
            ps.setLong(index++, subscriptionType.getDelay().getValue());
            ps.setString(index++, subscriptionType.getDelay().getUnit().toString());
            ps.setLong(index++, subscriptionType.getRound().getValue());
            ps.setString(index++, subscriptionType.getRound().getUnit().toString());
            ps.setBoolean(index++, subscriptionType.isAvtoCommit());
            ps.setString(index++, subscriptionType.getConfig());
            if (update) {
                ps.setInt(index++, subscriptionType.getId());
            }
            ps.executeUpdate();
            if (!update) {
                subscriptionType.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public SubscriptionType get(String title) throws BGException {
        return (SubscriptionType)super.get("title=?", new Object[]{title});
    }

    public List<SubscriptionType> list() throws BGException {
        return super.list(null, "title", new Object[0]);
    }
}

