/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.table;

import java.util.Collections;
import java.util.List;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServSearchParam;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpRange;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TableInetSearch
extends BGTableInfoBase {
    public TableInetSearch() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnId(), BGUTableColumn.buildColumnTextLeft((String)"\u0414\u043e\u0433\u043e\u0432\u043e\u0440", (String)"contractTitle"), BGUTableColumn.buildColumnTextLeft((String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", (String)"contractComment").setMaxWidth(-1), BGUTableColumn.buildColumnTextLeft((String)"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", (String)"title").setMaxWidth(-1), BGUTableColumn.buildColumnPeriod(), BGUTableColumn.buildColumnTextCenter((String)"\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432", (String)"addrRange").setWidth(350)};
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        if (tableParams == null || tableParams.getParams() == null) {
            return Collections.emptyList();
        }
        String filterKey = tableParams.optParamValue("filter_key").orElse("");
        String filterValue = tableParams.optParamValue("filter_value").orElse("");
        InetServSearchParam searchParam = new InetServSearchParam().setServiceTypeId(Utils.parseInt((String)tableParams.optParamValue("typeId").orElse("0"), (int)0)).setLogin("login".equals(filterKey) ? filterValue : "").setIp("ip".equals(filterKey) ? IpRange.newInstance((String)filterValue) : null).setVlan("vlan".equals(filterKey) ? Utils.parseInt((String)filterValue, (int)-1) : -1).setTitle("title".equals(filterKey) ? filterValue : "").setIdentifier("identifier".equals(filterKey) ? filterValue : "").setMacAddress("macAddress".equals(filterKey) ? filterValue : "").setLoginStrictCheck(false);
        SearchResult searchResult = ((InetServService)serverContext.newService(InetServService.class, moduleId)).searchInetServ(searchParam, tableParams.getPage());
        this.page = searchResult.getPage();
        return searchResult.getList().stream().map(a -> new BGUTableRowData().addValue(this.getId(a.getId())).addValue("title", a.getTitle()).addValue("contractId", String.valueOf(a.getContractId())).addValue("contractTitle", a.getContractTitle()).addValue("contractComment", a.getContractComment()).addValue(this.getPeriod(new Period(a.getDateFrom(), a.getDateTo()))).addValue("addrRange", a.getAddressFrom() != null || a.getAddressTo() != null ? IpRange.toString((byte[])a.getAddressFrom(), (byte[])a.getAddressTo()) : "")).toList();
    }
}

