/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import jakarta.mail.internet.MimeUtility;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.common.Utils;

public class FileDownload {
    static Map<String, String> s_mapMimeTypes = null;
    static String s_strDefaultMimeType = "application/octet-stream";

    public static String getContentDisposition(HttpServletRequest request, String fileName, boolean isInline) throws IOException {
        Object contentDisposition;
        block10: {
            if (fileName == null) {
                throw new NullPointerException("Value of the \"filename\" parameter cannot be null!");
            }
            contentDisposition = isInline ? "inline; " : "attachment; ";
            String agent = request.getHeader("USER-AGENT").toLowerCase();
            if (agent == null) {
                contentDisposition = (String)contentDisposition + "filename=" + FileDownload.transliterationFileName(fileName);
            } else if (agent.indexOf("opera") != -1) {
                try {
                    int version;
                    int startIndex;
                    int stopIndex;
                    int prefixIndex = agent.indexOf("opera ");
                    if (prefixIndex < 0) {
                        prefixIndex = agent.indexOf("opera/");
                    }
                    if ((stopIndex = agent.indexOf(".", startIndex = prefixIndex + 6)) == -1) {
                        stopIndex = agent.indexOf(" ", startIndex);
                    }
                    if ((version = Integer.valueOf(agent.substring(startIndex, stopIndex)).intValue()) >= 9) {
                        contentDisposition = (String)contentDisposition + "filename*=utf8''" + FileDownload.toHexString(fileName);
                        break block10;
                    }
                    contentDisposition = (String)contentDisposition + "filename=" + FileDownload.transliterationFileName(fileName);
                }
                catch (Exception e) {
                    contentDisposition = (String)contentDisposition + "filename=" + FileDownload.transliterationFileName(fileName);
                }
            } else {
                contentDisposition = agent.indexOf("msie") != -1 ? (String)contentDisposition + "filename=\"" + FileDownload.toHexString(fileName) + "\"" : (agent.indexOf("chrome") != -1 ? (String)contentDisposition + "filename=\"" + FileDownload.toHexString(fileName) + "\"" : (agent.indexOf("safari") != -1 ? (String)contentDisposition + "filename=" + FileDownload.transliterationFileName(fileName) : (agent.indexOf("firefox") != -1 ? (String)contentDisposition + "filename=\"" + MimeUtility.encodeText((String)fileName, (String)"utf8", (String)"B") + "\"" : (String)contentDisposition + "filename=" + FileDownload.transliterationFileName(fileName))));
            }
        }
        return contentDisposition;
    }

    private static String toHexString(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff' && !Character.isWhitespace(c)) {
                sb.append(c);
                continue;
            }
            byte[] b = Character.toString(c).getBytes(StandardCharsets.UTF_8);
            for (int j = 0; j < b.length; ++j) {
                int k = b[j];
                if (k < 0) {
                    k += 256;
                }
                sb.append("%" + Integer.toHexString(k).toUpperCase());
            }
        }
        return sb.toString();
    }

    public static String transliterationFileName(String filename) {
        StringBuilder sb = new StringBuilder(filename.length());
        for (char symbol : filename.toCharArray()) {
            sb.append(Character.isWhitespace(symbol) ? (char)'_' : symbol);
        }
        filename = sb.toString();
        filename = Utils.toTranslit(filename);
        return filename;
    }

    public static void doTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String body = "\u0428\u0438\u0440\u043e\u043a\u0430\u044f \u044d\u043b\u0435\u043a\u0442\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u044e\u0436\u043d\u044b\u0445 \u0433\u0443\u0431\u0435\u0440\u043d\u0438\u0439 \u0434\u0430\u0441\u0442 \u043c\u043e\u0449\u043d\u044b\u0439 \u0442\u043e\u043b\u0447\u043e\u043a \u043f\u043e\u0434\u044a\u0451\u043c\u0443 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430.";
        response.setHeader("Content-Disposition", FileDownload.getContentDisposition(request, "\u0440\u0443\u0441\u0441\u043a\u0438\u0439 \u0439\u0430\u0437\u044b\u043a\u044a.txt", false));
        ServletOutputStream out = response.getOutputStream();
        out.write(body.getBytes("utf-8"));
        out.write(13);
        out.write(10);
        out.write(request.getHeader("USER-AGENT").getBytes());
        out.close();
    }

    public static boolean bcsrch(char[] chars, char c) {
        int len = chars.length;
        int base = 0;
        int last = len - 1;
        while (last >= base) {
            int p = base + (last - base >> 1);
            if (c == chars[p]) {
                return true;
            }
            if (c < chars[p]) {
                last = p - 1;
                continue;
            }
            base = p + 1;
        }
        return false;
    }

    public static String rfc5987_encode(String s) {
        byte[] s_bytes = s.getBytes(StandardCharsets.UTF_8);
        int len = s_bytes.length;
        StringBuilder sb = new StringBuilder(len << 1);
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] attr_char = new char[]{'!', '#', '$', '&', '\'', '+', '-', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '^', '_', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '|', '~'};
        for (int i = 0; i < len; ++i) {
            byte b = s_bytes[i];
            if (FileDownload.bcsrch(attr_char, (char)b)) {
                sb.append((char)b);
                continue;
            }
            char[] encoded = new char[]{'%', '\u0000', '\u0000'};
            encoded[1] = digits[0xF & b >>> 4];
            encoded[2] = digits[b & 0xF];
            sb.append(encoded);
        }
        return sb.toString();
    }

    public static String getMimeType(String strKey) {
        String strMimeType = null;
        strMimeType = s_mapMimeTypes.get(strKey);
        if (strMimeType == null || strMimeType.trim().length() == 0) {
            strMimeType = s_strDefaultMimeType;
        }
        return strMimeType;
    }

    static {
        s_mapMimeTypes = new HashMap<String, String>(161);
        s_mapMimeTypes.put("ai", "application/postscript");
        s_mapMimeTypes.put("aif", "audio/x-aiff");
        s_mapMimeTypes.put("aifc", "audio/x-aiff");
        s_mapMimeTypes.put("aiff", "audio/x-aiff");
        s_mapMimeTypes.put("asc", "text/plain");
        s_mapMimeTypes.put("asf", "video/x.ms.asf");
        s_mapMimeTypes.put("asx", "video/x.ms.asx");
        s_mapMimeTypes.put("au", "audio/basic");
        s_mapMimeTypes.put("avi", "video/x-msvideo");
        s_mapMimeTypes.put("bcpio", "application/x-bcpio");
        s_mapMimeTypes.put("bin", "application/octet-stream");
        s_mapMimeTypes.put("cab", "application/x-cabinet");
        s_mapMimeTypes.put("cdf", "application/x-netcdf");
        s_mapMimeTypes.put("class", "application/java-vm");
        s_mapMimeTypes.put("cpio", "application/x-cpio");
        s_mapMimeTypes.put("cpt", "application/mac-compactpro");
        s_mapMimeTypes.put("crt", "application/x-x509-ca-cert");
        s_mapMimeTypes.put("csh", "application/x-csh");
        s_mapMimeTypes.put("css", "text/css");
        s_mapMimeTypes.put("csv", "text/comma-separated-values");
        s_mapMimeTypes.put("dcr", "application/x-director");
        s_mapMimeTypes.put("dir", "application/x-director");
        s_mapMimeTypes.put("dll", "application/x-msdownload");
        s_mapMimeTypes.put("dms", "application/octet-stream");
        s_mapMimeTypes.put("doc", "application/msword");
        s_mapMimeTypes.put("dtd", "application/xml-dtd");
        s_mapMimeTypes.put("dvi", "application/x-dvi");
        s_mapMimeTypes.put("dxr", "application/x-director");
        s_mapMimeTypes.put("eps", "application/postscript");
        s_mapMimeTypes.put("etx", "text/x-setext");
        s_mapMimeTypes.put("exe", "application/octet-stream");
        s_mapMimeTypes.put("ez", "application/andrew-inset");
        s_mapMimeTypes.put("gif", "image/gif");
        s_mapMimeTypes.put("gtar", "application/x-gtar");
        s_mapMimeTypes.put("gz", "application/gzip");
        s_mapMimeTypes.put("gzip", "application/gzip");
        s_mapMimeTypes.put("hdf", "application/x-hdf");
        s_mapMimeTypes.put("htc", "text/x-component");
        s_mapMimeTypes.put("hqx", "application/mac-binhex40");
        s_mapMimeTypes.put("html", "text/html");
        s_mapMimeTypes.put("htm", "text/html");
        s_mapMimeTypes.put("ice", "x-conference/x-cooltalk");
        s_mapMimeTypes.put("ief", "image/ief");
        s_mapMimeTypes.put("iges", "model/iges");
        s_mapMimeTypes.put("igs", "model/iges");
        s_mapMimeTypes.put("jar", "application/java-archive");
        s_mapMimeTypes.put("java", "text/plain");
        s_mapMimeTypes.put("jnlp", "application/x-java-jnlp-file");
        s_mapMimeTypes.put("jpeg", "image/jpeg");
        s_mapMimeTypes.put("jpe", "image/jpeg");
        s_mapMimeTypes.put("jpg", "image/jpeg");
        s_mapMimeTypes.put("js", "application/x-javascript");
        s_mapMimeTypes.put("jsp", "text/plain");
        s_mapMimeTypes.put("kar", "audio/midi");
        s_mapMimeTypes.put("latex", "application/x-latex");
        s_mapMimeTypes.put("lha", "application/octet-stream");
        s_mapMimeTypes.put("lzh", "application/octet-stream");
        s_mapMimeTypes.put("man", "application/x-troff-man");
        s_mapMimeTypes.put("mathml", "application/mathml+xml");
        s_mapMimeTypes.put("me", "application/x-troff-me");
        s_mapMimeTypes.put("mesh", "model/mesh");
        s_mapMimeTypes.put("mid", "audio/midi");
        s_mapMimeTypes.put("midi", "audio/midi");
        s_mapMimeTypes.put("mif", "application/vnd.mif");
        s_mapMimeTypes.put("mol", "chemical/x-mdl-molfile");
        s_mapMimeTypes.put("movie", "video/x-sgi-movie");
        s_mapMimeTypes.put("mov", "video/quicktime");
        s_mapMimeTypes.put("mp2", "audio/mpeg");
        s_mapMimeTypes.put("mp3", "audio/mpeg");
        s_mapMimeTypes.put("mpeg", "video/mpeg");
        s_mapMimeTypes.put("mpe", "video/mpeg");
        s_mapMimeTypes.put("mpga", "audio/mpeg");
        s_mapMimeTypes.put("mpg", "video/mpeg");
        s_mapMimeTypes.put("ms", "application/x-troff-ms");
        s_mapMimeTypes.put("msh", "model/mesh");
        s_mapMimeTypes.put("msi", "application/octet-stream");
        s_mapMimeTypes.put("nc", "application/x-netcdf");
        s_mapMimeTypes.put("oda", "application/oda");
        s_mapMimeTypes.put("ogg", "application/ogg");
        s_mapMimeTypes.put("pbm", "image/x-portable-bitmap");
        s_mapMimeTypes.put("pdb", "chemical/x-pdb");
        s_mapMimeTypes.put("pdf", "application/pdf");
        s_mapMimeTypes.put("pgm", "image/x-portable-graymap");
        s_mapMimeTypes.put("pgn", "application/x-chess-pgn");
        s_mapMimeTypes.put("png", "image/png");
        s_mapMimeTypes.put("pnm", "image/x-portable-anymap");
        s_mapMimeTypes.put("ppm", "image/x-portable-pixmap");
        s_mapMimeTypes.put("ppt", "application/vnd.ms-powerpoint");
        s_mapMimeTypes.put("ps", "application/postscript");
        s_mapMimeTypes.put("qt", "video/quicktime");
        s_mapMimeTypes.put("ra", "audio/x-pn-realaudio");
        s_mapMimeTypes.put("ra", "audio/x-realaudio");
        s_mapMimeTypes.put("ram", "audio/x-pn-realaudio");
        s_mapMimeTypes.put("ras", "image/x-cmu-raster");
        s_mapMimeTypes.put("rdf", "application/rdf+xml");
        s_mapMimeTypes.put("rgb", "image/x-rgb");
        s_mapMimeTypes.put("rm", "audio/x-pn-realaudio");
        s_mapMimeTypes.put("roff", "application/x-troff");
        s_mapMimeTypes.put("rpm", "application/x-rpm");
        s_mapMimeTypes.put("rpm", "audio/x-pn-realaudio");
        s_mapMimeTypes.put("rtf", "application/rtf");
        s_mapMimeTypes.put("rtx", "text/richtext");
        s_mapMimeTypes.put("ser", "application/java-serialized-object");
        s_mapMimeTypes.put("sgml", "text/sgml");
        s_mapMimeTypes.put("sgm", "text/sgml");
        s_mapMimeTypes.put("sh", "application/x-sh");
        s_mapMimeTypes.put("shar", "application/x-shar");
        s_mapMimeTypes.put("silo", "model/mesh");
        s_mapMimeTypes.put("sit", "application/x-stuffit");
        s_mapMimeTypes.put("skd", "application/x-koan");
        s_mapMimeTypes.put("skm", "application/x-koan");
        s_mapMimeTypes.put("skp", "application/x-koan");
        s_mapMimeTypes.put("skt", "application/x-koan");
        s_mapMimeTypes.put("smi", "application/smil");
        s_mapMimeTypes.put("smil", "application/smil");
        s_mapMimeTypes.put("snd", "audio/basic");
        s_mapMimeTypes.put("spl", "application/x-futuresplash");
        s_mapMimeTypes.put("src", "application/x-wais-source");
        s_mapMimeTypes.put("sv4cpio", "application/x-sv4cpio");
        s_mapMimeTypes.put("sv4crc", "application/x-sv4crc");
        s_mapMimeTypes.put("svg", "image/svg+xml");
        s_mapMimeTypes.put("swf", "application/x-shockwave-flash");
        s_mapMimeTypes.put("t", "application/x-troff");
        s_mapMimeTypes.put("tar", "application/x-tar");
        s_mapMimeTypes.put("tar.gz", "application/x-gtar");
        s_mapMimeTypes.put("tcl", "application/x-tcl");
        s_mapMimeTypes.put("tex", "application/x-tex");
        s_mapMimeTypes.put("texi", "application/x-texinfo");
        s_mapMimeTypes.put("texinfo", "application/x-texinfo");
        s_mapMimeTypes.put("tgz", "application/x-gtar");
        s_mapMimeTypes.put("tiff", "image/tiff");
        s_mapMimeTypes.put("tif", "image/tiff");
        s_mapMimeTypes.put("tr", "application/x-troff");
        s_mapMimeTypes.put("tsv", "text/tab-separated-values");
        s_mapMimeTypes.put("txt", "text/plain");
        s_mapMimeTypes.put("ustar", "application/x-ustar");
        s_mapMimeTypes.put("vcd", "application/x-cdlink");
        s_mapMimeTypes.put("vrml", "model/vrml");
        s_mapMimeTypes.put("vxml", "application/voicexml+xml");
        s_mapMimeTypes.put("wav", "audio/x-wav");
        s_mapMimeTypes.put("wbmp", "image/vnd.wap.wbmp");
        s_mapMimeTypes.put("wmlc", "application/vnd.wap.wmlc");
        s_mapMimeTypes.put("wmlsc", "application/vnd.wap.wmlscriptc");
        s_mapMimeTypes.put("wmls", "text/vnd.wap.wmlscript");
        s_mapMimeTypes.put("wml", "text/vnd.wap.wml");
        s_mapMimeTypes.put("wrl", "model/vrml");
        s_mapMimeTypes.put("wtls-ca-certificate", "application/vnd.wap.wtls-ca-certificate");
        s_mapMimeTypes.put("xbm", "image/x-xbitmap");
        s_mapMimeTypes.put("xht", "application/xhtml+xml");
        s_mapMimeTypes.put("xhtml", "application/xhtml+xml");
        s_mapMimeTypes.put("xls", "application/vnd.ms-excel");
        s_mapMimeTypes.put("xml", "application/xml");
        s_mapMimeTypes.put("xpm", "image/x-xpixmap");
        s_mapMimeTypes.put("xpm", "image/x-xpixmap");
        s_mapMimeTypes.put("xsl", "application/xml");
        s_mapMimeTypes.put("xslt", "application/xslt+xml");
        s_mapMimeTypes.put("xul", "application/vnd.mozilla.xul+xml");
        s_mapMimeTypes.put("xwd", "image/x-xwindowdump");
        s_mapMimeTypes.put("xyz", "chemical/x-xyz");
        s_mapMimeTypes.put("z", "application/compress");
        s_mapMimeTypes.put("zip", "application/zip");
    }
}

