/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.client.contract;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.plugins.dispatch.client.contract.condition.ContractConditionPanelFactory;
import ru.bitel.bgbilling.plugins.dispatch.client.contract.condition.base.AbstractContractConditionPanel;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ReferredModule;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.base.DispatchCondition;
import ru.bitel.common.Preferences;

public class ContractDispatchConditionsPanel
extends BGUPanel {
    private List<AbstractContractConditionPanel> panelMap = new ArrayList<AbstractContractConditionPanel>();
    private Preferences preferences;

    public ContractDispatchConditionsPanel() {
    }

    public ContractDispatchConditionsPanel(ClientContext context) {
        super(context);
    }

    protected void jbInit() {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(" \u0423\u0441\u043b\u043e\u0432\u0438\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 "));
        Dimension size = new Dimension(350, 200);
        int i = 0;
        for (AbstractContractConditionPanel value : this.panelMap) {
            this.add((Component)((Object)value), new GridBagConstraints(0, i++, 1, 1, 0.0, 0.0, 17, 2, new Insets(i == 0 ? 5 : 0, 5, 5, 5), 0, 0));
            value.setMaximumSize(size);
            value.performAction("refresh");
        }
        Component box = Box.createGlue();
        box.setSize(size);
        box.setPreferredSize(size);
        box.setMinimumSize(size);
        box.setMaximumSize(size);
        Component boxRight = Box.createGlue();
        this.add(box, new GridBagConstraints(0, i++, 1, 1, 0.0, 1.0, 10, 1, new Insets(i == 0 ? 5 : 0, 5, 5, 5), 0, 0));
        this.add(boxRight, new GridBagConstraints(1, 0, 1, i, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void loadFromDispatch(Dispatch dispatch) {
        this.panelMap.clear();
        for (DispatchCondition condition : dispatch.getConditions()) {
            ReferredModule refModule = condition.getClass().getAnnotation(ReferredModule.class);
            AbstractContractConditionPanel panel = ContractConditionPanelFactory.getPanel(condition.getClass(), (ClientContext)this.getContext(), refModule.value(), condition.getModuleId());
            if (panel == null) continue;
            this.panelMap.add(panel);
        }
        this.jbInit();
    }

    public void clear() {
        this.panelMap.clear();
        this.jbInit();
    }

    public void setPreferences(Preferences prefs) {
        this.preferences = prefs;
        for (AbstractContractConditionPanel value : this.panelMap) {
            value.load(prefs);
        }
    }

    public Preferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = new Preferences();
        }
        for (AbstractContractConditionPanel value : this.panelMap) {
            value.save(this.preferences);
        }
        return this.preferences;
    }
}

