/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.search.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import ru.bitel.bgbilling.common.dao.AbstractDao;
import ru.bitel.bgbilling.kernel.contract.search.common.ContractHistoryRecord;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.SearchResult;

public class ContractHistoryRecordDao
extends AbstractDao<ContractHistoryRecord> {
    public ContractHistoryRecordDao(Connection con) {
        super(con, 0, "contract_history_open_log");
    }

    public void searchContractHistoryRecord(SearchResult<ContractHistoryRecord> searchResult, int userId) throws SQLException {
        Objects.requireNonNull(searchResult);
        List list = searchResult.getList();
        String query = "SELECT log.*, c.title AS contract_title, c.comment AS contract_comment FROM " + this.tableName + " AS log LEFT JOIN contract AS c ON c.id=log.contract_id WHERE user_id=? AND c.title IS NOT NULL ORDER BY last_open DESC LIMIT 100";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, userId);
            try (ResultSet resultSet = ps.executeQuery();){
                while (resultSet.next()) {
                    list.add(this.getFromRS(resultSet));
                }
            }
        }
    }

    protected ContractHistoryRecord getFromRS(ResultSet rs) throws SQLException {
        return new ContractHistoryRecord().setUserId(rs.getInt("user_id")).setContractId(rs.getInt("contract_id")).setLastOpen(rs.getTimestamp("last_open")).setContractTitle(rs.getString("contract_title")).setContractComment(rs.getString("contract_comment"));
    }

    protected void updateImpl(ContractHistoryRecord contractHistoryRecord) throws SQLException {
        int index = 1;
        String query = "INSERT INTO `" + this.tableName + "` SET user_id=?, contract_id=?, last_open=? ON DUPLICATE KEY UPDATE last_open=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(index++, contractHistoryRecord.getUserId());
            ps.setInt(index++, contractHistoryRecord.getContractId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestampSeconds((Date)contractHistoryRecord.getLastOpen()));
            ps.setTimestamp(index, TimeUtils.convertDateToTimestampSeconds((Date)contractHistoryRecord.getLastOpen()));
            ps.executeUpdate();
        }
        if (ThreadLocalRandom.current().nextInt(9) == 0) {
            ps = this.con.prepareStatement("DELETE FROM `" + this.tableName + "` WHERE user_id=? AND last_open < NOW() - INTERVAL 2 MONTH");
            try {
                ps.setInt(1, contractHistoryRecord.getUserId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }
}

