/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting;

import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionCallRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.event.InetAccountingEvent;
import ru.bitel.bgbilling.apps.inet.accounting.event.InetAccountingManageEvent;
import ru.bitel.bgbilling.apps.inet.accounting.event.InetAccountingManagePoolEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.ExecutorEventWorker;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.AccountingTrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.server.util.Setup;

public class InetAccountingManageWorker
extends ExecutorEventWorker
implements Lifecycle {
    private static final Logger logger = LogManager.getLogger();
    private final Accounting accounting;

    private InetAccountingManageWorker(ExecutorEventWorker.ContractExecutorEventWorker worker, Setup setup, Accounting accounting, Class<? extends Event> clazz) throws BGException {
        super(worker, EventProcessor.getInstance(), clazz, accounting.moduleId, -1, "accountingRootDeviceId=" + accounting.rootDeviceId);
        this.accounting = accounting;
    }

    public static ExecutorEventWorker.ContractExecutorEventWorker newWorker(Setup setup, Accounting accounting, int threadCount) throws BGException {
        ExecutorEventWorker.ContractExecutorEventWorker result = new ExecutorEventWorker.ContractExecutorEventWorker(EventProcessor.getInstance(), "accntng-mng-wrkr", threadCount, 4);
        new InetAccountingManageWorker(result, setup, accounting, InetAccountingManagePoolEvent.class);
        new InetAccountingManageWorker(result, setup, accounting, InetAccountingManageEvent.class);
        return result;
    }

    public void notify(Event task, EventListenerContext context) throws BGException {
        InetAccountingManageWorker.notify(this.accounting, task, context);
    }

    public static void notify(Accounting accounting, Event task, EventListenerContext context) throws BGException {
        block9: {
            try {
                if (task instanceof InetAccountingManageEvent) {
                    InetAccountingManageEvent e = (InetAccountingManageEvent)task;
                    InetConnection connection = e.getConnection();
                    try {
                        InetAccountingManageWorker.onAccountingManage(accounting, context, e, connection);
                        break block9;
                    }
                    catch (InterruptedException ex) {
                        throw new BGException((Throwable)ex);
                    }
                }
                if (task instanceof InetAccountingManagePoolEvent) {
                    InetAccountingManagePoolEvent e = (InetAccountingManagePoolEvent)task;
                    InetConnection connection = e.getConnection();
                    assert (e.getType() == 3);
                    try {
                        InetAccountingManageWorker.onAccountingManageUpdate(accounting, connection, 8000L);
                        break block9;
                    }
                    catch (InterruptedException ex) {
                        throw new BGException((Throwable)ex);
                    }
                }
                logger.error("Unknown message " + task.getClass());
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onAccountingManage(Accounting accounting, EventListenerContext ctx, InetAccountingManageEvent e, InetConnection connection) throws BGException, InterruptedException {
        if (e.getType() == 1) {
            InetConnection existConnnection;
            if (!accounting.getDisableServIds().contains(connection.getServId()) && (existConnnection = accounting.findExistConnection(connection)) != null) {
                e.setConnection(existConnnection);
                return;
            }
            InetServRuntime inetServRuntime = accounting.inetServRuntimeMap.get(connection.getServId());
            InetConnectionCallRuntime parentAccountingSession = connection.getParentConnectionId() > 0L ? accounting.connectionMapCall.get(connection.getParentConnectionId()) : null;
            if (connection.getConnectionStart() == null) {
                connection.setConnectionStart(new Date());
            }
            if (e.getTimeout() > 0L) {
                inetServRuntime.tryLockEx(e.getTimeout() + 1000L, TimeUnit.MILLISECONDS);
                try {
                    accounting.connectionCallStart(ctx.getConnectionSet(), true, connection, null, 0L, null, null, inetServRuntime, parentAccountingSession, null);
                }
                catch (Exception ex) {
                    throw new BGException((Throwable)ex);
                }
                finally {
                    inetServRuntime.unlock();
                }
            } else {
                inetServRuntime.lock();
                try {
                    accounting.connectionCallStart(ctx.getConnectionSet(), true, connection, null, 0L, null, null, inetServRuntime, parentAccountingSession, null);
                }
                catch (Exception ex) {
                    throw new BGException((Throwable)ex);
                }
                finally {
                    inetServRuntime.unlock();
                }
            }
        } else if (e.getType() == 2) {
            Date sessionStop = connection.getConnectionStop() != null ? connection.getConnectionStop() : new Date();
            InetConnectionCallRuntime connectionRuntime = accounting.connectionMapCall.get(connection.getId());
            if (connectionRuntime == null) {
                logger.error("Connection for stop not found with id=" + connection.getId());
                return;
            }
            connectionRuntime.inetServRuntime.lock();
            try {
                ((InetConnectionRuntime)connectionRuntime).forceStop(accounting, ctx.getConnectionSet(), sessionStop.getTime(), false);
            }
            finally {
                connectionRuntime.inetServRuntime.unlock();
            }
        } else if (e.getType() == 3) {
            InetAccountingManageWorker.onAccountingManageUpdate(accounting, connection, e.getTimeout());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onAccountingManageUpdate(Accounting accounting, InetConnection connection, long timeout) throws BGException, InterruptedException {
        InetConnectionCallRuntime connectionRuntime = accounting.connectionMapCall.get(connection.getId());
        logger.debug("Accounting update: " + connection);
        if (connectionRuntime != null) {
            long millis = System.currentTimeMillis();
            connectionRuntime.inetServRuntime.tryLockEx(timeout > 0L ? timeout : 20000L, TimeUnit.MILLISECONDS);
            try {
                Long hour = InetUtils.getHour(millis);
                ((InetConnectionRuntime)connectionRuntime).trySplitSession(accounting, hour, millis);
                long lastAccountTime = System.currentTimeMillis() / 1000L;
                if (connectionRuntime.lastAccountTime < lastAccountTime) {
                    connectionRuntime.lastAccountTime = lastAccountTime;
                    connectionRuntime.updateTime(millis);
                }
            }
            finally {
                connectionRuntime.inetServRuntime.unlock();
            }
            accounting.onConnectionUpdate(connectionRuntime);
            accounting.sessionAccountingEP.publish((Event)new InetAccountingEvent(accounting.sessionAccountingEP, connectionRuntime.contractId, connectionRuntime.connection, connectionRuntime.sessionId, 3, new HashMap<Integer, AccountingTrafficAmount>(connectionRuntime.counterTraffics), new Date(millis)));
        } else {
            logger.warn("AccountingSession not found on manageUpdate with id=" + connection.getId());
        }
    }
}

