/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.datalog;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLogWriter;
import ru.bitel.bgbilling.kernel.base.server.datalog.channels.StreamReadableChannel;
import ru.bitel.bgbilling.kernel.base.server.datalog.channels.StreamWritableChannel;
import ru.bitel.bgbilling.kernel.base.server.datalog.channels.XZInputStream;
import ru.bitel.bgbilling.kernel.base.server.datalog.channels.XZOutputStream;
import ru.bitel.bgbilling.kernel.base.server.datalog.channels.ZLIBReadableChannel;
import ru.bitel.bgbilling.kernel.base.server.datalog.channels.ZLIBWritableChannel;

public class BGDataLog<D extends BGDataLog<D>>
extends DataLog<D> {
    private static final Logger log = LogManager.getLogger();
    public static final int MAGIC = Charset.forName("UTF-8").encode("BGDL").getInt();
    public static final int VERSION = 4;
    protected static final int PREFIX_LENGTH = 16;
    private static final int FINISHED_ID = 3;
    private static final int BUFFER_ID = 4;
    private static final int COMPRESSION_ID = 5;
    private static final int DISTRIBUTED_ID = 6;
    private static final int STREAMING_ID = 7;
    public static final Buffer BUFFER = new Buffer();
    public static final Finished FINISHED = new Finished(null);
    public static final Compression COMPRESSION = new Compression();
    public static final Distributed DISTRIBUTED = new Distributed();
    public static final Streaming STREAMING = new Streaming();
    protected final int id;
    protected int version;
    protected final int dataLogType;
    protected int chunkSize;
    protected boolean compressed;
    protected final ConcurrentMap<Object, Object> attributeMap = new ConcurrentHashMap<Object, Object>(8);
    protected RandomAccessFile randomAccessFile;
    protected FileChannel dataFileChannel;
    protected final AtomicInteger chunkIdSequence = new AtomicInteger(0);

    public BGDataLog(int id, File file, RandomAccessFile randomAccessFile, FileChannel fileChannel, int dataLogType) {
        super(file, randomAccessFile, fileChannel);
        this.id = id;
        if (log.isDebugEnabled()) {
            log.debug("DataLog file [" + this.getFile() + "] was opened");
        }
        this.dataLogType = dataLogType;
        Compression compression = new Compression();
        compression.type = 0;
        compression.level = 0;
        this.setParameter(COMPRESSION, compression);
        this.setParameter(FINISHED, new Finished(this));
    }

    public ConcurrentMap<Object, Object> getAttributeMap() {
        return this.attributeMap;
    }

    public int getId() {
        return this.id;
    }

    @Override
    protected void asReaderImpl() throws IOException {
        this.readHeader();
        Buffer buffer = this.getParameter(BUFFER);
        if (buffer.type == buffer.NONE) {
            this.chunkSize = 0;
        } else {
            if (buffer.size < 0 || buffer.size > Integer.MAX_VALUE) {
                throw new IOException("Bad chunk size: " + buffer.size);
            }
            this.chunkSize = buffer.size;
        }
        if (log.isDebugEnabled()) {
            log.debug("Chunk size=" + this.chunkSize);
        }
        int n = this.readBufferSize = this.chunkSize > 0 ? this.chunkSize + 4 + 8 + 4 : buffer.size;
        if (log.isDebugEnabled()) {
            log.debug("Read buffer size=" + this.readBufferSize);
        }
        FileChannel fileChannel = this.fileChannel;
        Distributed distributed = this.getParameter(DISTRIBUTED);
        if (distributed != null && distributed.value > 0) {
            File dataFile = new File(this.file.getParentFile(), this.file.getName().replaceFirst("\\.bgdl\\z", ".data"));
            this.randomAccessFile = new RandomAccessFile(dataFile, "r");
            fileChannel = this.dataFileChannel = this.randomAccessFile.getChannel();
        }
        Compression compression = this.getParameter(COMPRESSION);
        this.compressed = true;
        if (compression.type == 1) {
            this.readableByteChannel = new ZLIBReadableChannel(fileChannel, ByteBuffer.allocate(this.readBufferSize));
        } else if (compression.type == 2) {
            this.readableByteChannel = new StreamReadableChannel(fileChannel, new GZIPInputStream(Channels.newInputStream(fileChannel)));
        } else if (compression.type == 3) {
            this.readableByteChannel = new StreamReadableChannel(fileChannel, new XZInputStream(Channels.newInputStream(fileChannel)));
        } else {
            this.compressed = false;
            this.readableByteChannel = fileChannel;
        }
        this.fileChannelPosition = fileChannel.position();
        if (log.isDebugEnabled()) {
            log.debug("Compressed = " + this.compressed);
            log.debug("ChannelPosition = " + this.fileChannelPosition);
        }
    }

    @Override
    protected void readHeader() throws IOException {
        ByteBuffer readBuffer = ByteBuffer.wrap(new byte[16]);
        this.fileChannel.read(readBuffer);
        readBuffer.flip();
        if (MAGIC != readBuffer.getInt()) {
            throw new IOException("Bad header magic");
        }
        this.version = readBuffer.getInt();
        readBuffer.getInt();
        int length = readBuffer.getInt();
        if (log.isDebugEnabled()) {
            log.debug("Header: version=" + this.version + "; length=" + length);
        }
        this.headerByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, 16 + length);
        this.fileChannel.position(16 + length);
        this.headerByteBuffer.position(16);
        try {
            this.readHeaderTLV(this.headerByteBuffer);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    protected void readHeaderTLV(ByteBuffer readBuffer) throws IOException {
        while (readBuffer.remaining() > 0) {
            int type = readBuffer.getInt();
            int length = readBuffer.getInt();
            if (log.isDebugEnabled()) {
                log.debug("Read TLV [type=" + type + ", length=" + length + ", rem=" + readBuffer.remaining() + "]");
            }
            this.readTLV(type, length, readBuffer);
        }
    }

    protected boolean readTLV(int type, int length, ByteBuffer readBuffer) throws IOException {
        switch (type) {
            case 5: {
                Compression compression = new Compression();
                this.readParameter(readBuffer, COMPRESSION, compression, length);
                this.setParameter(COMPRESSION, compression);
                break;
            }
            case 4: {
                Buffer buffer = new Buffer();
                this.readParameter(readBuffer, BUFFER, buffer, length);
                this.setParameter(BUFFER, buffer);
                break;
            }
            case 3: {
                Finished finished = new Finished(null);
                this.readParameter(readBuffer, FINISHED, finished, length);
                this.setParameter(FINISHED, finished);
                break;
            }
            case 6: {
                Distributed distributed = new Distributed();
                this.readParameter(readBuffer, DISTRIBUTED, distributed, length);
                this.setParameter(DISTRIBUTED, distributed);
                break;
            }
            case 7: {
                Streaming streaming = new Streaming();
                this.readParameter(readBuffer, STREAMING, streaming, length);
                this.setParameter(STREAMING, streaming);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void closeImpl() throws IOException {
        try {
            if (this.dataFileChannel != null && this.dataFileChannel.isOpen()) {
                this.dataFileChannel.force(true);
            }
        }
        catch (Throwable t) {
            log.error(this.file + ": " + t.getMessage(), t);
        }
        try {
            if (this.randomAccessFile != null) {
                this.randomAccessFile.close();
            }
        }
        catch (Throwable t) {
            log.error(this.file + ": " + t.getMessage(), t);
        }
    }

    @Override
    protected <K> void writeParameter(ByteBuffer byteBuffer, DataLog.Parameter<K> parameter) {
        if (parameter instanceof DataLog.ParameterUShort) {
            throw new IllegalArgumentException("short not compatible with XDR");
        }
        super.writeParameter(byteBuffer, parameter);
    }

    @Override
    protected void asWriterImpl() throws IOException {
        if (this.inited) {
            throw new IllegalStateException();
        }
        this.writeHeader();
        Buffer buffer = this.getParameter(BUFFER);
        if (buffer.type == buffer.NONE) {
            this.chunkSize = 0;
            this.writeBufferSize = buffer.size;
        } else {
            this.chunkSize = buffer.size;
            if (this.chunkSize < 0 || this.chunkSize > Integer.MAX_VALUE) {
                throw new IOException("Bad chunk size: " + this.chunkSize);
            }
            int newChunkSize = this.chunkSize - this.chunkSize % 4;
            if (newChunkSize != this.chunkSize) {
                buffer.size = newChunkSize;
                log.debug("Make chunk size multiple of four: " + this.chunkSize + "-" + newChunkSize);
                this.chunkSize = newChunkSize;
            }
            this.writeBufferSize = this.chunkSize + 4 + 8 + 4;
        }
        FileChannel channel = this.fileChannel;
        Distributed distributed = this.getParameter(DISTRIBUTED);
        if (distributed != null && distributed.value > 0) {
            File dataFile = new File(this.file.getParentFile(), this.file.getName().replaceFirst("\\.bgdl\\z", ".data"));
            this.randomAccessFile = new RandomAccessFile(dataFile, "rw");
            channel = this.dataFileChannel = this.randomAccessFile.getChannel();
        }
        Compression compression = this.getParameter(COMPRESSION);
        if (compression.type == 1) {
            this.compressed = true;
            this.writableByteChannel = new ZLIBWritableChannel(channel, ByteBuffer.allocate(this.writeBufferSize), compression.level, 0);
        } else if (compression.type == 2) {
            this.compressed = true;
            this.writableByteChannel = new StreamWritableChannel(channel, new GZIPOutputStream(Channels.newOutputStream(channel), this.writeBufferSize));
        } else if (compression.type == 3) {
            this.compressed = true;
            this.writableByteChannel = new StreamWritableChannel(channel, new XZOutputStream(Channels.newOutputStream(channel), compression.level, compression.strategy));
        } else {
            this.compressed = false;
            this.writableByteChannel = channel;
        }
        this.fileChannelPosition = channel.position();
        this.inited = true;
    }

    @Override
    protected void writeHeader() throws IOException {
        ByteBuffer writeBuffer = ByteBuffer.wrap(new byte[64000]);
        this.writableByteChannel = this.fileChannel;
        writeBuffer.putInt(MAGIC);
        writeBuffer.putInt(4);
        writeBuffer.putInt(this.dataLogType);
        writeBuffer.putInt(0);
        ArrayList paramList = new ArrayList(this.parameterMap.keySet());
        Collections.sort(paramList);
        try {
            for (DataLog.Parameter param : paramList) {
                this.writeParameter(writeBuffer, param);
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        int headerLength = writeBuffer.position() - 16;
        log.debug("Header length=" + headerLength);
        writeBuffer.putInt(12, headerLength);
        writeBuffer.flip();
        this.writableByteChannel.write(writeBuffer);
        this.fileChannel.force(true);
        this.headerByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 16 + headerLength);
        writeBuffer.rewind();
        this.headerByteBuffer.put(writeBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (!this.inited) {
                throw new IllegalStateException();
            }
            if (this.writableByteChannel != null) {
                try {
                    for (DataLogWriter w : this.writerList) {
                        w.flush();
                    }
                }
                catch (Throwable t) {
                    log.error(this.file + ": " + t.getMessage(), t);
                }
                try {
                    Finished finished = this.getParameter(FINISHED);
                    finished.set((byte)1);
                    this.headerByteBuffer.force();
                }
                catch (Throwable t) {
                    log.error(this.file + ": " + t.getMessage(), t);
                }
                try {
                    if (this.writableByteChannel.isOpen()) {
                        this.writableByteChannel.close();
                    }
                }
                catch (Throwable t) {
                    log.error(this.file + ": " + t.getMessage(), t);
                }
            }
            if (this.readableByteChannel != null) {
                try {
                    if (this.readableByteChannel.isOpen()) {
                        this.readableByteChannel.close();
                    }
                }
                catch (Throwable t) {
                    log.error(this.file + ": " + t.getMessage(), t);
                }
            }
            this.headerByteBuffer = null;
            super.close();
        }
        finally {
            lock.unlock();
        }
    }

    public static class Compression
    extends DataLog.Parameter<Compression> {
        public static final int NONE = 0;
        public static final int ZLIB = 1;
        public static final int GZIP = 2;
        public static final int XZ = 3;
        public int type = 0;
        public int level = 0;
        public int strategy = 0;

        public Compression() {
            super(5, "compression", Compression.class);
        }

        @Override
        protected void write(Compression c, ByteBuffer writeBuffer) {
            if (c.type >= 0) {
                writeBuffer.putInt(c.id);
                writeBuffer.putInt(3);
                writeBuffer.put((byte)c.type);
                writeBuffer.put((byte)c.level);
                writeBuffer.put((byte)c.strategy);
            }
        }

        @Override
        protected Compression read(Compression c, ByteBuffer byteBuffer, int length) {
            c.type = byteBuffer.get() & 0xFF;
            c.level = byteBuffer.get() & 0xFF;
            c.strategy = byteBuffer.get() & 0xFF;
            return c;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(50);
            result.append("type=");
            switch (this.type) {
                case 0: {
                    result.append("none");
                    break;
                }
                case 1: {
                    result.append("zlib");
                    break;
                }
                case 2: {
                    result.append("gzip");
                    break;
                }
                default: {
                    result.append(this.type);
                }
            }
            result.append(", level=").append(this.level);
            result.append(", strategy=").append(this.strategy);
            return result.toString();
        }
    }

    public static class Finished
    extends DataLog.Parameter<Finished> {
        private byte value;
        private int pos = 0;
        private BGDataLog<?> dataLog;

        public Finished(BGDataLog<?> dataLog) {
            super(3, "finished", Finished.class);
            this.dataLog = dataLog;
        }

        @Override
        protected void write(Finished k, ByteBuffer writeBuffer) {
            writeBuffer.putInt(this.id);
            writeBuffer.putInt(1);
            k.pos = writeBuffer.position();
            writeBuffer.put(k.value);
        }

        @Override
        protected Finished read(Finished k, ByteBuffer readBuffer, int length) {
            k.value = readBuffer.get();
            return k;
        }

        public void set(byte value) {
            this.value = value;
            if (this.dataLog != null) {
                this.dataLog.headerByteBuffer.put(this.pos, value);
            }
        }

        public byte get() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static class Buffer
    extends DataLog.Parameter<Buffer> {
        public final int NONE = 0;
        public final int CHUNKED = 1;
        public int type = 0;
        public int size = 0;

        public Buffer() {
            super(4, "buffer", Buffer.class);
        }

        @Override
        protected void write(Buffer c, ByteBuffer writeBuffer) {
            if (c.type >= 0) {
                writeBuffer.putInt(c.id);
                writeBuffer.putInt(5);
                writeBuffer.put((byte)c.type);
                writeBuffer.putInt(c.size);
            }
        }

        @Override
        protected Buffer read(Buffer c, ByteBuffer byteBuffer, int length) {
            c.type = byteBuffer.get() & 0xFF;
            c.size = byteBuffer.getInt();
            return c;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(50);
            result.append("type=");
            switch (this.type) {
                case 0: {
                    result.append("none");
                    break;
                }
                case 1: {
                    result.append("chunked");
                    break;
                }
                default: {
                    result.append(this.type);
                }
            }
            result.append(", size=").append(this.size);
            return result.toString();
        }
    }

    public static class Distributed
    extends DataLog.Parameter<Distributed> {
        public byte value = 1;

        public Distributed() {
            super(6, "distributed", Distributed.class);
        }

        @Override
        protected void write(Distributed k, ByteBuffer writeBuffer) {
            writeBuffer.putInt(this.id);
            writeBuffer.putInt(1);
            writeBuffer.put(k.value);
        }

        @Override
        protected Distributed read(Distributed k, ByteBuffer readBuffer, int length) {
            k.value = readBuffer.get();
            return k;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static class Streaming
    extends DataLog.Parameter<Streaming> {
        public byte value = 1;

        public Streaming() {
            super(7, "streaming", Streaming.class);
        }

        @Override
        protected void write(Streaming k, ByteBuffer writeBuffer) {
            writeBuffer.putInt(this.id);
            writeBuffer.putInt(1);
            writeBuffer.put(k.value);
        }

        @Override
        protected Streaming read(Streaming k, ByteBuffer readBuffer, int length) {
            k.value = readBuffer.get();
            return k;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

