/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.client;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractEditor;
import ru.bitel.bgbilling.modules.softline.client.SoftLineSubscriptionPanel;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineProduct;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscription;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscriptionStatus;
import ru.bitel.bgbilling.modules.softline.common.service.SoftLineProductService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.table.BGTableModel;

public class SoftLineSubscriptionMonitor
extends SoftLineSubscriptionPanel {
    private List<SoftLineProduct> products = new ArrayList<SoftLineProduct>();

    public SoftLineSubscriptionMonitor() {
        this.tableModel = new SoftLineSubscriptionTableModel(SoftLineSubscriptionMonitor.class.getName());
        try {
            this.products.addAll(((SoftLineProductService)((ClientContext)this.getContext()).getPort(SoftLineProductService.class)).getProducts(null).getList());
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    @Override
    protected void jbInit() throws Exception {
        super.jbInit();
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SoftLineSubscription subscription;
                if (e.getClickCount() == 2 && e.getButton() == 1 && (subscription = (SoftLineSubscription)SoftLineSubscriptionMonitor.this.tableModel.getSelectedRow()) != null) {
                    BGClientBase.getFrame().getTabbedPane().addTab((BGTabPanel)new ContractEditor(subscription.getContractId()));
                }
            }
        });
    }

    private class SoftLineSubscriptionTableModel
    extends BGTableModel<SoftLineSubscription> {
        SoftLineSubscriptionTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", -1, 150, -1, "contractId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430", -1, 200, -1, "startDate", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f", -1, 200, -1, "endDate", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u0430", -1, 200, -1, "lastModifyDate", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0440\u043e\u0434\u0443\u043a\u0442", -1, 400, -1, "productTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, 200, -1, "status", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438", -1, 350, -1, "suspendReason", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(SoftLineSubscription sub, int column) throws Exception {
            switch (column) {
                case 2: {
                    return TimeUtils.formatFullDate((Date)sub.getStartDate());
                }
                case 3: {
                    return TimeUtils.formatFullDate((Date)sub.getEndDate());
                }
                case 4: {
                    return TimeUtils.formatFullDate((Date)sub.getLastModifyDate());
                }
                case 5: {
                    return SoftLineSubscriptionMonitor.this.products.stream().filter(p -> p.getId() == sub.getProductId()).findFirst().get().getTitle();
                }
                case 6: {
                    return SoftLineSubscriptionStatus.getDescription((int)sub.getStatus());
                }
                case 7: {
                    return sub.getSuspendReason() == null ? "" : sub.getSuspendReason().getDescription();
                }
            }
            return super.getValue((Object)sub, column);
        }
    }
}

