/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sberbank.server.action.web;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.contract.bean.Contract;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDateTime;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.BGSbpQrUtils;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.ContractAutopaymentManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.sberbank.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.sberbank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.sberbank.server.bean.Constants;
import ru.bitel.bgbilling.modules.sberbank.server.bean.OAuthToken;
import ru.bitel.bgbilling.modules.sberbank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.sberbank.server.event.SberbankCheckEvent;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebAction(title="\u0421\u0431\u0435\u0440\u0431\u0430\u043d\u043a")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("sberbank");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.paymentForm(this.moduleName, Constants.class, AutopaymentManager.class);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchParam searchParam = SearchParam.builder().setContractId(this.contractId).setStatus(this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL)).build();
        SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"transactionDatetime:1", "createDatetime:1"});
        new TransactionManager(this.con, this.moduleId).searchTransaction(searchResult, searchParam);
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432")
    public void check() throws Exception {
        EventProcessor.getInstance().publish((Event)new SberbankCheckEvent(this.moduleId, this.contractId, false));
        this.execute();
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        try (Connection con = this.setup.getDBConnection(true);){
            boolean sbp;
            TransactionManager transactionManager = new TransactionManager(con, this.moduleId);
            boolean bl = sbp = this.moduleSetup.getBoolean("sberbank.sbp.enable", false) && this.req.getBoolean("sbp", false);
            if (sbp) {
                OAuthToken oAuthToken = transactionManager.getOAuthToken(this.moduleSetup.get("sberbank.auth.token.scope.create", "https://api.sberbank.ru/qr/order.create"));
                if (oAuthToken == null) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0442\u043e\u043a\u0435\u043d\u0430");
                }
                String qrUrl = transactionManager.sbpOrderCreation(oAuthToken.getAccessToken(), this.contractId, this.sum);
                if (qrUrl == null) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 QR \u043a\u043e\u0434\u0430");
                }
                this.setResultParam("formUrl", qrUrl);
                this.setResultParam("qrImgData", BGSbpQrUtils.getSbpQR((String)qrUrl));
                String userAgent = this.context.getRequest().getHeader("User-Agent");
                this.setResultParam("android", BGSbpQrUtils.isAndroid((String)userAgent));
                this.setResultParam("apple", BGSbpQrUtils.isApple((String)userAgent));
                this.requestDispatcher("include", "payment_sbp");
            } else {
                ContractUtils.savePaymentPhone((Connection)con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("payment.phone"));
                transactionManager.registerOrder(this.contractId, ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getTitle(), this.customerAddress, this.sum, this.getResult(), false, false, "");
                this.doRedirect();
            }
        }
    }

    @WebOperation(title="\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436")
    public void autopayment() throws Exception {
        int mode;
        super.autopayment();
        boolean autopaymentEnable = this.moduleSetup.getBoolean("sberbank.autopayment.enable", false);
        if (autopaymentEnable && ContractAutopaymentManager.isContractAutopaymentEnabled((Connection)this.con, (int)this.moduleId, (int)this.contractId) && (mode = this.req.getInt("mode", 0)) > -1 && mode < 4) {
            Preferences modeDataMap;
            String customerAddress = ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
            AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);
            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(this.contractId);
            if (autopayment != null) {
                if (autopayment.getMode() != AutopaymentMode.OFF) {
                    autopaymentManager.autopaymentOff(autopayment);
                }
                if (mode != autopayment.getMode().getCode()) {
                    autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                    autopaymentManager.updateAutopayment(autopayment);
                    autopayment = null;
                }
            }
            if (autopayment == null) {
                autopayment = Autopayment.builder().setContractId(this.contractId).build();
            }
            TransactionManager transactionManager = new TransactionManager(this.setup.getDBConnection(true), this.moduleId);
            String contractTitle = ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getTitle();
            Preferences preferences = modeDataMap = autopayment.getModeData() != null ? new Preferences(autopayment.getModeData(), "\n") : new Preferences();
            if (mode == AutopaymentMode.OFF.getCode()) {
                autopayment.setMode(AutopaymentMode.OFF);
                autopayment.setSum(BigDecimal.ZERO);
                autopayment.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
                autopayment.setAccessToken(null);
            } else if (mode == AutopaymentMode.WEEK.getCode()) {
                this.autopaymentWeek("SBERBANK", modeDataMap, autopayment, Constants.class);
                transactionManager.registerOrder(this.contractId, contractTitle, customerAddress, autopayment.getSum(), this.getResult(), false, true, "");
            } else if (mode == AutopaymentMode.MONTH.getCode()) {
                this.autopaymentMonth("SBERBANK", modeDataMap, autopayment, Constants.class);
                transactionManager.registerOrder(this.contractId, contractTitle, customerAddress, autopayment.getSum(), this.getResult(), false, true, "");
            } else if (mode == AutopaymentMode.AUTO.getCode()) {
                this.autopaymentAuto("SBERBANK", modeDataMap, autopayment, Constants.class);
                transactionManager.registerOrder(this.contractId, contractTitle, customerAddress, autopayment.getSum(), this.getResult(), false, true, "");
            }
            autopayment.setModeData(modeDataMap.toString());
            autopaymentManager.updateAutopayment(autopayment);
            if (autopayment.getMode().getCode() != AutopaymentMode.OFF.getCode()) {
                this.doRedirect();
            } else {
                this.execute();
            }
        }
    }

    protected void doRedirect() throws Exception {
        Object formUrl = this.getResultParam("formUrl");
        if (formUrl != null) {
            try {
                this.setResultParam("contentType", ActionResultContentType.binary);
                this.context.getResponse().sendRedirect(String.valueOf(formUrl));
                return;
            }
            catch (IOException ex) {
                this.execute();
                throw new BGMessageException(ex.getMessage());
            }
        }
        this.execute();
        throw new BGMessageException(this.getResultParam("errorMessage") + " [errorCode=" + this.getResultParam("errorCode") + "]");
    }
}

