/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event;

import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.MessageAdapter;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;

abstract class AbstractConsumer
extends MessageAdapter
implements MessageListener,
EventListener<Event> {
    protected final EventProcessor eventProcessor;
    protected final String applicationName;
    final int moduleId;
    final int pluginId;
    final String query;
    final boolean noLocal;
    private final Object listenersMutex = new Object();
    private volatile ArrayList<EventListener<? super Event>> listeners = new ArrayList();
    final boolean topic;
    final String destination;
    final MessageConsumer mc;
    private final MessageProducer replyProducer;
    protected final EventListenerContext eventListenerContext;
    public final boolean localSession;

    public AbstractConsumer(EventProcessor eventProcessor, Session session, int moduleId, int pluginId, String destination, String query, boolean queue, boolean noLocal, int deliveryMode, int priority, long timeToLive, boolean localSession, Class<?> ... clazz) throws JMSException, JAXBException {
        super(session, deliveryMode, priority, timeToLive, clazz);
        this.eventProcessor = eventProcessor;
        this.applicationName = eventProcessor.applicationName;
        this.eventListenerContext = new EventListenerContext(eventProcessor.setup, 0, eventProcessor.applicationName);
        this.eventListenerContext.init();
        this.moduleId = moduleId;
        this.pluginId = pluginId;
        this.query = query;
        this.noLocal = noLocal;
        this.destination = destination;
        if (queue) {
            this.topic = false;
            this.mc = this.createConsumer(destination, query, noLocal, false);
        } else {
            this.topic = true;
            this.mc = this.createConsumer(destination, query, noLocal, true);
        }
        if (!this.topic) {
            this.replyProducer = session.createProducer(null);
            this.replyProducer.setDeliveryMode(deliveryMode);
            this.replyProducer.setPriority(priority);
        } else {
            this.replyProducer = null;
        }
        this.localSession = localSession;
    }

    public AbstractConsumer(EventProcessor eventProcessor, Session session, Class<? extends Event> clazz, EventType type, int moduleId, int pluginId, String destination, String query, boolean setMessageListener, boolean localSession) throws JMSException, JAXBException {
        super(session, clazz);
        this.eventProcessor = eventProcessor;
        this.applicationName = eventProcessor.applicationName;
        this.eventListenerContext = new EventListenerContext(eventProcessor.setup, 0, eventProcessor.applicationName);
        this.eventListenerContext.init();
        boolean noLocal = type != null && type.noLocal();
        this.moduleId = moduleId;
        this.pluginId = pluginId;
        this.query = query;
        this.noLocal = noLocal;
        this.destination = destination;
        if (QueueEvent.class.isAssignableFrom(clazz)) {
            this.topic = false;
            this.mc = this.createConsumer(destination, query, noLocal, false);
        } else {
            this.topic = true;
            this.mc = this.createConsumer(destination, query, noLocal, true);
        }
        if (setMessageListener) {
            this.mc.setMessageListener((MessageListener)this);
        }
        if (!this.topic) {
            this.replyProducer = session.createProducer(null);
            this.replyProducer.setDeliveryMode(this.deliveryMode);
            this.replyProducer.setPriority(this.priority);
        } else {
            this.replyProducer = null;
        }
        this.localSession = localSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int listenersCount() {
        Object object = this.listenersMutex;
        synchronized (object) {
            return this.listeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean listenerUpdate(EventListener<? super Event> l) {
        Object object = this.listenersMutex;
        synchronized (object) {
            ArrayList<EventListener<? super Event>> listeners = this.listeners;
            int index = listeners.indexOf(l);
            if (index >= 0) {
                ArrayList<EventListener<? super Event>> newListeners = new ArrayList<EventListener<? super Event>>(listeners);
                newListeners.set(index, l);
                this.listeners = newListeners;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void listenerAdd(EventListener<? super Event> l) {
        Object object = this.listenersMutex;
        synchronized (object) {
            ArrayList<EventListener<? super Event>> listeners = this.listeners;
            ArrayList<EventListener<? super Event>> newListeners = new ArrayList<EventListener<? super Event>>(listeners.size());
            newListeners.addAll(listeners);
            newListeners.add(l);
            this.listeners = newListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean listenerRemove(EventListener<?> l) {
        Object object = this.listenersMutex;
        synchronized (object) {
            ArrayList<EventListener<? super Event>> listeners = this.listeners;
            ArrayList<EventListener<? super Event>> newListeners = new ArrayList<EventListener<? super Event>>(listeners);
            boolean result = newListeners.remove(l);
            this.listeners = newListeners;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void listenerAddFirst(EventListener<? super Event> l) {
        Object object = this.listenersMutex;
        synchronized (object) {
            ArrayList<EventListener<? super Event>> listeners = this.listeners;
            ArrayList<EventListener<? super Event>> newListeners = new ArrayList<EventListener<? super Event>>(listeners.size());
            newListeners.add(l);
            newListeners.addAll(listeners);
            this.listeners = newListeners;
        }
    }

    protected MessageConsumer createConsumer(String destination, String query, boolean noLocal, boolean topic) throws JMSException {
        if (topic) {
            this.getLogger().info("MQ createConsumer(Topic) [destination=" + destination + "; query=" + query + "; noLocal=" + noLocal);
            return this.session.createConsumer((Destination)this.session.createTopic(destination), query, noLocal);
        }
        this.getLogger().info("MQ createConsumer(Queue) [destination=" + destination + "; query=" + query + "; noLocal=" + noLocal);
        return this.session.createConsumer((Destination)this.session.createQueue(destination), query, noLocal);
    }

    protected final void trySendReply(Message message, Event e, Exception ex) throws JMSException, JAXBException {
        Destination jmsReplyTo;
        if (e instanceof QueueEvent && (jmsReplyTo = message.getJMSReplyTo()) != null) {
            long expire;
            Message response = this.createMessage(e);
            response.setJMSCorrelationID(message.getJMSCorrelationID());
            response.setStringProperty("bg:app", this.applicationName);
            if (ex != null) {
                response.setStringProperty("bg:ex", ex.getClass().getName());
                response.setStringProperty("bg:ex.message", ex.getMessage());
            }
            if ((expire = message.getJMSExpiration()) > 0L) {
                this.replyProducer.send(jmsReplyTo, response, this.deliveryMode, this.priority, Math.max(expire - message.getJMSTimestamp(), 0L) + 10000L);
            } else {
                this.replyProducer.send(jmsReplyTo, response, this.deliveryMode, this.priority, 0L);
            }
        }
    }

    public void close() throws JMSException {
        this.mc.close();
        this.eventListenerContext.destroy();
    }

    public void destroy() throws JMSException {
        if (this.replyProducer != null) {
            this.replyProducer.close();
        }
    }

    public <E extends Event> E receive() throws BGException {
        try {
            Message message = this.mc.receive();
            return (E)((Event)this.parseMessage(message));
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public <E extends Event> E receive(long timeout) throws BGException {
        try {
            Message message = this.mc.receive(timeout);
            if (message != null) {
                return (E)((Event)this.parseMessage(message));
            }
            return null;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public <E extends Event> E receiveNoWait() throws BGException {
        try {
            Message message = this.mc.receiveNoWait();
            if (message != null) {
                return (E)((Event)this.parseMessage(message));
            }
            return null;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    @Override
    public void notify(Event e, EventListenerContext ctx) throws Exception {
        ArrayList<EventListener<? super Event>> listeners = this.listeners;
        int size = listeners.size();
        for (int i = 0; i < size; ++i) {
            listeners.get(i).notify(e, ctx);
        }
    }

    protected abstract boolean onMessage0(Message var1, EventListenerContext var2, EventListener<Event> var3) throws JMSException, JAXBException, BGException;
}

