/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.common.event.access;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.tv.common.event.access.db.TvProductsDeviceStateModifyEvent;
import ru.bitel.oss.systems.inventory.product.common.event.ProductStateEntry;

@XmlRootElement
public class TvProductsDeviceStateModifiedEvent
extends Event {
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final int tvAccountId;
    @XmlAttribute
    private final short deviceState;
    @XmlElementWrapper(name="productEntryList")
    @XmlElements(value={@XmlElement(name="entry")})
    private final List<ProductStateEntry> productEntryList;

    protected TvProductsDeviceStateModifiedEvent() {
        this.deviceId = -1;
        this.tvAccountId = -1;
        this.deviceState = (short)-1;
        this.productEntryList = null;
    }

    public TvProductsDeviceStateModifiedEvent(TvProductsDeviceStateModifyEvent modify) {
        super(modify.getModuleId(), modify.getContractId(), modify.getUserId());
        this.deviceId = modify.getDeviceId();
        this.tvAccountId = modify.getTvAccountId();
        this.deviceState = modify.getDeviceState();
        this.productEntryList = modify.getProductEntryList();
    }

    @Deprecated
    public TvProductsDeviceStateModifiedEvent(int moduleId, int deviceId, int tvAccountId, short deviceState, List<ProductStateEntry> productEntryList) {
        super(moduleId, CONTRACT_GLOBAL, -1);
        this.deviceId = deviceId;
        this.tvAccountId = tvAccountId;
        this.deviceState = deviceState;
        this.productEntryList = productEntryList;
    }

    public TvProductsDeviceStateModifiedEvent(int moduleId, int contractId, int deviceId, int tvAccountId, short deviceState, List<ProductStateEntry> productEntryList) {
        super(moduleId, contractId, -1);
        this.deviceId = deviceId;
        this.tvAccountId = tvAccountId;
        this.deviceState = deviceState;
        this.productEntryList = productEntryList;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getTvAccountId() {
        return this.tvAccountId;
    }

    public short getDeviceState() {
        return this.deviceState;
    }

    public List<ProductStateEntry> getProductEntryList() {
        return this.productEntryList;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; deviceId: ");
        sb.append(this.deviceId);
        sb.append("; tvAccountId: ");
        sb.append(this.tvAccountId);
        sb.append("; state: ");
        sb.append(this.deviceState);
        sb.append("; productEntryList: ");
        sb.append(this.productEntryList);
    }
}

