/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tinkoff.server.bean;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.BGTransactionType;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.tinkoff.common.bean.Transaction;
import ru.bitel.bgbilling.modules.tinkoff.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.tinkoff.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.tinkoff.server.bean.Status;
import ru.bitel.bgbilling.modules.tinkoff.server.event.TinkoffAutopaymentSumEvent;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "tinkoff_transaction");
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("status", "status");
        this.fields.put("createDatetime", "create_date");
        this.fields.put("transactionDatetime", "transaction_date");
        this.fields.put("sum", "sum");
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("id"))).setContractId(rs.getInt("contract_id"))).setContractTitle(rs.getString("contract_title"))).setPaymentId(rs.getInt("payment_id"))).setCreateDate((Date)rs.getTimestamp("create_date"))).setTransactionId(rs.getString("order_id"))).setTransactionDate((Date)rs.getTimestamp("transaction_date"))).setStatus(rs.getString("status"))).setParameters(rs.getString("params"))).setSum(rs.getBigDecimal("sum"))).setAutopayment(rs.getBoolean("autopayment"))).build();
    }

    protected String getQueryById() {
        return "SELECT pt.*, c.title AS contract_title FROM " + this.tableName + " AS pt LEFT JOIN contract AS c ON c.id=pt.contract_id WHERE pt.id=?";
    }

    public boolean update(Transaction transaction, TransactionStatus newTransactionStatus) throws SQLException {
        Objects.requireNonNull(transaction);
        Objects.requireNonNull(newTransactionStatus);
        boolean result = false;
        StringBuilder query = new StringBuilder("UPDATE ").append(this.tableName).append(" SET ").append("status=?").append(" WHERE ").append("status=? AND id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
            int index = 1;
            ps.setString(index++, newTransactionStatus.getCode());
            ps.setString(index++, transaction.getStatus());
            ps.setInt(index++, transaction.getId());
            boolean bl = result = ps.executeUpdate() > 0;
            if (result) {
                transaction.setStatus(newTransactionStatus.getCode());
            }
        }
        return result;
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "contract_id=?, payment_id=?, create_date=?, transaction_date=?, order_id=?, status=?, params=?, sum=?, autopayment=?";
        try (PreparedStatement ps = this.prepareStatement((Id)transaction, querySet);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setInt(index++, transaction.getPaymentId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            ps.setString(index++, transaction.getTransactionId());
            ps.setString(index++, transaction.getStatus());
            ps.setString(index++, transaction.getParameters());
            ps.setBigDecimal(index++, transaction.getSum());
            ps.setBoolean(index++, transaction.isAutopayment());
            this.executeUpdate((Id)transaction, index, ps);
        }
    }

    public void doResend() throws BGException {
        JSONObject requestJsonObject = new JSONObject();
        requestJsonObject.put("TerminalKey", (Object)this.moduleSetup.get("tinkoff.terminal.key", ""));
        requestJsonObject.put("Token", (Object)this.getToken(requestJsonObject, this.moduleSetup.get("tinkoff.terminal.pswd", "")).toLowerCase());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441 Resend: " + requestJsonObject.toString());
        }
        StringBuilder resultJson = null;
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("Content-Type", "application/json; charset=UTF-8");
            resultJson = this.doConnection(this.moduleSetup.get("tinkoff.resend.url", "https://securepay.tinkoff.ru/v2/Resend"), "POST", true, requestJsonObject.toString(), props);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\t\u041e\u0442\u0432\u0435\u0442 Resend: " + String.valueOf(resultJson));
            }
        }
        catch (Exception ex) {
            this.getLogger().error(ex.getMessage());
        }
    }

    public void doCheckRequest(int contractId, boolean autopaymentTransaction) throws Exception {
        this.getLogger().debug("doCheckRequest");
        Page page = new Page(1, 25);
        String[] sort = new String[]{"createDate:1"};
        SearchParam searchParam = SearchParam.builder().setContractId(contractId).setStatus(TransactionStatus.NEW.getCode()).setAutopayment(Boolean.valueOf(autopaymentTransaction)).build();
        SearchResult searchResult = new SearchResult(page, sort);
        this.searchTransaction(searchResult, searchParam);
        for (Transaction transaction : searchResult.getList()) {
            String orderId = transaction.getTransactionId();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("tinkoffTransactionId = " + transaction.getId());
                this.getLogger().debug("tinkoffTransactionOrderId = " + orderId);
            }
            if (orderId == null) {
                transaction.setStatus(TransactionStatus.ERROR.getCode());
                this.update(transaction);
                continue;
            }
            JSONObject requestJsonObject = new JSONObject();
            requestJsonObject.put("TerminalKey", (Object)this.moduleSetup.get("tinkoff.terminal.key", ""));
            requestJsonObject.put("PaymentId", Utils.parseLong((String)orderId));
            requestJsonObject.put("Token", (Object)this.getToken(requestJsonObject, this.moduleSetup.get("tinkoff.terminal.pswd", "")).toLowerCase());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: " + requestJsonObject.toString());
            }
            StringBuilder resultJson = null;
            try {
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("Content-Type", "application/json; charset=UTF-8");
                resultJson = this.doConnection(this.moduleSetup.get("tinkoff.rest.get.state.url", "https://securepay.tinkoff.ru/v2/GetState"), "POST", true, requestJsonObject.toString(), props);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\t\u041e\u0442\u0432\u0435\u0442: " + String.valueOf(resultJson));
                }
            }
            catch (Exception ex) {
                this.getLogger().error(ex.getMessage());
            }
            boolean error = false;
            JSONObject resultJsonObject = null;
            if (resultJson != null) {
                resultJsonObject = new JSONObject(resultJson.toString());
                error = this.check(transaction, resultJsonObject);
            }
            if (!error) continue;
            transaction.setStatus(TransactionStatus.ERROR.getCode());
            transaction.setTransactionDate(new Date());
            TransactionManager.addTransactionParameters(transaction, TransactionManager.getParamString((JSONObject)resultJsonObject));
            this.update(transaction);
        }
    }

    public boolean check(Transaction transaction, JSONObject resultJsonObject) throws Exception {
        boolean error;
        block26: {
            block25: {
                String orderStatus;
                block27: {
                    error = false;
                    String errorCode = resultJsonObject.optString("ErrorCode", null);
                    if (errorCode != null && !"0".equals(errorCode)) break block25;
                    orderStatus = resultJsonObject.optString("Status", null);
                    if (orderStatus == null || Status.AUTHORIZED.getCode().equals(orderStatus) || Status.PARTIAL_REFUNDED.getCode().equals(orderStatus)) break block26;
                    if (!Status.REJECTED.getCode().equals(orderStatus)) break block27;
                    if (!transaction.getStatus().equals(TransactionStatus.NEW.getCode())) {
                        this.getLogger().error("Transaction for ID = " + transaction.getId() + " has status != 'new'");
                    } else if (transaction.getPaymentId() > 0) {
                        this.getLogger().error("Transaction for ID = " + transaction.getId() + " has paymentId > 0");
                    } else {
                        transaction.setStatus(TransactionStatus.ERROR.getCode());
                        this.update(transaction);
                    }
                    break block26;
                }
                if (Status.FORM_SHOWED.getCode().equals(orderStatus)) break block26;
                if (Status.CONFIRMED.getCode().equals(orderStatus)) {
                    if (!transaction.getStatus().equals(TransactionStatus.NEW.getCode())) {
                        this.getLogger().error("Transaction for ID = " + transaction.getId() + " has status != 'new'");
                    } else if (transaction.getPaymentId() > 0) {
                        this.getLogger().error("Transaction for ID = " + transaction.getId() + " has paymentId > 0");
                    } else {
                        PeriodWithTime period;
                        AutopaymentManager autopaymentManager;
                        Autopayment autopayment;
                        this.addTransactionPayment(transaction, TransactionManager.getParamString((JSONObject)resultJsonObject));
                        int rebillId = resultJsonObject.optInt("RebillId");
                        if (rebillId > 0 && (autopayment = (autopaymentManager = new AutopaymentManager(this.con, this.moduleId)).getCurrentAutopayment(transaction.getContractId())) != null && (period = autopayment.getPeriod()) != null && period.getDateFrom() == null) {
                            period.setLocalDateTimeFrom(LocalDateTime.now());
                            autopayment.setAccessToken(String.valueOf(rebillId));
                            autopaymentManager.updateAutopayment(autopayment);
                        }
                    }
                } else if (Status.REVERSED.getCode().equals(orderStatus) || Status.REFUNDED.getCode().equals(orderStatus)) {
                    if (!transaction.getStatus().equals(TransactionStatus.APPROVED.getCode())) {
                        this.getLogger().error("Transaction for ID = " + transaction.getId() + " has status != 'ok'");
                        error = true;
                    } else if (transaction.getPaymentId() < 1) {
                        this.getLogger().error("Transaction for ID = " + transaction.getId() + " has paymentId < 1");
                        error = true;
                    } else {
                        PaymentDao paymentDao = new PaymentDao(this.con);
                        Payment payment = (Payment)paymentDao.get(transaction.getPaymentId());
                        paymentDao.delete(transaction.getPaymentId());
                        transaction.setStatus(TransactionStatus.REFUNDED.getCode());
                        transaction.setPaymentId(0);
                        this.update(transaction);
                        if (payment != null) {
                            try (BalanceUtils bu = new BalanceUtils(this.con);){
                                bu.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                            }
                            EventProcessor.getInstance().publishAfterCommit((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum().negate()));
                        }
                    }
                } else {
                    error = true;
                }
                break block26;
            }
            error = true;
        }
        return error;
    }

    public Transaction registerOrder(int contractId, String contractTitle, String customerAddress, BigDecimal sum, Map<String, Object> dataMap, boolean autopaymentTransaction, boolean requestBindingId, BGTransactionType transactionType, String paymentPhone) throws Exception {
        return this.registerOrder(contractId, contractTitle, customerAddress, sum, dataMap, autopaymentTransaction, requestBindingId, "", transactionType, paymentPhone);
    }

    public Transaction registerOrder(int contractId, String contractTitle, String customerAddress, BigDecimal sum, Map<String, Object> dataMap, boolean autopaymentTransaction, boolean requestBindingId, String returnUrl, BGTransactionType transactionType, String paymentPhone) throws Exception {
        if (autopaymentTransaction || requestBindingId) {
            TinkoffAutopaymentSumEvent event = new TinkoffAutopaymentSumEvent(this.moduleId, contractId, sum);
            BigDecimal newSum = ((TinkoffAutopaymentSumEvent)EventProcessor.getInstance().request((QueueEvent)event)).getSum();
            if (newSum != null) {
                sum = newSum;
            }
        }
        Date date = new Date();
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setSum(sum)).setContractId(contractId)).setCreateDate(date)).setTransactionDate(date)).setTransactionType(transactionType)).setAutopayment(autopaymentTransaction)).build();
        this.update(transaction);
        String description = this.moduleSetup.get("tinkoff.init.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116 {CONTRACT_TITLE}");
        description = description.replace("{CONTRACT_TITLE}", contractTitle);
        JSONObject requestJsonObject = new JSONObject();
        requestJsonObject.put("TerminalKey", (Object)this.moduleSetup.get("tinkoff.terminal.key", ""));
        requestJsonObject.put("Amount", (Object)String.valueOf(sum.multiply(new BigDecimal(100)).setScale(0).intValue()));
        requestJsonObject.put("OrderId", (Object)String.valueOf(transaction.getId()));
        requestJsonObject.put("Description", (Object)description);
        requestJsonObject.put("Language", (Object)this.moduleSetup.get("tinkoff.init.language", "ru"));
        StringBuilder clientId = new StringBuilder();
        String billingName = this.moduleSetup.get("tinkoff.billing.name", Setup.getSetup().get("billing.name"));
        if (billingName != null) {
            clientId.append(billingName).append("_");
        }
        clientId.append(this.moduleId).append("_").append(contractId);
        requestJsonObject.put("CustomerKey", (Object)clientId.toString());
        requestJsonObject.put("PayType", (Object)"O");
        if (requestBindingId) {
            requestJsonObject.put("Recurrent", (Object)"Y");
        }
        this.addRequestParameter(requestJsonObject, "NotificationURL", "tinkoff.init.notification.url", null);
        if (!autopaymentTransaction) {
            this.addRequestParameter(requestJsonObject, "SuccessURL", "tinkoff.init.success.url", returnUrl);
            this.addRequestParameter(requestJsonObject, "FailURL", "tinkoff.init.fail.url", returnUrl);
        }
        requestJsonObject.put("Token", (Object)this.getToken(requestJsonObject, this.moduleSetup.get("tinkoff.terminal.pswd", "")));
        if (transactionType == BGTransactionType.CARD && Utils.notBlankString((String)paymentPhone)) {
            JSONObject dataJsonObject = new JSONObject();
            dataJsonObject.put("Phone", (Object)paymentPhone);
            requestJsonObject.put("DATA", (Object)dataJsonObject);
        }
        if (this.moduleSetup.getBoolean("tinkoff.fiscalization.enable", false)) {
            JSONObject receiptJsonObject = new JSONObject();
            String ffdVersion = this.moduleSetup.get("tinkoff.fiscalization.receipt.ffd.version", "1.05");
            if ("1.05".equals(ffdVersion)) {
                this.ffdVersion1_05(receiptJsonObject, customerAddress, contractTitle, sum);
            } else if ("1.2".equals(ffdVersion)) {
                this.ffdVersion1_2(receiptJsonObject, customerAddress, contractTitle, sum);
            }
            requestJsonObject.put("Receipt", (Object)receiptJsonObject);
        }
        this.doRequest(this.moduleSetup.get("tinkoff.init.url", "https://securepay.tinkoff.ru/v2/Init"), requestJsonObject, dataMap, transaction);
        if (dataMap.containsKey("PaymentId")) {
            String paymentId = String.valueOf(dataMap.get("PaymentId"));
            if (BGTransactionType.QR_SBP.equals((Object)transactionType)) {
                requestJsonObject = new JSONObject().put("TerminalKey", (Object)this.moduleSetup.get("tinkoff.terminal.key", "")).put("PaymentId", dataMap.get("PaymentId")).put("DataType", (Object)"PAYLOAD").put("Token", (Object)this.getToken(requestJsonObject, this.moduleSetup.get("tinkoff.terminal.pswd", "")).toLowerCase());
                this.doRequest(this.moduleSetup.get("tinkoff.sbp.get.qr.url", "https://securepay.tinkoff.ru/v2/GetQr"), requestJsonObject, dataMap, transaction);
            }
            TransactionManager.addTransactionParameters(transaction, "PaymentId=" + paymentId);
            transaction.setTransactionId(paymentId);
            this.update(transaction);
        } else if (dataMap.containsKey("ErrorCode") && !"0".equals(dataMap.get("ErrorCode"))) {
            transaction.setStatus(TransactionStatus.ERROR.getCode());
            TransactionManager.addTransactionParameters(transaction, "ErrorCode=" + dataMap.get("ErrorCode"));
            TransactionManager.addTransactionParameters(transaction, "Message=" + dataMap.get("Message"));
            TransactionManager.addTransactionParameters(transaction, "Details=" + dataMap.get("Details"));
            this.update(transaction);
        } else {
            transaction.setStatus(TransactionStatus.ERROR.getCode());
            this.update(transaction);
        }
        return transaction;
    }

    private void ffdVersion1_2(JSONObject receiptJsonObject, String customerAddress, String contractTitle, BigDecimal sum) {
        receiptJsonObject.put("FfdVersion", (Object)"1.2");
        receiptJsonObject.put("Taxation", (Object)this.moduleSetup.get("tinkoff.fiscalization.receipt.taxation", "osn"));
        if (!Utils.isBlankString((String)customerAddress)) {
            if (customerAddress.contains("@")) {
                receiptJsonObject.put("Email", (Object)customerAddress);
            } else {
                receiptJsonObject.put("Phone", (Object)customerAddress);
            }
        }
        JSONObject itemJsonObject = new JSONObject().put("Name", (Object)this.moduleSetup.get("tinkoff.fiscalization.receipt.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle)).put("Price", sum.multiply(new BigDecimal(100)).setScale(0).intValue()).put("Quantity", this.moduleSetup.getInt("tinkoff.fiscalization.receipt.qty", 1)).put("Amount", sum.multiply(new BigDecimal(100)).setScale(0).intValue()).put("PaymentMethod", (Object)this.moduleSetup.get("tinkoff.fiscalization.receipt.payment.method", "full_payment")).put("PaymentObject", (Object)this.moduleSetup.get("tinkoff.fiscalization.receipt.payment.object", "payment")).put("Tax", (Object)this.moduleSetup.get("tinkoff.fiscalization.receipt.tax", "none")).put("MeasurementUnit", (Object)"\u0435\u0434.");
        JSONArray itemsJsonArray = new JSONArray().put((Object)itemJsonObject);
        receiptJsonObject.put("Items", (Object)itemsJsonArray);
    }

    private void ffdVersion1_05(JSONObject receiptJsonObject, String customerAddress, String contractTitle, BigDecimal sum) {
        if (!Utils.isBlankString((String)customerAddress)) {
            if (customerAddress.contains("@")) {
                receiptJsonObject.put("Email", (Object)customerAddress);
            } else {
                receiptJsonObject.put("Phone", (Object)customerAddress);
            }
        }
        receiptJsonObject.put("Taxation", (Object)this.moduleSetup.get("tinkoff.fiscalization.receipt.taxation", "osn"));
        JSONObject itemJsonObject = new JSONObject();
        itemJsonObject.put("Name", (Object)this.moduleSetup.get("tinkoff.fiscalization.receipt.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle));
        itemJsonObject.put("Price", sum.multiply(new BigDecimal(100)).setScale(0).intValue());
        itemJsonObject.put("Quantity", this.moduleSetup.getInt("tinkoff.fiscalization.receipt.qty", 1));
        itemJsonObject.put("Amount", sum.multiply(new BigDecimal(100)).setScale(0).intValue());
        itemJsonObject.put("PaymentMethod", (Object)this.moduleSetup.get("tinkoff.fiscalization.receipt.payment.method", "full_payment"));
        itemJsonObject.put("PaymentObject", (Object)this.moduleSetup.get("tinkoff.fiscalization.receipt.payment.object", "payment"));
        itemJsonObject.put("Tax", (Object)this.moduleSetup.get("tinkoff.fiscalization.receipt.tax", "none"));
        JSONArray itemsJsonArray = new JSONArray();
        itemsJsonArray.put((Object)itemJsonObject);
        receiptJsonObject.put("Items", (Object)itemsJsonArray);
    }

    private void doRequest(String url, JSONObject requestJsonObject, Map<String, Object> dataMap, Transaction transaction) throws BGException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: " + requestJsonObject.toString());
        }
        StringBuilder resultJson = null;
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("Content-Type", "application/json; charset=UTF-8");
            resultJson = this.doConnection(url, "POST", true, requestJsonObject.toString(), props);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\t\u041e\u0442\u0432\u0435\u0442: " + String.valueOf(resultJson));
            }
            JSONObject resultJsonObject = new JSONObject(resultJson.toString());
            for (String key : resultJsonObject.keySet()) {
                if (!resultJsonObject.has(key)) continue;
                dataMap.put(key, resultJsonObject.get(key));
            }
            TransactionManager.addTransactionParameters(transaction, "resultJson=" + resultJson.toString());
        }
        catch (Exception ex) {
            this.getLogger().error(ex.getMessage());
        }
    }

    public void doCancelTransaction(int transactionId) throws Exception {
        Transaction transaction = (Transaction)this.get(transactionId);
        if (transaction != null) {
            JSONObject requestJsonObject = new JSONObject();
            requestJsonObject.put("TerminalKey", (Object)this.moduleSetup.get("tinkoff.terminal.key", ""));
            requestJsonObject.put("PaymentId", (Object)String.valueOf(transaction.getTransactionId()));
            requestJsonObject.put("Token", (Object)this.getToken(requestJsonObject, this.moduleSetup.get("tinkoff.terminal.pswd", "")));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: " + requestJsonObject.toString());
            }
            StringBuilder resultJson = null;
            try {
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("Content-Type", "application/json; charset=UTF-8");
                resultJson = this.doConnection(this.moduleSetup.get("tinkoff.cancel.url", "https://securepay.tinkoff.ru/v2/Cancel"), "POST", true, requestJsonObject.toString(), props);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\t\u041e\u0442\u0432\u0435\u0442: " + String.valueOf(resultJson));
                }
            }
            catch (Exception ex) {
                this.getLogger().error(ex.getMessage());
            }
            try {
                this.check(transaction, new JSONObject(resultJson.toString()));
            }
            catch (JSONException ex) {
                this.logError(ex);
            }
        }
    }

    public void doCharge(Transaction transaction, Autopayment autopayment) throws Exception {
        if (transaction != null && autopayment != null) {
            String rebuillId = autopayment.getAccessToken();
            if (rebuillId != null) {
                JSONObject resultJsonObject;
                JSONObject requestJsonObject = new JSONObject();
                requestJsonObject.put("TerminalKey", (Object)this.moduleSetup.get("tinkoff.terminal.key", ""));
                requestJsonObject.put("PaymentId", (Object)String.valueOf(transaction.getTransactionId()));
                requestJsonObject.put("RebillId", (Object)rebuillId);
                requestJsonObject.put("Token", (Object)this.getToken(requestJsonObject, this.moduleSetup.get("tinkoff.terminal.pswd", "")));
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: " + requestJsonObject.toString());
                }
                StringBuilder resultJson = null;
                try {
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("Content-Type", "application/json; charset=UTF-8");
                    resultJson = this.doConnection(this.moduleSetup.get("tinkoff.charge.url", "https://securepay.tinkoff.ru/v2/Charge"), "POST", true, requestJsonObject.toString(), props);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("\t\u041e\u0442\u0432\u0435\u0442: " + String.valueOf(resultJson));
                    }
                }
                catch (Exception ex) {
                    this.getLogger().error(ex.getMessage());
                }
                if (resultJson != null && (resultJsonObject = new JSONObject(resultJson.toString())) != null) {
                    this.check(transaction, resultJsonObject);
                }
            } else {
                this.getLogger().error("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d, \u0442\u0430\u043a \u043a\u0430\u043a \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d rebuillId = " + rebuillId);
            }
        }
    }

    public void addTransactionPayment(Transaction transaction, String transactionParameters) throws Exception {
        if (this.update(transaction, TransactionStatus.APPROVED)) {
            Payment payment = Payment.builder().setDate(new Date()).setTypeId(this.moduleSetup.getInt("tinkoff.payment.type.id", 0)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(this.moduleSetup.get("tinkoff.payment.comment", "\u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u0422\u0438\u043d\u044c\u043a\u043e\u0444\u0444").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId()))).build();
            try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
                new PaymentDao(this.con).update((Object)payment);
                balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
            }
            transaction.setPaymentId(payment.getId());
            transaction.setTransactionDate(new Date());
            TransactionManager.addTransactionParameters(transaction, transactionParameters);
            this.update(transaction);
            try {
                if (this.con != null && !this.con.getAutoCommit()) {
                    this.con.commit();
                }
                EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getDate(), payment.getSum()));
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public static void addTransactionParameters(Transaction transaction, String params) {
        if (transaction != null && Utils.notBlankString((String)params)) {
            Object newParams = transaction.getParameters();
            if (newParams != null && !((String)newParams).endsWith("\n")) {
                newParams = (String)newParams + "\n";
            }
            transaction.setParameters((String)newParams + params);
        }
    }

    protected void setConnectionTimeout(HttpsURLConnection connection) {
        connection.setConnectTimeout(this.moduleSetup.getInt("tinkoff.request.timeout", 10000));
        connection.setReadTimeout(this.moduleSetup.getInt("tinkoff.request.read.timeout", 5000));
    }

    public String getToken(JSONObject requestJsonObject, String password) {
        ArrayList<CallSite> tokenData = new ArrayList<CallSite>();
        for (String key : requestJsonObject.keySet()) {
            if ("Token".equals(key)) continue;
            tokenData.add((CallSite)((Object)(key + ":" + requestJsonObject.get(key))));
        }
        tokenData.add((CallSite)((Object)("Password:" + password)));
        Collections.sort(tokenData);
        if (this.getLogger().isDebugEnabled()) {
            tokenData.forEach(i -> this.getLogger().debug(i));
        }
        StringBuffer buffer = new StringBuffer();
        for (String string : tokenData) {
            int pos = string.indexOf(58);
            buffer.append(string.substring(pos + 1));
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("tokenData = {}", (Object)buffer.toString());
        }
        return Utils.getDigest((String)buffer.toString(), (String)"UTF-8", (String)"SHA-256", (boolean)false);
    }

    private void addRequestParameter(JSONObject requestJsonObject, String requestParameter, String key, String defaultValue) {
        String value = this.moduleSetup.get(key, defaultValue);
        if (value != null) {
            requestJsonObject.put(requestParameter, (Object)value);
        }
    }
}

