/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action.web;

import bitel.billing.server.ActionBase;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.modules.ipn.server.bean.IPNContractStatusLogRecord;
import ru.bitel.bgbilling.modules.ipn.server.bean.IPNContractStatusManager;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.SearchResult;

public class ActionGateControl
extends ActionBase {
    private IPNContractStatusManager csm = null;
    private SearchResult<IPNContractStatusLogRecord> searchResult = null;

    public void doAction() throws Exception {
        int status_new = Utils.parseInt((String)this.getParameter("status", "-1"), (int)-1);
        if (this.cid >= 0 && this.mid > 0) {
            this.csm = new IPNContractStatusManager(this.con, this.mid, (Preferences)this.moduleSetup);
            int currentStatus = this.csm.getContractStatus(this.cid);
            if ((currentStatus == 0 || currentStatus == 1) && status_new >= 0) {
                this.csm.changeStatus(this.cid, status_new, -1, true);
            }
            GregorianCalendar now = new GregorianCalendar();
            ((Calendar)now).add(2, -2);
            this.searchResult = new SearchResult();
            this.searchResult.getPeriod().setDateFrom(now.getTime());
            this.csm.searchIPNContractStatusLogRecordList(this.searchResult, this.cid, true);
            this.setData();
        }
    }

    protected void setDataForXslt() {
        Element gate = this.createElement(this.rootNode, "gate");
        gate.setAttribute("status", String.valueOf(this.csm.getContractStatus(this.cid)));
        for (IPNContractStatusLogRecord logRecord : this.searchResult.getList()) {
            Element element = this.createElement(gate, "row");
            element.setAttribute("dt", TimeUtils.format((Date)logRecord.getDate(), (String)"dd.MM.yyyy HH:mm:ss"));
            element.setAttribute("action", String.valueOf(logRecord.getStatusId()));
            element.setAttribute("uid", String.valueOf(logRecord.getUserId()));
            element.setAttribute("comment", logRecord.getComment());
        }
    }

    protected void setDataToRequest() {
        this.dataMap.put("module", this.module);
        this.dataMap.put("mid", this.mid);
        this.dataMap.put("status", this.csm.getContractStatus(this.cid));
        this.dataMap.put("gate", this.searchResult.getList());
    }
}

