/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client.tariff;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class ServiceSetTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"services");
    private JPanel editor;
    private BGComboBox<IdTitle> serviceCombo;
    private Directory serviceDir;
    private int serviceId;
    private String serviceTitle;
    private JLabel view;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.serviceDir = this.getDirManager().getDirectory("services");
    }

    protected JPanel getEditorPanel() throws Exception {
        if (this.editor == null) {
            this.editor = new JPanel();
            this.editor.add(new JLabel(" => "));
            this.serviceCombo = new BGComboBox();
            this.buildDirectoryCombo(this.serviceDir, (JComboBox)this.serviceCombo);
            this.editor.add((Component)this.serviceCombo);
        }
        return this.editor;
    }

    public Component getView() throws Exception {
        if (this.view == null) {
            this.view = new JLabel();
            this.view.setIcon(icon);
        }
        this.extractData();
        StringBuilder sb = new StringBuilder();
        if (this.serviceId > 0) {
            sb.append("=>");
            sb.append(this.serviceTitle);
        }
        this.view.setText(sb.toString());
        return this.view;
    }

    private void extractData() throws Exception {
        Map data = this.getDataInHash();
        this.serviceId = Utils.parseInt((String)((String)data.get("serviceId")));
        this.serviceTitle = this.serviceDir.getValue(this.serviceId);
    }

    protected void loadData() throws Exception {
        this.extractData();
        this.setDirectoryItemSelection((JComboBox)this.serviceCombo, this.serviceId);
    }

    protected void editOk() {
        this.serviceId = this.getIdFromDirectoryCombo((JComboBox)this.serviceCombo);
        super.editOk();
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("serviceId", String.valueOf(this.serviceId));
        this.setDataInHash(data);
    }

    public void serializeToXML(Element el) throws Exception {
        this.extractData();
        super.serializeToXML(el);
        el.setAttribute("serviceId", String.valueOf(this.serviceId));
        this.serializeChildsToXML(el);
    }

    public void loadFromXML(Element el) throws Exception {
        this.serviceId = Utils.parseInt((String)el.getAttribute("serviceId"));
        this.serializeData();
        this.saveData();
        this.loadChildsFromXML(el);
    }
}

