/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractDirectoryIdDao;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttrListItem;

public class EntitySpecAttrListItemDao
extends AbstractDirectoryIdDao<EntitySpecAttrListItem> {
    private final int entitySpecAttrId;

    public EntitySpecAttrListItemDao(Connection con, int entitySpecAttrId) {
        super(con, 0, "entity_spec_attr_list");
        this.entitySpecAttrId = entitySpecAttrId;
    }

    protected EntitySpecAttrListItem getFromRS(ResultSet rs) throws SQLException, BGException {
        return new EntitySpecAttrListItem(rs.getInt("id"), rs.getInt("entitySpecAttrId"), rs.getString("title"));
    }

    protected void updateImpl(EntitySpecAttrListItem entitySpecAttrListItem) throws BGException {
        Objects.requireNonNull(entitySpecAttrListItem);
        boolean update = entitySpecAttrListItem.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?" + (update ? " WHERE entitySpecAttrId=? AND id=?" : ", entitySpecAttrId=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, entitySpecAttrListItem.getTitle());
            ps.setInt(index++, this.entitySpecAttrId);
            if (update) {
                ps.setInt(index++, entitySpecAttrListItem.getId());
            }
            ps.executeUpdate();
            if (!update) {
                entitySpecAttrListItem.setId(ServerUtils.lastInsertId(ps));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public EntitySpecAttrListItem get(String title) throws BGException {
        return (EntitySpecAttrListItem)this.get("title=?", new Object[]{title});
    }

    public List<EntitySpecAttrListItem> list() throws BGException {
        return this.list("entitySpecAttrId=?", null, new Object[]{this.entitySpecAttrId});
    }
}

