/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.traffic;

import ru.bitel.bgbilling.common.bean.IPUtils;

public class ServiceLink
implements Comparable<ServiceLink> {
    public static final int OUTGOING_PACKET = 1;
    public static final int INCOMING_PACKET = 2;
    private int pos;
    private int direct;
    private long addr1;
    private long addr2;
    private int port1 = 0;
    private int port2 = 65535;
    private int serviceId;

    public int getDirect() {
        return this.direct;
    }

    public void setDirect(int direct) {
        this.direct = direct;
    }

    public long getAddr1() {
        return this.addr1;
    }

    public void setAddr1(long addr1) {
        this.addr1 = addr1;
    }

    public long getAddr2() {
        return this.addr2;
    }

    public void setAddr2(long addr2) {
        this.addr2 = addr2;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    @Deprecated
    public int getServiceID() {
        return this.serviceId;
    }

    public int getPos() {
        return this.pos;
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }

    @Deprecated
    public void setServiceID(int serviceId) {
        this.serviceId = serviceId;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public boolean isCoinside(int direct, long addr, int port) {
        if (this.direct != 0 && this.direct != direct) {
            return false;
        }
        if (this.addr1 != 0L && this.addr1 > addr) {
            return false;
        }
        if (this.addr2 != 0L && this.addr2 < addr) {
            return false;
        }
        return this.port1 <= port && this.port2 >= port;
    }

    @Override
    public int compareTo(ServiceLink o) {
        return this.pos - o.getPos();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Service link ");
        result.append("[");
        result.append(IPUtils.convertLongIpToString((long)this.addr1));
        result.append("-");
        result.append(IPUtils.convertLongIpToString((long)this.addr2));
        result.append("; ");
        result.append(this.port1);
        result.append("-");
        result.append(this.port2);
        result.append("] => ");
        result.append(this.serviceId);
        return result.toString();
    }

    public int getPort1() {
        return this.port1;
    }

    public void setPort1(int port1) {
        this.port1 = port1;
    }

    public int getPort2() {
        return this.port2;
    }

    public void setPort2(int port2) {
        this.port2 = port2;
    }
}

