/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.modules.mobile.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.reports.server.modules.mobile.MobileParamType;
import ru.bitel.bgbilling.modules.reports.server.modules.mobile.MobileReport;
import ru.bitel.bgbilling.modules.reports.server.modules.mobile.MobileReportType;
import ru.bitel.bgbilling.modules.reports.server.modules.mobile.Slice;
import ru.bitel.common.TimeUtils;

public class PaymentsByTypes
extends MobileReport {
    private String PDateFrom = "d1";
    private String PDateTo = "d2";
    private String PShow = "f1";

    @Override
    public MobileReportType getReportType(Connection con) {
        ArrayList<MobileParamType> list = new ArrayList<MobileParamType>();
        Calendar calendar = Calendar.getInstance();
        Calendar now = (Calendar)calendar.clone();
        calendar.add(6, -2);
        list.add(new MobileParamType(this.PDateFrom, 1, "\u041e\u0442 \u0434\u0430\u0442\u044b", TimeUtils.format((Calendar)calendar, (String)"dd.MM.yyyy")));
        list.add(new MobileParamType(this.PDateTo, 1, "\u0414\u043e \u0434\u0430\u0442\u044b", TimeUtils.format((Calendar)now, (String)"dd.MM.yyyy")));
        list.add(new MobileParamType(this.PShow, 5, "\u041d\u0435 \u0432\u044b\u0434\u043e\u0432\u0430\u0442\u044c < 1%", "true"));
        return new MobileReportType("\u041f\u0440\u0438\u0445\u043e\u0434\u044b \u043f\u043e \u0442\u0438\u043f\u0430\u043c", list);
    }

    @Override
    public List<Object> getData() throws BGIllegalArgumentException {
        this.grafType = 2;
        ArrayList<Object> list = new ArrayList<Object>();
        String query = "SELECT SUM(summa),pt.title FROM contract_payment AS cp LEFT JOIN contract_payment_types AS pt ON cp.pt=pt.id WHERE cp.dt>=? AND cp.dt<=? GROUP BY pt";
        Date now = new Date();
        Date dateFrom = this.getDateParameter(this.PDateFrom, now);
        Date dateTo = this.getDateParameter(this.PDateTo, now);
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)dateFrom));
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)dateTo));
            ResultSet rs = ps.executeQuery();
            double sum = 0.0;
            boolean flag1 = this.getBooleanParameter(this.PShow);
            while (rs.next()) {
                if (flag1) {
                    sum += rs.getDouble(1);
                }
                list.add(new Slice(rs.getString(2), this.getColor(), rs.getDouble(1)));
            }
            if (flag1) {
                ArrayList<Object> result = new ArrayList<Object>();
                double other = 0.0;
                for (Object obj : list) {
                    Slice slice = (Slice)obj;
                    if (slice.getCount() / sum < 0.01) {
                        other += slice.getCount();
                        continue;
                    }
                    result.add(slice);
                }
                if (other > 0.0 && other / sum > 0.01) {
                    result.add(new Slice("\u0414\u0440\u0443\u0433\u0438\u0435", this.getColor(), other));
                }
                return result;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public Map<String, Object> getOptions() {
        return null;
    }
}

