/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.payture.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.modules.payture.common.bean.Transaction;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public TransactionManager(Connection con, int mid) {
        super(con, mid, "payture_payment");
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String status) throws SQLException {
        if (searchResult != null) {
            ResultSet rs;
            int index;
            Page page = searchResult.getPage();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            StringBuilder query = new StringBuilder(" FROM ").append(this.tableName).append(" AS pt ").append("LEFT JOIN contract c ON c.id=pt.contract_id WHERE true");
            if (period != null) {
                if (period.getDateFrom() != null) {
                    query.append(" AND pt.payment_date>=?");
                }
                if (period.getDateTo() != null) {
                    query.append(" AND pt.payment_date<=?");
                }
            }
            if (Utils.notBlankString((String)status)) {
                query.append(" AND pt.status=?");
            }
            if (Utils.notBlankString((String)contractTitle)) {
                query.append(" AND c.title LIKE ?");
            }
            if (contractId > 0) {
                query.append(" AND c.id=").append(contractId);
            }
            try (PreparedStatement ps = this.con.prepareStatement("SELECT pt.*, c.title " + query.toString() + (page != null ? page.sqlLimit() : ""));){
                index = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                    }
                }
                if (Utils.notBlankString((String)status)) {
                    ps.setString(index++, status);
                }
                if (Utils.notBlankString((String)contractTitle)) {
                    ps.setString(index++, "%" + contractTitle + "%");
                }
                rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        list.add(this.getFromRS(rs));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            ps = this.con.prepareStatement("SELECT SUM(pt.payment_summ), COUNT(*) " + query.toString());
            try {
                index = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                    }
                }
                if (Utils.notBlankString((String)status)) {
                    ps.setString(index++, status);
                }
                if (Utils.notBlankString((String)contractTitle)) {
                    ps.setString(index++, "%" + contractTitle + "%");
                }
                rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        BigDecimal summa;
                        if (page != null) {
                            page.setRecordCount(rs.getInt(2));
                        }
                        if ((summa = rs.getBigDecimal(1)) == null) continue;
                        searchResult.setSum(summa);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "contract_id=?, status=?, payment_date=?, payment_summ=?";
        try (PreparedStatement ps = this.prepareStatement((Id)transaction, querySet);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setString(index++, transaction.getStatus());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            ps.setBigDecimal(index++, transaction.getSum());
            this.executeUpdate((Id)transaction, index, ps);
        }
    }

    public Transaction get(int id) throws SQLException {
        Transaction result = null;
        String query = "SELECT pt.*, c.title FROM " + this.tableName + " AS pt  LEFT JOIN contract c ON c.id=pt.contract_id WHERE pt.id=" + id;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = this.getFromRS(rs);
            }
        }
        return result;
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("pt.id"))).setContractId(rs.getInt("pt.contract_id"))).setContractTitle(rs.getString("c.title"))).setTransactionDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("pt.payment_date")))).setSum(rs.getBigDecimal("pt.payment_summ"))).setStatus(rs.getString("pt.status"))).build();
    }
}

