/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rurupay.server.bean;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.rurupay.common.bean.RuRuPayCancelReason;
import ru.bitel.bgbilling.modules.rurupay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.rurupay.common.bean.TransactionStatus;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;
import ru.bitel.common.util.Templater;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public static String DEFAULT_PAYMENT_COMMENT = "\u041e\u043f\u043b\u0430\u0442\u0430 \u043f\u043e \u0434\u043e\u0433. {$contract.getTitle} ({$contract.getComment}) \u0447\u0435\u0440\u0435\u0437 RuRu \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 {$payment.getSum} \u043e\u0442 {$date}";

    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "rurupay_payments");
    }

    public void searchTransactionList(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String status) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            String[] sort = searchResult.getSort();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            if (page == null) {
                page = new Page(1, Integer.MAX_VALUE);
            }
            StringBuilder query = new StringBuilder(" FROM ").append(this.tableName).append(" AS payments ").append("LEFT JOIN contract c ON c.id=payments.cid WHERE true");
            if (period != null) {
                if (period.getDateFrom() != null) {
                    query.append(" AND payments.date>=?");
                }
                if (period.getDateTo() != null) {
                    query.append(" AND payments.date<?");
                }
            }
            if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
                query.append(" AND payments.status=?");
            }
            if (Utils.notBlankString((String)contractTitle)) {
                query.append(" AND contractTitle LIKE ?");
            }
            if (contractId > 0) {
                query.append(" AND payments.cid=").append(contractId);
            }
            try {
                ResultSet rs = null;
                PreparedStatement ps = null;
                ps = this.con.prepareStatement("SELECT SUM(payments.sum), COUNT(*) " + query.toString());
                this.setSQLParameter(ps, period, status, contractTitle);
                rs = ps.executeQuery();
                while (rs.next()) {
                    BigDecimal sum = rs.getBigDecimal(1);
                    if (sum != null) {
                        searchResult.setSum(sum);
                    }
                    page.setRecordCount(rs.getInt(2));
                }
                rs.close();
                ps.close();
                if (page.getPageIndex() > page.getPageCount()) {
                    page.setPageIndex(page.getPageCount());
                }
                ps = this.con.prepareStatement("SELECT payments.*, c.title AS contractTitle, c.comment AS contractComment" + query.toString() + this.getSQLOrder(sort, this.fields) + (page != null ? page.sqlLimit() : ""));
                this.setSQLParameter(ps, period, status, contractTitle);
                rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
                rs.close();
                ps.close();
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    private int setSQLParameter(PreparedStatement ps, Period period, String status, String contractTitle) throws SQLException {
        int parameterIndex = 1;
        if (period != null) {
            if (period.getDateFrom() != null) {
                ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
            }
            if (period.getDateTo() != null) {
                ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
            }
        }
        if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
            ps.setString(parameterIndex++, status);
        }
        if (Utils.notBlankString((String)contractTitle)) {
            ps.setString(parameterIndex++, "%" + contractTitle + "%");
        }
        return parameterIndex;
    }

    public Result<Transaction> getList(Period period, Page page, int cid, int statusmask) throws BGException {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        try {
            StringBuffer query = new StringBuffer(500);
            query.append("SELECT SQL_CALC_FOUND_ROWS payments.*, contract.title AS contractTitle, contract.comment AS contractComment ");
            query.append("FROM " + this.tableName + " AS payments ");
            query.append("LEFT JOIN contract ON payments.cid=contract.id ");
            query.append("WHERE (1=1) ");
            if (period != null && period.getDateFrom() != null) {
                query.append(" AND payments.date>='");
                query.append(TimeUtils.format((Date)period.getDateFrom(), (String)"yyyy-MM-dd"));
                query.append("'");
            }
            if (period != null && period.getDateTo() != null) {
                query.append(" AND payments.date<=DATE_ADD('");
                query.append(TimeUtils.format((Date)period.getDateTo(), (String)"yyyy-MM-dd"));
                query.append("', INTERVAL 1 DAY )");
            }
            if (cid > 0) {
                query.append(" AND payments.cid=" + cid);
            }
            query.append(" AND (payments.status&" + statusmask + "!=0) ");
            query.append(" ORDER BY payments.date ");
            query.append(page != null ? page.sqlLimit() : "");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return new Result(result, page);
    }

    public Transaction getByOrder(String order) throws BGException {
        Transaction result = null;
        try {
            String query = "SELECT payments.*, contract.title AS contractTitle, contract.comment AS contractComment FROM " + this.tableName + " AS payments LEFT JOIN contract ON payments.cid=contract.id WHERE payments.order=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, order);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public void updateLogEntry(Transaction transaction) throws BGException {
        try {
            if (transaction.getTransactionDate() == null || transaction.getSum() == null) {
                throw new BGException("error data");
            }
            String query = null;
            query = transaction.getId() > 0 ? "UPDATE `" + this.tableName + "` SET `cid`=?,`date`=?,`sum`=?,`status`=?,`cancel_reason`=?,`order`=? WHERE `id`=?" : "INSERT INTO `" + this.tableName + "` (`cid`,`date`,`sum`,`status`,`cancel_reason`,`order`) VALUES (?, ?, ?, ?, ?, ?)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, transaction.getContractId());
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            ps.setBigDecimal(3, transaction.getSum());
            ps.setString(4, transaction.getStatus());
            if (transaction.getCancelReason() != null) {
                ps.setInt(5, transaction.getCancelReason().getCode());
            } else {
                ps.setNull(5, 4);
            }
            ps.setString(6, transaction.getOrder());
            if (transaction.getId() > 0) {
                ps.setInt(7, transaction.getId());
            }
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void carryOutPayment(Transaction transaction, Preferences moduleSetup) throws Exception {
        if (transaction != null && transaction.getStatus().equals(TransactionStatus.OK.getCode())) {
            int paymentType = moduleSetup.getInt("paymenttype", 0);
            String commentTemplate = moduleSetup.get("payment_comment", DEFAULT_PAYMENT_COMMENT);
            Contract contract = new ContractManager(this.con).getContractById(transaction.getContractId());
            String comment = new Templater(commentTemplate).replaceFields("contract.", (Object)contract).replaceFields("payment.", (Object)transaction).replaceString("sum", Utils.formatCost((BigDecimal)transaction.getSum())).replaceString("date", TimeUtils.format((Date)transaction.getTransactionDate(), (String)"dd.MM.yyyy HH:mm:ss")).getString();
            Payment payment = Payment.builder().setDate(transaction.getTransactionDate()).setTypeId(paymentType).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(comment).build();
            new PaymentDao(this.con).update((Object)payment);
            ServerUtils.commitConnection((Connection)this.con);
            try (BalanceUtils bu = new BalanceUtils(this.con);){
                bu.updateBalance(transaction.getTransactionDate(), contract);
            }
            ServerUtils.commitConnection((Connection)this.con);
            EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contract.getId(), 3, payment.getSum()));
        }
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("payments.id"))).setContractId(rs.getInt("payments.cid"))).setTransactionDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("payments.date")))).setSum(rs.getBigDecimal("payments.sum"))).setOrder(rs.getString("payments.order")).setContractTitle(rs.getString("contractTitle"))).setContractComment(rs.getString("contractComment"))).setStatus(rs.getString("payments.status"))).build();
        int cancel_reason = rs.getInt("payments.cancel_reason");
        if (rs.wasNull()) {
            transaction.setCancelReason(null);
        } else {
            transaction.setCancelReason((RuRuPayCancelReason)Utils.getListItemEnumFromId(RuRuPayCancelReason.class, (int)cancel_reason, (Enum)RuRuPayCancelReason.UNKNOWN));
        }
        return transaction;
    }

    protected void updateImpl(Transaction b) throws SQLException {
    }
}

